/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.config;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashMap;
import java.util.List;
import org.eclipse.xtend.core.idea.config.GradleBuildFileUtility;
import org.eclipse.xtend.core.idea.config.MavenArtifact;
import org.eclipse.xtend.core.idea.config.MavenUtility;
import org.eclipse.xtend.core.idea.framework.XtendLibraryDescription;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.idea.util.PlatformUtil;
import org.eclipse.xtext.idea.util.ProjectLifecycleUtil;
import org.eclipse.xtext.util.XtextVersion;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.jetbrains.annotations.Nullable;

public class XtendLibraryConfigurator {
    private static final Logger LOG = Logger.getInstance((String)XtendLibraryConfigurator.class.getName());
    private static MavenArtifact XTEND_LIB_MAVEN_ID;
    @Inject
    @Extension
    private GradleBuildFileUtility _gradleBuildFileUtility;
    @Inject
    @Extension
    private ProjectLifecycleUtil _projectLifecycleUtil;
    @Inject
    @Extension
    private PlatformUtil _platformUtil;
    @Inject
    @Extension
    private MavenUtility _mavenUtility;
    @Inject
    private XtendLibraryDescription xtendLibDescr;

    public void ensureXtendLibAvailable(ModifiableRootModel rootModel) {
        this.ensureXtendLibAvailable(rootModel, null);
    }

    public void ensureXtendLibAvailable(final ModifiableRootModel rootModel, final @Nullable PsiFile context) {
        Project _project = rootModel.getProject();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                XtendLibraryConfigurator.this.doEnsureXtendLibAvailable(rootModel, context);
            }
        };
        this._projectLifecycleUtil.executeWhenProjectReady(_project, _function);
    }

    protected void doEnsureXtendLibAvailable(ModifiableRootModel rootModel, @Nullable PsiFile context) {
        String _name;
        Module module = rootModel.getModule();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        Project _project = rootModel.getProject();
        JavaPsiFacade _instance = JavaPsiFacade.getInstance((Project)_project);
        PsiClass psiClass = _instance.findClass(_name = Data.class.getName(), scope);
        boolean _equals = Objects.equal((Object)psiClass, null);
        if (_equals) {
            boolean _isMavenizedModule;
            boolean testScope = this.isTestScope(context);
            boolean _and = false;
            boolean _isMavenInstalled = this._platformUtil.isMavenInstalled();
            _and = !_isMavenInstalled ? false : (_isMavenizedModule = this._mavenUtility.isMavenizedModule(module));
            if (_and) {
                this._mavenUtility.addXtendLibMavenDependency(module, testScope);
            } else {
                boolean _isGradleedModule;
                boolean _and_1 = false;
                boolean _isGradleInstalled = this._platformUtil.isGradleInstalled();
                _and_1 = !_isGradleInstalled ? false : (_isGradleedModule = this._gradleBuildFileUtility.isGradleedModule(module));
                if (_and_1) {
                    this._gradleBuildFileUtility.addXtendLibGradleDependency(module, testScope);
                } else {
                    this.addJavaRuntimeLibrary(module, rootModel);
                }
            }
        }
    }

    public static MavenArtifact xtendLibMavenId() {
        if (XTEND_LIB_MAVEN_ID == null) {
            MavenArtifact _mavenArtifact;
            XtextVersion _current = XtextVersion.getCurrent();
            String version = _current.getVersion();
            LOG.info("The current Xtend plugin version is " + version);
            XTEND_LIB_MAVEN_ID = _mavenArtifact = new MavenArtifact("org.eclipse.xtend", "org.eclipse.xtend.lib", version);
        }
        return XTEND_LIB_MAVEN_ID;
    }

    public void addJavaRuntimeLibrary(Module module, ModifiableRootModel rootModel) {
        boolean _isWritable;
        LibraryOrderEntry _findLibraryOrderEntry;
        boolean _tripleEquals;
        boolean _notEquals;
        Library library = this.createOrGetXtendJavaLibrary(rootModel, module);
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)library, null);
        _and = !_notEquals ? false : (_tripleEquals = (_findLibraryOrderEntry = rootModel.findLibraryOrderEntry(library)) == null);
        if (_and && (_isWritable = rootModel.isWritable())) {
            rootModel.addLibraryEntry(library);
        }
    }

    public Library createOrGetXtendJavaLibrary(ModifiableRootModel rootModel, Module module) {
        boolean _not;
        Functions.Function1<Library, Boolean> _function;
        LibraryTablesRegistrar _instance = LibraryTablesRegistrar.getInstance();
        Project _project = module.getProject();
        LibraryTable _libraryTable = _instance.getLibraryTable(_project);
        Library[] _libraries = _libraryTable.getLibraries();
        LibraryTablesRegistrar _instance_1 = LibraryTablesRegistrar.getInstance();
        LibraryTable _libraryTable_1 = _instance_1.getLibraryTable();
        Library[] _libraries_1 = _libraryTable_1.getLibraries();
        Iterable libraryTable = Iterables.concat((Iterable)((Iterable)Conversions.doWrapArray((Object)_libraries)), (Iterable)((Iterable)Conversions.doWrapArray((Object)_libraries_1)));
        Iterable xtendLibs = IterableExtensions.filter((Iterable)libraryTable, (Functions.Function1)(_function = new Functions.Function1<Library, Boolean>(){

            public Boolean apply(Library it) {
                String _name = it.getName();
                boolean _startsWith = false;
                if (_name != null) {
                    _startsWith = _name.startsWith("Xtend Library");
                }
                return _startsWith;
            }
        }));
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)xtendLibs);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1<Library, Boolean> _function_1 = new Functions.Function1<Library, Boolean>(){

                public Boolean apply(Library it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)"Xtend Library");
                }
            };
            boolean _exists = IterableExtensions.exists((Iterable)xtendLibs, (Functions.Function1)_function_1);
            if (_exists) {
                Functions.Function1<Library, Boolean> _function_2 = new Functions.Function1<Library, Boolean>(){

                    public Boolean apply(Library it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)"Xtend Library");
                    }
                };
                return (Library)IterableExtensions.findFirst((Iterable)xtendLibs, (Functions.Function1)_function_2);
            }
            return (Library)IterableExtensions.head((Iterable)xtendLibs);
        }
        NewLibraryConfiguration libDescr = this.xtendLibDescr.createLibraryDescription();
        LibraryTable _moduleLibraryTable = rootModel.getModuleLibraryTable();
        LibraryTable.ModifiableModel model = _moduleLibraryTable.getModifiableModel();
        String _defaultLibraryName = libDescr.getDefaultLibraryName();
        Library createdLib = model.createLibrary(_defaultLibraryName);
        final Library.ModifiableModel libModel = createdLib.getModifiableModel();
        HashMap<OrderRootType, List<String>> _libraryRoots = this.xtendLibDescr.libraryRoots();
        Procedures.Procedure2<OrderRootType, List<String>> _function_3 = new Procedures.Procedure2<OrderRootType, List<String>>(){

            public void apply(final OrderRootType type, List<String> roots) {
                Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

                    public void apply(String it) {
                        libModel.addRoot(it, type);
                    }
                };
                IterableExtensions.forEach(roots, (Procedures.Procedure1)_function);
            }
        };
        MapExtensions.forEach(_libraryRoots, (Procedures.Procedure2)_function_3);
        libModel.commit();
        model.commit();
        return createdLib;
    }

    protected boolean isTestScope(@Nullable PsiFile context) {
        if (context == null) {
            return false;
        }
        PsiFile _originalFile = context.getOriginalFile();
        VirtualFile virtualFile = _originalFile.getVirtualFile();
        if (virtualFile != null) {
            Project _project = context.getProject();
            ProjectRootManager _instance = ProjectRootManager.getInstance((Project)_project);
            ProjectFileIndex _fileIndex = _instance.getFileIndex();
            return _fileIndex.isInTestSourceContent(virtualFile);
        }
        return false;
    }
}

