/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.completion;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.idea.completion.AbstractXtendCompletionContributor;
import org.eclipse.xtend.core.idea.editorActions.XtendTokenSetProvider;
import org.eclipse.xtend.core.idea.lang.XtendLanguage;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.idea.document.DocumentUtils;
import org.eclipse.xtext.idea.lang.AbstractXtextLanguage;
import org.eclipse.xtext.psi.XtextPsiExtensions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.ide.contentassist.OverrideProposalUtil;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XtendCompletionContributor
extends AbstractXtendCompletionContributor {
    @Inject
    @Extension
    private XtextPsiExtensions _xtextPsiExtensions;
    @Inject
    private XtendTokenSetProvider tokenSetProvider;
    @Inject
    private IJvmModelAssociations jvmModelAssociations;
    @Inject
    private OverrideProposalUtil overrideProposalUtil;
    @Inject
    private RewritableImportSection.Factory importSectionfactory;
    @Inject
    @Extension
    private DocumentUtils documentUtils;
    private static final String START_SELECTION_MARKER = "<START_SELECTION>";
    private static final String END_SELECTION_MARKER = "<END_SELECTION>";
    private static final String SELECTION_MARKER = "<CURSOR>";

    public XtendCompletionContributor() {
        this(XtendLanguage.INSTANCE);
    }

    public XtendCompletionContributor(AbstractXtextLanguage lang) {
        super(lang);
        this.completeAbstractSuperMethods();
        this.completeFrenchQuote();
    }

    protected void completeFrenchQuote() {
        TokenSet _richStringLiteralTokens = this.tokenSetProvider.getRichStringLiteralTokens();
        CompletionProvider<CompletionParameters> _function = new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(CompletionParameters $0, ProcessingContext $1, CompletionResultSet $2) {
                LookupElementBuilder _create = LookupElementBuilder.create((String)"\u00ab");
                InsertHandler<LookupElement> _function = new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        Editor _editor = context.getEditor();
                        EditorModificationUtil.insertStringAtCaret((Editor)_editor, (String)"\u00bb", (boolean)false, (boolean)false);
                    }
                };
                LookupElementBuilder _withInsertHandler = _create.withInsertHandler((InsertHandler)_function);
                XtendCompletionContributor.this._completionExtensions.operator_add($2, (LookupElement)_withInsertHandler);
            }
        };
        this.extend(CompletionType.BASIC, new TokenSet[]{_richStringLiteralTokens}, (CompletionProvider)_function);
    }

    protected void completeAbstractSuperMethods() {
        CompletionProvider<CompletionParameters> _function = new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(CompletionParameters $0, ProcessingContext $1, CompletionResultSet $2) {
                XtendTypeDeclaration clazz;
                boolean _equals;
                PsiElement psiElement = $0.getPosition();
                EObject _findEObject = XtendCompletionContributor.this._xtextPsiExtensions.findEObject(psiElement);
                XtendTypeDeclaration _containerOfType = null;
                if (_findEObject != null) {
                    _containerOfType = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)_findEObject, XtendTypeDeclaration.class);
                }
                if (_equals = Objects.equal((Object)(clazz = _containerOfType), null)) {
                    return;
                }
                EObject jvmType = XtendCompletionContributor.this.jvmModelAssociations.getPrimaryJvmElement((EObject)clazz);
                if (jvmType instanceof JvmGenericType) {
                    boolean _isAnonymous = clazz.isAnonymous();
                    List candidates = XtendCompletionContributor.this.overrideProposalUtil.getImplementationCandidates((JvmDeclaredType)jvmType, _isAnonymous);
                    for (final IResolvedExecutable candidate : candidates) {
                        if (candidate instanceof IResolvedOperation) {
                            InsertHandler<LookupElement> _function = new InsertHandler<LookupElement>(){

                                public void handleInsert(InsertionContext context, LookupElement item) {
                                    Document _document = context.getDocument();
                                    int _startOffset = context.getStartOffset();
                                    int _tailOffset = context.getTailOffset();
                                    _document.deleteString(_startOffset, _tailOffset);
                                    context.commitDocument();
                                    Resource _eResource = clazz.eResource();
                                    final RewritableImportSection importSection = XtendCompletionContributor.this.importSectionfactory.parse((XtextResource)_eResource);
                                    StringConcatenation _builder = new StringConcatenation();
                                    _builder.append((Object)"override ");
                                    List _typeParameters = ((IResolvedOperation)candidate).getTypeParameters();
                                    Functions.Function1<JvmTypeParameter, CharSequence> _function = new Functions.Function1<JvmTypeParameter, CharSequence>(){

                                        public CharSequence apply(JvmTypeParameter it) {
                                            return it.getName();
                                        }
                                    };
                                    String _join = IterableExtensions.join((Iterable)_typeParameters, (CharSequence)"<", (CharSequence)",", (CharSequence)"> ", (Functions.Function1)_function);
                                    _builder.append((Object)_join, "");
                                    JvmOperation _declaration = ((IResolvedOperation)candidate).getDeclaration();
                                    String _simpleName = _declaration.getSimpleName();
                                    _builder.append((Object)_simpleName, "");
                                    _builder.append((Object)"(");
                                    ArrayList<String> _parameterText = XtendCompletionContributor.this.getParameterText(candidate, importSection);
                                    String _join_1 = IterableExtensions.join(_parameterText, (CharSequence)", ");
                                    _builder.append((Object)_join_1, "");
                                    _builder.append((Object)") ");
                                    JvmOperation _declaration_1 = ((IResolvedOperation)candidate).getDeclaration();
                                    EList _exceptions = _declaration_1.getExceptions();
                                    Functions.Function1<JvmTypeReference, CharSequence> _function_1 = new Functions.Function1<JvmTypeReference, CharSequence>(){

                                        public CharSequence apply(JvmTypeReference it) {
                                            return XtendCompletionContributor.this.documentUtils.toImportableString(it, importSection);
                                        }
                                    };
                                    String _join_2 = IterableExtensions.join((Iterable)_exceptions, (CharSequence)"throws ", (CharSequence)", ", (CharSequence)" ", (Functions.Function1)_function_1);
                                    _builder.append((Object)_join_2, "");
                                    _builder.append((Object)"{");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)XtendCompletionContributor.START_SELECTION_MARKER, "\t");
                                    _builder.append((Object)"throw new UnsupportedOperationException()");
                                    _builder.append((Object)XtendCompletionContributor.END_SELECTION_MARKER, "\t");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"}");
                                    _builder.newLine();
                                    XtendCompletionContributor.this.insertAndAdjust(context, _builder.toString());
                                    Document _document_1 = context.getDocument();
                                    XtendCompletionContributor.this.documentUtils.updateImportSection(_document_1, importSection);
                                }
                            };
                            LookupElementBuilder _createOverrideMethodElement = XtendCompletionContributor.this.createOverrideMethodElement((IResolvedOperation)candidate, _function);
                            $2.addElement((LookupElement)_createOverrideMethodElement);
                            continue;
                        }
                        if (!(candidate instanceof IResolvedConstructor)) continue;
                        InsertHandler<LookupElement> _function_1 = new InsertHandler<LookupElement>(){

                            public void handleInsert(InsertionContext context, LookupElement item) {
                                Document _document = context.getDocument();
                                int _startOffset = context.getStartOffset();
                                int _tailOffset = context.getTailOffset();
                                _document.deleteString(_startOffset, _tailOffset);
                                context.commitDocument();
                                Resource _eResource = clazz.eResource();
                                final RewritableImportSection importSection = XtendCompletionContributor.this.importSectionfactory.parse((XtextResource)_eResource);
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"new (");
                                ArrayList<String> _parameterText = XtendCompletionContributor.this.getParameterText(candidate, importSection);
                                String _join = IterableExtensions.join(_parameterText, (CharSequence)", ");
                                _builder.append((Object)_join, "");
                                _builder.append((Object)") ");
                                JvmConstructor _declaration = ((IResolvedConstructor)candidate).getDeclaration();
                                EList _exceptions = _declaration.getExceptions();
                                Functions.Function1<JvmTypeReference, CharSequence> _function = new Functions.Function1<JvmTypeReference, CharSequence>(){

                                    public CharSequence apply(JvmTypeReference it) {
                                        return XtendCompletionContributor.this.documentUtils.toImportableString(it, importSection);
                                    }
                                };
                                String _join_1 = IterableExtensions.join((Iterable)_exceptions, (CharSequence)"throws ", (CharSequence)", ", (CharSequence)" ", (Functions.Function1)_function);
                                _builder.append((Object)_join_1, "");
                                _builder.append((Object)"{");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t");
                                _builder.append((Object)"super(");
                                JvmConstructor _declaration_1 = ((IResolvedConstructor)candidate).getDeclaration();
                                EList _parameters = _declaration_1.getParameters();
                                Functions.Function1<JvmFormalParameter, CharSequence> _function_1 = new Functions.Function1<JvmFormalParameter, CharSequence>(){

                                    public CharSequence apply(JvmFormalParameter it) {
                                        return it.getName();
                                    }
                                };
                                String _join_2 = IterableExtensions.join((Iterable)_parameters, (CharSequence)", ", (Functions.Function1)_function_1);
                                _builder.append((Object)_join_2, "\t");
                                _builder.append((Object)")");
                                _builder.append((Object)XtendCompletionContributor.SELECTION_MARKER, "\t");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"}");
                                _builder.newLine();
                                XtendCompletionContributor.this.insertAndAdjust(context, _builder.toString());
                                Document _document_1 = context.getDocument();
                                XtendCompletionContributor.this.documentUtils.updateImportSection(_document_1, importSection);
                            }
                        };
                        LookupElementBuilder _createOverrideConstructorElement = XtendCompletionContributor.this.createOverrideConstructorElement((IResolvedConstructor)candidate, _function_1);
                        $2.addElement((LookupElement)_createOverrideConstructorElement);
                    }
                }
            }
        };
        this.extend(CompletionType.BASIC, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__MEMBERS, (CompletionProvider)_function);
    }

    protected void insertAndAdjust(InsertionContext context, String toInsert) {
        String _replace_1;
        String _replace;
        int startIndex = toInsert.indexOf(START_SELECTION_MARKER);
        String cleanedText = toInsert.replace(START_SELECTION_MARKER, "");
        int endIndex = cleanedText.indexOf(END_SELECTION_MARKER);
        cleanedText = _replace = cleanedText.replace(END_SELECTION_MARKER, "");
        int cursorIndex = cleanedText.indexOf(SELECTION_MARKER);
        cleanedText = _replace_1 = cleanedText.replace(SELECTION_MARKER, "");
        int _xifexpression = 0;
        _xifexpression = cursorIndex != -1 ? cursorIndex : startIndex;
        int start = _xifexpression;
        int _xifexpression_1 = 0;
        _xifexpression_1 = cursorIndex != -1 ? cursorIndex : endIndex;
        int end = _xifexpression_1;
        Document _document = context.getDocument();
        int _startOffset = context.getStartOffset();
        _document.insertString(_startOffset, (CharSequence)cleanedText);
        Document _document_1 = context.getDocument();
        int _startOffset_1 = context.getStartOffset();
        int _startOffset_2 = context.getStartOffset();
        int _length = cleanedText.length();
        int _plus = _startOffset_2 + _length;
        RangeMarker fullChange = _document_1.createRangeMarker(_startOffset_1, _plus);
        Editor editor = context.getEditor();
        CaretModel _caretModel = editor.getCaretModel();
        int _startOffset_3 = fullChange.getStartOffset();
        int _min = Math.min(start, end);
        int _plus_1 = _startOffset_3 + _min;
        _caretModel.moveToOffset(_plus_1);
        ScrollingModel _scrollingModel = editor.getScrollingModel();
        _scrollingModel.scrollToCaret(ScrollType.RELATIVE);
        if (start < end) {
            SelectionModel _selectionModel = editor.getSelectionModel();
            int _startOffset_4 = fullChange.getStartOffset();
            int _plus_2 = _startOffset_4 + start;
            int _startOffset_5 = fullChange.getStartOffset();
            int _plus_3 = _startOffset_5 + end;
            _selectionModel.setSelection(_plus_2, _plus_3);
        }
        context.commitDocument();
        Project _project = context.getProject();
        PsiDocumentManager _instance = PsiDocumentManager.getInstance((Project)_project);
        Document _document_2 = context.getDocument();
        _instance.doPostponedOperationsAndUnblockDocument(_document_2);
        boolean _isValid = fullChange.isValid();
        if (_isValid) {
            Project _project_1 = context.getProject();
            CodeStyleManager _instance_1 = CodeStyleManager.getInstance((Project)_project_1);
            PsiFile _file = context.getFile();
            int _startOffset_6 = fullChange.getStartOffset();
            int _endOffset = fullChange.getEndOffset();
            TextRange _textRange = new TextRange(_startOffset_6, _endOffset);
            _instance_1.adjustLineIndent(_file, _textRange);
        }
    }

    protected ArrayList<String> getParameterText(IResolvedExecutable executable, RewritableImportSection importSection) {
        ArrayList result = CollectionLiterals.newArrayList((Object[])new String[0]);
        for (int i = 0; i < executable.getDeclaration().getParameters().size(); ++i) {
            StringConcatenation _builder = new StringConcatenation();
            List _resolvedParameterTypes = executable.getResolvedParameterTypes();
            LightweightTypeReference _get = (LightweightTypeReference)_resolvedParameterTypes.get(i);
            String _importableString = this.documentUtils.toImportableString(_get, importSection);
            _builder.append((Object)_importableString, "");
            _builder.append((Object)" ");
            JvmExecutable _declaration = executable.getDeclaration();
            EList _parameters = _declaration.getParameters();
            JvmFormalParameter _get_1 = (JvmFormalParameter)_parameters.get(i);
            String _simpleName = _get_1.getSimpleName();
            _builder.append((Object)_simpleName, "");
            result.add(_builder.toString());
        }
        return result;
    }

    protected LookupElementBuilder createOverrideMethodElement(IResolvedOperation prototype, InsertHandler<LookupElement> insertHandler) {
        JvmOperation _declaration = prototype.getDeclaration();
        String methodName = _declaration.getSimpleName();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"override ");
        _builder.append((Object)methodName, "");
        _builder.append((Object)"(");
        List _resolvedParameterTypes = prototype.getResolvedParameterTypes();
        Functions.Function1<LightweightTypeReference, CharSequence> _function = new Functions.Function1<LightweightTypeReference, CharSequence>(){

            public CharSequence apply(LightweightTypeReference it) {
                return it.getHumanReadableName();
            }
        };
        String _join = IterableExtensions.join((Iterable)_resolvedParameterTypes, (CharSequence)",", (Functions.Function1)_function);
        _builder.append((Object)_join, "");
        _builder.append((Object)")");
        String signature = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"override ");
        _builder_1.append((Object)signature, "");
        String overrideSignature = _builder_1.toString();
        LookupElementBuilder _create = LookupElementBuilder.create((Object)prototype, (String)signature);
        LookupElementBuilder _withLookupString = _create.withLookupString(methodName);
        LookupElementBuilder _withLookupString_1 = _withLookupString.withLookupString(overrideSignature);
        LookupElementBuilder _withInsertHandler = _withLookupString_1.withInsertHandler(insertHandler);
        LookupElementBuilder _appendTailText = _withInsertHandler.appendTailText(" {...}", true);
        LightweightTypeReference _resolvedDeclarator = prototype.getResolvedDeclarator();
        String _humanReadableName = _resolvedDeclarator.getHumanReadableName();
        LookupElementBuilder _withTypeText = _appendTailText.withTypeText(_humanReadableName);
        LookupElementBuilder element = _withTypeText.withIcon(AllIcons.Nodes.Method);
        return element;
    }

    protected LookupElementBuilder createOverrideConstructorElement(IResolvedConstructor prototype, InsertHandler<LookupElement> insertHandler) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"new (");
        List _resolvedParameterTypes = prototype.getResolvedParameterTypes();
        Functions.Function1<LightweightTypeReference, CharSequence> _function = new Functions.Function1<LightweightTypeReference, CharSequence>(){

            public CharSequence apply(LightweightTypeReference it) {
                return it.getHumanReadableName();
            }
        };
        String _join = IterableExtensions.join((Iterable)_resolvedParameterTypes, (CharSequence)",", (Functions.Function1)_function);
        _builder.append((Object)_join, "");
        _builder.append((Object)")");
        String signature = _builder.toString();
        LookupElementBuilder _create = LookupElementBuilder.create((Object)prototype, (String)signature);
        LookupElementBuilder _withLookupString = _create.withLookupString(signature);
        LookupElementBuilder _withInsertHandler = _withLookupString.withInsertHandler(insertHandler);
        LookupElementBuilder _appendTailText = _withInsertHandler.appendTailText(" {...}", true);
        LightweightTypeReference _resolvedDeclarator = prototype.getResolvedDeclarator();
        String _humanReadableName = _resolvedDeclarator.getHumanReadableName();
        LookupElementBuilder _withTypeText = _appendTailText.withTypeText(_humanReadableName);
        LookupElementBuilder element = _withTypeText.withIcon(AllIcons.Nodes.Method);
        return element;
    }
}

