/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.completion;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.idea.editorActions.XtendTokenSetProvider;
import org.eclipse.xtend.core.idea.lang.XtendLanguage;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.contentassist.IFollowElementAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElementComputer;
import org.eclipse.xtext.ide.editor.contentassist.antlr.IContentAssistParser;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;

public abstract class XtendCodeContextType
extends TemplateContextType {
    @Inject
    protected XtendGrammarAccess grammarAccess;
    @Inject
    protected IContentAssistParser contentAssistParser;
    @Inject
    protected FollowElementComputer followElementComputer;
    @Inject
    protected ParserDefinition parserDefinition;
    @Inject
    protected XtendTokenSetProvider tokenSetProvider;
    protected HashSet<TokenSet> tokenSets = CollectionLiterals.newHashSet((Object[])new TokenSet[0]);
    protected HashSet<AbstractElement> followElements = CollectionLiterals.newHashSet((Object[])new AbstractElement[0]);

    protected XtendCodeContextType(String id, String presentableName, Class<? extends TemplateContextType> parent) {
        super(id, presentableName, parent);
        XtendLanguage.INSTANCE.injectMembers((Object)this);
    }

    protected void registerFollowElementsfor(EStructuralFeature eStructuralFeature) {
        Grammar _grammar = this.grammarAccess.getGrammar();
        IFollowElementAcceptor _function = new IFollowElementAcceptor(){

            public void accept(AbstractElement it) {
                XtendCodeContextType.this.followElements.add(it);
            }
        };
        this.followElementComputer.collectAbstractElements(_grammar, eStructuralFeature, _function);
    }

    public final boolean isInContext(PsiFile file, int offset) {
        boolean _tripleNotEquals;
        Language _language = file.getLanguage();
        boolean bl = _tripleNotEquals = _language != XtendLanguage.INSTANCE;
        if (_tripleNotEquals) {
            return false;
        }
        return this.internalIsInContext(file, offset);
    }

    public boolean internalIsInContext(PsiFile file, int offset) {
        boolean _tripleEquals;
        boolean _isEmpty_4;
        boolean _not;
        boolean _isEmpty_1;
        boolean _and = false;
        boolean _isEmpty = this.tokenSets.isEmpty();
        _and = !_isEmpty ? false : (_isEmpty_1 = this.followElements.isEmpty());
        if (_and) {
            return true;
        }
        boolean _isEmpty_2 = this.tokenSets.isEmpty();
        boolean bl = _not = !_isEmpty_2;
        if (_not) {
            boolean _not_1;
            Object tokenSet = this.getTokenSet(file, offset);
            boolean _contains = this.tokenSets.contains(tokenSet);
            boolean bl2 = _not_1 = !_contains;
            if (_not_1) {
                return false;
            }
            boolean _isEmpty_3 = this.followElements.isEmpty();
            if (_isEmpty_3) {
                return true;
            }
        }
        if (_isEmpty_4 = this.followElements.isEmpty()) {
            return false;
        }
        PsiElement element = file.findElementAt(offset);
        ASTNode _node = null;
        if (element != null) {
            _node = element.getNode();
        }
        boolean bl3 = _tripleEquals = _node == null;
        if (_tripleEquals) {
            return false;
        }
        String _text = file.getText();
        ASTNode _node_1 = element.getNode();
        int _startOffset = _node_1.getStartOffset();
        String _substring = _text.substring(0, _startOffset);
        Collection elements = this.contentAssistParser.getFollowElements(_substring, false);
        final AtomicBoolean hasFollowElement = new AtomicBoolean(false);
        IFollowElementAcceptor _function = new IFollowElementAcceptor(){

            public void accept(AbstractElement it) {
                boolean _contains;
                boolean _and = false;
                boolean _get = hasFollowElement.get();
                boolean _not = !_get;
                _and = !_not ? false : (_contains = XtendCodeContextType.this.followElements.contains(it));
                if (_and) {
                    hasFollowElement.set(true);
                }
            }
        };
        this.followElementComputer.computeFollowElements(elements, _function);
        return hasFollowElement.get();
    }

    protected Object getTokenSet(PsiFile file, int offset) {
        TokenSet _xblockexpression = null;
        Project _project = file.getProject();
        Lexer lexer = this.parserDefinition.createLexer(_project);
        String _text = file.getText();
        lexer.start((CharSequence)_text);
        while (!Objects.equal((Object)lexer.getTokenType(), null) && lexer.getTokenEnd() <= offset) {
            lexer.advance();
        }
        IElementType tokenType = lexer.getTokenType();
        boolean _equals = Objects.equal((Object)tokenType, null);
        if (_equals) {
            return false;
        }
        _xblockexpression = this.tokenSetProvider.getTokenSet(tokenType);
        return _xblockexpression;
    }

    public String toString() {
        return this.getContextId();
    }

    public static class TemplateExpression
    extends XtendCodeContextType {
        public TemplateExpression() {
            super("xtend.template", "Template", Generic.class);
            TokenSet _richStringLiteralTokens = this.tokenSetProvider.getRichStringLiteralTokens();
            this.tokenSets.add(_richStringLiteralTokens);
        }
    }

    public static class Member
    extends XtendCodeContextType {
        public Member() {
            super("xtend.member", "Member", Generic.class);
            TokenSet _defaultTokens = this.tokenSetProvider.getDefaultTokens();
            this.tokenSets.add(_defaultTokens);
            this.registerFollowElementsfor((EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__MEMBERS);
        }
    }

    public static class Expression
    extends XtendCodeContextType {
        public Expression() {
            super("xtend.expression", "Expression", Statement.class);
            TokenSet _defaultTokens = this.tokenSetProvider.getDefaultTokens();
            this.tokenSets.add(_defaultTokens);
            XbaseGrammarAccess.XPrimaryExpressionElements _xPrimaryExpressionAccess = this.grammarAccess.getXPrimaryExpressionAccess();
            RuleCall _xFeatureCallParserRuleCall_4 = _xPrimaryExpressionAccess.getXFeatureCallParserRuleCall_4();
            this.followElements.add(_xFeatureCallParserRuleCall_4);
        }
    }

    public static class Statement
    extends XtendCodeContextType {
        public Statement() {
            super("xtend.statement", "Statement", Generic.class);
            TokenSet _defaultTokens = this.tokenSetProvider.getDefaultTokens();
            this.tokenSets.add(_defaultTokens);
            XtendGrammarAccess.XVariableDeclarationElements _xVariableDeclarationAccess = this.grammarAccess.getXVariableDeclarationAccess();
            Keyword _valKeyword_0_0_1_0_0_1 = _xVariableDeclarationAccess.getValKeyword_0_0_1_0_0_1();
            this.followElements.add(_valKeyword_0_0_1_0_0_1);
        }
    }

    public static class Generic
    extends XtendCodeContextType {
        public Generic() {
            super("xtend.generic", "Xtend", EverywhereContextType.class);
        }

        @Override
        public boolean internalIsInContext(PsiFile file, int offset) {
            return true;
        }
    }
}

