/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.syntaxcoloring;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.ide.editor.syntaxcoloring.AbstractAntlrTokenToAttributeIdMapper;

@Singleton
public class DefaultAntlrTokenToAttributeIdMapper
extends AbstractAntlrTokenToAttributeIdMapper {
    private static final Pattern QUOTED = Pattern.compile("(?:^'([^']*)'$)|(?:^\"([^\"]*)\")$", 8);
    private static final Pattern PUNCTUATION = Pattern.compile("\\p{Punct}*");

    @Override
    protected String calculateId(String tokenName, int tokenType) {
        Matcher _matcher_1;
        boolean _matches_1;
        Matcher _matcher;
        boolean _matches;
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && (_matches = (_matcher = PUNCTUATION.matcher(tokenName)).matches())) {
            _matched = true;
            _switchResult = "punctuation";
        }
        if (!_matched && (_matches_1 = (_matcher_1 = QUOTED.matcher(tokenName)).matches())) {
            _matched = true;
            _switchResult = "keyword";
        }
        if (!_matched && Objects.equal((Object)tokenName, (Object)"RULE_STRING")) {
            _matched = true;
            _switchResult = "string";
        }
        if (!_matched && Objects.equal((Object)tokenName, (Object)"RULE_INT")) {
            _matched = true;
            _switchResult = "number";
        }
        if (!_matched) {
            if (Objects.equal((Object)tokenName, (Object)"RULE_ML_COMMENT")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)tokenName, (Object)"RULE_SL_COMMENT")) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = "comment";
            }
        }
        if (!_matched) {
            _switchResult = "default";
        }
        return _switchResult;
    }
}

