/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.collect.Iterables;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractContainer;

public class DescriptionAddingContainer
extends AbstractContainer {
    private final IResourceDescription description;
    private final IContainer delegate;

    public DescriptionAddingContainer(IResourceDescription addMe, IContainer delegate) {
        this.description = addMe;
        this.delegate = delegate;
    }

    @Override
    public Iterable<IResourceDescription> getResourceDescriptions() {
        return Iterables.concat(Collections.singleton(this.description), this.delegate.getResourceDescriptions());
    }

    @Override
    public int getResourceDescriptionCount() {
        return this.delegate.getResourceDescriptionCount() + 1;
    }

    @Override
    public boolean hasResourceDescription(URI uri) {
        if (uri.equals(this.description.getURI())) {
            return true;
        }
        return this.delegate.hasResourceDescription(uri);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName qualifiedName, boolean ignoreCase) {
        Iterable<IEObjectDescription> added = this.description.getExportedObjects(type, qualifiedName, ignoreCase);
        Iterable<IEObjectDescription> delegated = this.delegate.getExportedObjects(type, qualifiedName, ignoreCase);
        return Iterables.concat(added, delegated);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        Iterable<IEObjectDescription> added = this.description.getExportedObjectsByType(type);
        Iterable<IEObjectDescription> delegated = this.delegate.getExportedObjectsByType(type);
        return Iterables.concat(added, delegated);
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        if (this.description.getURI().equals(uri)) {
            return this.description;
        }
        return this.delegate.getResourceDescription(uri);
    }
}

