/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.validation;

import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.xtext.ui.validation.AbstractValidatorConfigurationBlock;
import org.eclipse.xtext.validation.ConfigurableIssueCodesProvider;
import org.eclipse.xtext.xbase.ui.validation.Messages;
import org.eclipse.xtext.xbase.validation.XbaseSeverityConverter;

public class XbaseValidationConfigurationBlock
extends AbstractValidatorConfigurationBlock {
    @Inject
    private ConfigurableIssueCodesProvider issueCodeProvider;

    public Control doCreateContents(Composite parent) {
        Control createContents = super.doCreateContents(parent);
        this.adjustComboWidth(this.comboBoxes);
        return createContents;
    }

    protected void fillSettingsPage(Composite composite, int nColumns, int defaultIndent) {
        Composite programmingProblems = this.createSection("Potential programming problems", composite, nColumns);
        this.fillPotentialProgrammingProblemsSection(new ComboBoxBuilder(this, programmingProblems, defaultIndent));
        Composite restrictedApi = this.createSection(Messages.XbaseValidationConfigurationBlock_restricted_api_section_title, composite, nColumns);
        this.fillRestrictedApiSection(new ComboBoxBuilder(this, restrictedApi, defaultIndent));
        Composite unusedCode = this.createSection("Unnecessary code", composite, nColumns);
        this.fillUnusedCodeSection(new ComboBoxBuilder(this, unusedCode, defaultIndent));
        Composite codingStyle = this.createSection("Coding style", composite, nColumns);
        this.fillCodingStyleSection(new ComboBoxBuilder(this, codingStyle, defaultIndent));
    }

    protected void fillCodingStyleSection(ComboBoxBuilder comboBoxBuilder) {
        comboBoxBuilder.addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.operation_without_parentheses", "Method/Constructor call without parentheses:");
    }

    protected void fillUnusedCodeSection(ComboBoxBuilder comboBoxBuilder) {
        comboBoxBuilder.addJavaDelegatingComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.unused_local_variable", "Value of local variable is not used:").addJavaDelegatingComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.import_unsued", "Unused import:").addJavaDelegatingComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_instanceof", "Unnecessary 'instanceof' operation:").addJavaDelegatingComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_cast", "Unnecessary 'cast' operation:");
    }

    protected void fillPotentialProgrammingProblemsSection(ComboBoxBuilder comboBoxBuilder) {
        comboBoxBuilder.addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive_valued_feature", "Null safe call of primitive valued feature:");
        comboBoxBuilder.addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.equals_with_null", "Equals comparison with 'null':");
        comboBoxBuilder.addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception", "Unhandled checked exceptions:");
        comboBoxBuilder.addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.java_style_type_cast", "Type cast with Java syntax:");
        comboBoxBuilder.addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.suspiciously_overloaded_feature", "Method overloading with multiple implicit receivers:");
        comboBoxBuilder.addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_discouraged", "Discouraged usage of variable name 'self':");
        comboBoxBuilder.addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_case", "Unreachable case:");
        comboBoxBuilder.addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_instance_of", "Unreachable if block:");
        comboBoxBuilder.addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.constant_condition", "Constant boolean condition:");
        comboBoxBuilder.addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.incomplete_cases_on_enum", "Incomplete 'switch' cases on enum:");
    }

    protected void fillRestrictedApiSection(ComboBoxBuilder comboBoxBuilder) {
        comboBoxBuilder.addJavaDelegatingComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference", Messages.XbaseValidationConfigurationBlock_deprecated_ref_label).addJavaDelegatingComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference", Messages.XbaseValidationConfigurationBlock_forbidden_ref_label).addJavaDelegatingComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.discouraged_reference", Messages.XbaseValidationConfigurationBlock_discouraged_ref_label).addComboBox("org.eclipse.xtext.xbase.validation.IssueCodes.import_wildcard_deprecated", "Use of wildcard imports:");
    }

    protected Combo addJavaDelegatingComboBox(String prefKey, String label, Composite parent, int indent) {
        PreferenceKey preferenceKey = (PreferenceKey)this.issueCodeProvider.getConfigurableIssueCodes().get(prefKey);
        if (preferenceKey == null) {
            throw new IllegalArgumentException(String.valueOf(prefKey) + " not registered in the corresponding ConfigurableIssueCodesProvider");
        }
        String javaIssueCode = preferenceKey.getDefaultValue();
        if (!javaIssueCode.startsWith("org.eclipse.jdt.core")) {
            throw new IllegalArgumentException(String.valueOf(prefKey) + Messages.XbaseValidationConfigurationBlock_not_java_message);
        }
        String[] values = new String[]{"error", "warning", "ignore", javaIssueCode};
        String javaValue = this.javaValue(javaIssueCode);
        String[] valueLabels = new String[]{Messages.XbaseValidationConfigurationBlock_error, Messages.XbaseValidationConfigurationBlock_warning, Messages.XbaseValidationConfigurationBlock_ignore, NLS.bind((String)Messages.XbaseValidationConfigurationBlock_java_label, (Object)javaValue)};
        Combo comboBox = this.addComboBox(parent, label, prefKey, indent, values, valueLabels);
        return comboBox;
    }

    protected Combo addComboBox(String prefKey, String label, Composite parent, int indent) {
        String[] values = new String[]{"error", "warning", "ignore"};
        String[] valueLabels = new String[]{Messages.XbaseValidationConfigurationBlock_error, Messages.XbaseValidationConfigurationBlock_warning, Messages.XbaseValidationConfigurationBlock_ignore};
        Combo comboBox = this.addComboBox(parent, label, prefKey, indent, values, valueLabels);
        return comboBox;
    }

    protected Job getBuildJob(IProject project) {
        OptionsConfigurationBlock.BuildJob buildJob = new OptionsConfigurationBlock.BuildJob(Messages.XbaseValidationConfigurationBlock_build_job_title, project);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = Messages.XbaseValidationConfigurationBlock_build_dialog_title;
        String message = workspaceSettings ? Messages.XbaseValidationConfigurationBlock_build_dailog_ws_message : Messages.XbaseValidationConfigurationBlock_build_dailog_project_message;
        return new String[]{title, message};
    }

    protected void validateSettings(String changedKey, String oldValue, String newValue) {
    }

    protected String javaValue(String javaIssueCode) {
        String decodedDelegateKey = (String)XbaseSeverityConverter.decodeDelegationKey((String)javaIssueCode).getFirst();
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        String delegatedValue = javaProject != null && javaProject.exists() && javaProject.getProject().isAccessible() ? javaProject.getOption(decodedDelegateKey, true) : JavaCore.getOption((String)decodedDelegateKey);
        return delegatedValue;
    }

    protected static final class ComboBoxBuilder {
        private int defaultIndent;
        private Composite section;
        private final XbaseValidationConfigurationBlock xbaseConfBlock;

        public ComboBoxBuilder(XbaseValidationConfigurationBlock xbaseConfBlock, Composite section, int defaultIndent) {
            this.section = section;
            this.xbaseConfBlock = xbaseConfBlock;
            this.defaultIndent = defaultIndent;
        }

        public ComboBoxBuilder addJavaDelegatingComboBox(String key, String label) {
            this.xbaseConfBlock.addJavaDelegatingComboBox(key, label, this.section, this.defaultIndent);
            return this;
        }

        public ComboBoxBuilder addComboBox(String key, String label) {
            this.xbaseConfBlock.addComboBox(key, label, this.section, this.defaultIndent);
            return this;
        }
    }
}

