/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.ecore2xtext;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.util.IProjectFactoryContributor;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.EPackageInfo;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.Ecore2XtextGrammarCreator;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.Ecore2XtextProjectInfo;
import org.eclipse.xtext.xtext.ui.wizard.project.DefaultProjectFactoryContributor;

public class Ecore2XtextDslProjectContributor
extends DefaultProjectFactoryContributor {
    private Ecore2XtextProjectInfo projectInfo;
    private String modelFolder = "";

    public Ecore2XtextDslProjectContributor(Ecore2XtextProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    public void setModelFolder(String modelFolder) {
        this.modelFolder = modelFolder;
    }

    @Override
    public void contributeFiles(IProject project, IProjectFactoryContributor.IFileCreator creator) {
        this.createWorkflowFile(creator);
        this.createGrammarFile(creator);
    }

    public IFile createWorkflowFile(IProjectFactoryContributor.IFileCreator creator) {
        CharSequence _workflow = this.workflow();
        String _basePackagePath = this.projectInfo.getBasePackagePath();
        String _plus = String.valueOf(this.modelFolder) + "/" + _basePackagePath;
        String _plus_1 = String.valueOf(_plus) + "/Generate";
        String _languageNameAbbreviation = this.projectInfo.getLanguageNameAbbreviation();
        String _plus_2 = String.valueOf(_plus_1) + _languageNameAbbreviation;
        String _plus_3 = String.valueOf(_plus_2) + ".mwe2";
        return creator.writeToFile(_workflow, _plus_3);
    }

    public IFile createGrammarFile(IProjectFactoryContributor.IFileCreator creator) {
        Ecore2XtextGrammarCreator _ecore2XtextGrammarCreator = new Ecore2XtextGrammarCreator();
        CharSequence _grammar = _ecore2XtextGrammarCreator.grammar(this.projectInfo);
        String _grammarFilePath = this.projectInfo.getGrammarFilePath();
        String _plus = String.valueOf(this.modelFolder) + "/" + _grammarFilePath;
        return creator.writeToFile(_grammar, _plus);
    }

    private CharSequence workflow() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"module ");
        String _basePackagePath = this.projectInfo.getBasePackagePath();
        String _plus = String.valueOf(_basePackagePath) + "/";
        String _languageNameAbbreviation = this.projectInfo.getLanguageNameAbbreviation();
        String _plus_1 = String.valueOf(_plus) + _languageNameAbbreviation;
        String _replaceAll = _plus_1.replaceAll("/", ".");
        _builder.append((Object)_replaceAll, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.mwe.utils.*");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.xtext.generator.*");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.xtext.ui.generator.*");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"var grammarURI = \"classpath:/");
        String _basePackagePath_1 = this.projectInfo.getBasePackagePath();
        _builder.append((Object)_basePackagePath_1, "");
        _builder.append((Object)"/");
        String _languageNameAbbreviation_1 = this.projectInfo.getLanguageNameAbbreviation();
        _builder.append((Object)_languageNameAbbreviation_1, "");
        _builder.append((Object)".xtext\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"var fileExtensions = \"");
        String _firstFileExtension = this.projectInfo.getFirstFileExtension();
        _builder.append((Object)_firstFileExtension, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"var projectName = \"");
        String _projectName = this.projectInfo.getProjectName();
        _builder.append((Object)_projectName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"var runtimeProject = \"../${projectName}\"");
        _builder.newLine();
        _builder.append((Object)"var generateXtendStub = true");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"Workflow {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"bean = StandaloneSetup {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"scanClassPath  = true");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"platformUri = \"${runtimeProject}/..\"");
        _builder.newLine();
        Collection<EPackageInfo> _ePackageInfos = this.projectInfo.getEPackageInfos();
        Functions.Function1<EPackageInfo, Boolean> _function = new Functions.Function1<EPackageInfo, Boolean>(){

            public Boolean apply(EPackageInfo it) {
                URI _genmodelURI = it.getGenmodelURI();
                String _fileExtension = _genmodelURI.fileExtension();
                return !Objects.equal((Object)_fileExtension, (Object)"xcore");
            }
        };
        Iterable _filter = IterableExtensions.filter(_ePackageInfos, (Functions.Function1)_function);
        Functions.Function1<EPackageInfo, String> _function_1 = new Functions.Function1<EPackageInfo, String>(){

            public String apply(EPackageInfo it) {
                return it.getEPackageJavaFQN();
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
        for (String ePackageInfo : _filterNull) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"registerGeneratedEPackage = \"");
            _builder.append((Object)ePackageInfo, "\t\t");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
        }
        Collection<EPackageInfo> _ePackageInfos_1 = this.projectInfo.getEPackageInfos();
        Functions.Function1<EPackageInfo, Boolean> _function_2 = new Functions.Function1<EPackageInfo, Boolean>(){

            public Boolean apply(EPackageInfo it) {
                URI _genmodelURI = it.getGenmodelURI();
                String _fileExtension = _genmodelURI.fileExtension();
                return !Objects.equal((Object)_fileExtension, (Object)"xcore");
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(_ePackageInfos_1, (Functions.Function1)_function_2);
        Functions.Function1<EPackageInfo, String> _function_3 = new Functions.Function1<EPackageInfo, String>(){

            public String apply(EPackageInfo it) {
                URI _genmodelURI = it.getGenmodelURI();
                return _genmodelURI.toString();
            }
        };
        Iterable _map_1 = IterableExtensions.map((Iterable)_filter_1, (Functions.Function1)_function_3);
        Set _set = IterableExtensions.toSet((Iterable)_map_1);
        for (String genmodelURI : _set) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"registerGenModelFile = \"");
            _builder.append((Object)genmodelURI, "\t\t");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"component = DirectoryCleaner {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"directory = \"${runtimeProject}/src-gen\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"component = DirectoryCleaner {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"directory = \"${runtimeProject}.ui/src-gen\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"component = Generator {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"pathRtProject = runtimeProject");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"pathUiProject = \"${runtimeProject}.ui\"");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"pathTestProject = \"${runtimeProject}.tests\"");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"projectNameRt = projectName");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"projectNameUi = \"${projectName}.ui\"");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"language = auto-inject {");
        _builder.newLine();
        Collection<EPackageInfo> _ePackageInfos_2 = this.projectInfo.getEPackageInfos();
        Functions.Function1<EPackageInfo, Boolean> _function_4 = new Functions.Function1<EPackageInfo, Boolean>(){

            public Boolean apply(EPackageInfo it) {
                URI _genmodelURI = it.getGenmodelURI();
                String _fileExtension = _genmodelURI.fileExtension();
                return Objects.equal((Object)_fileExtension, (Object)"xcore");
            }
        };
        Iterable _filter_2 = IterableExtensions.filter(_ePackageInfos_2, (Functions.Function1)_function_4);
        Functions.Function1<EPackageInfo, String> _function_5 = new Functions.Function1<EPackageInfo, String>(){

            public String apply(EPackageInfo it) {
                URI _genmodelURI = it.getGenmodelURI();
                return _genmodelURI.toString();
            }
        };
        Iterable _map_2 = IterableExtensions.map((Iterable)_filter_2, (Functions.Function1)_function_5);
        Set _set_1 = IterableExtensions.toSet((Iterable)_map_2);
        for (String genmodelURI_1 : _set_1) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"loadedResource = \"");
            _builder.append((Object)genmodelURI_1, "\t\t\t");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"uri = grammarURI");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// Java API to access grammar elements (required by several other fragments)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = grammarAccess.GrammarAccessFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// generates Java API for the generated EPackages");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// fragment = ecore.EcoreGeneratorFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// the Ecore2Xtext specific terminal converter");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = ecore2xtext.Ecore2XtextValueConverterServiceFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// serializer 2.0");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = serializer.SerializerFragment auto-inject {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"//generateStub = false");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// the old serialization component");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// fragment = parseTreeConstructor.ParseTreeConstructorFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// a custom ResourceFactory for use with EMF ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = resourceFactory.ResourceFactoryFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// the Antlr parser");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = parser.antlr.XtextAntlrGeneratorFragment auto-inject {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"options = {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"classSplitting = true");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// Xtend-based API for validation ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = validation.ValidatorFragment auto-inject {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// composedCheck = \"org.eclipse.xtext.validation.ImportUriValidator\"");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// composedCheck = \"org.eclipse.xtext.validation.NamesAreUniqueValidator\"");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// old scoping and exporting API ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// fragment = scoping.ImportNamespacesScopingFragment auto-inject {}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// fragment = exporting.QualifiedNamesFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// scoping and exporting API");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = scoping.ImportURIScopingFragment auto-inject {}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = exporting.SimpleNamesFragment auto-inject {}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = builder.BuilderIntegrationFragment auto-inject {}\t\t");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// generator API");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = generator.GeneratorFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// formatter API ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// fragment = formatting.FormatterFragment auto-inject {}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = ecore2xtext.FormatterFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// labeling API ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = labeling.LabelProviderFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// outline API ");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"fragment = outline.OutlineTreeProviderFragment auto-inject {}");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"fragment = outline.QuickOutlineFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// quickfix API");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = quickfix.QuickfixProviderFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"//content assist API ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = contentAssist.ContentAssistFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// antlr parser generator tailored for content assist ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = parser.antlr.XtextAntlrUiGeneratorFragment auto-inject {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"options = {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"classSplitting = true");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// generates junit test support classes into Generator#pathTestProject");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = junit.Junit4Fragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// project wizard (optional) ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// fragment = projectWizard.SimpleProjectWizardFragment auto-inject {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"//\t\tgeneratorProjectName = \"${projectName}.generator\" ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// }");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// rename refactoring");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = refactoring.RefactorElementNameFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// provides the necessary bindings for java types integration");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = types.TypesGeneratorFragment auto-inject {}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// generates the required bindings only if the grammar inherits from Xbase");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = xbase.XbaseGeneratorFragment auto-inject {}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// generates the required bindings only if the grammar inherits from Xtype");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = xbase.XtypeGeneratorFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// provides a preference page for template proposals");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fragment = templates.CodetemplatesGeneratorFragment auto-inject {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// provides a compare view");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"fragment = compare.CompareFragment auto-inject {}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }
}

