/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.IMirrorOptionsAware;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class TypeResource
extends ResourceImpl
implements ISynchronizable<TypeResource> {
    public static final String OPTION_CLASSPATH_CONTEXT = "OPTION_CLASSPATH_CONTEXT";
    private IMirror mirror;
    private IndexedJvmTypeAccess indexedJvmTypeAccess;
    private TypeResourceServices typeResourceServices;
    private IFragmentProvider.Fallback fragmentProviderFallback = new IFragmentProvider.Fallback(){

        public String getFragment(EObject obj) {
            return TypeResource.super.getURIFragment(obj);
        }

        public EObject getEObject(String fragment) {
            return TypeResource.super.getEObject(fragment);
        }
    };

    public void setTypeResourceServices(TypeResourceServices typeResourceServices) {
        this.typeResourceServices = typeResourceServices;
    }

    public TypeResource() {
    }

    public TypeResource(URI uri) {
        super(uri);
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        ResourceSet oldResourceSet;
        if (resourceSet == null && (oldResourceSet = this.resourceSet) != null && !oldResourceSet.eDeliver()) {
            oldResourceSet.eAdapters().remove((Object)this.mirror);
            this.mirror = null;
            this.eSetDeliver(false);
            if (this.contents != null) {
                this.contents.clear();
            }
            this.unload();
        }
        return super.basicSetResourceSet(resourceSet, notifications);
    }

    public EObject getEObject(String uriFragment) {
        if (this.mirror != null) {
            EObject result = this.mirror.getEObject((Resource)this, uriFragment, this.fragmentProviderFallback);
            return result;
        }
        return super.getEObject(uriFragment);
    }

    public String getURIFragment(EObject eObject) {
        if (this.mirror != null) {
            String result = this.mirror.getFragment(eObject, this.fragmentProviderFallback);
            return result;
        }
        return super.getURIFragment(eObject);
    }

    public void setMirror(IMirror mirror) {
        this.mirror = mirror;
    }

    public IMirror getMirror() {
        return this.mirror;
    }

    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded) {
            this.load(null, options);
        }
    }

    public void save(Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            if (this.getURI() != null && this.mirror != null) {
                if (this.mirror instanceof IMirrorOptionsAware) {
                    ((IMirrorOptionsAware)this.mirror).initialize(this, options);
                } else {
                    this.mirror.initialize(this);
                }
            }
        }
        catch (Exception e) {
            if (this.typeResourceServices != null) {
                OperationCanceledManager operationCanceledManager = this.typeResourceServices.getOperationCanceledManager();
                if (operationCanceledManager.isOperationCanceledException((Throwable)e)) {
                    this.unload();
                }
                operationCanceledManager.propagateAsErrorIfCancelException((Throwable)e);
            }
            throw new CannotLoadTypeResourceException(e);
        }
    }

    public EObject resolveJavaObjectURIProxy(InternalEObject proxy, JvmTypeReference sender) {
        EObject result;
        if (this.indexedJvmTypeAccess != null && (result = this.indexedJvmTypeAccess.getIndexedJvmType(proxy.eProxyURI(), this.getResourceSet())) != null) {
            return result;
        }
        return EcoreUtil.resolve((EObject)proxy, (EObject)sender);
    }

    public IndexedJvmTypeAccess getIndexedJvmTypeAccess() {
        return this.indexedJvmTypeAccess;
    }

    public void setIndexedJvmTypeAccess(IndexedJvmTypeAccess indexedJvmTypeAccess) {
        this.indexedJvmTypeAccess = indexedJvmTypeAccess;
    }

    public Object getLock() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet instanceof ISynchronizable) {
            return ((ISynchronizable)resourceSet).getLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Result> Result execute(IUnitOfWork<Result, ? super TypeResource> unit) throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            return (Result)unit.exec((Object)this);
        }
    }

    protected static class CannotLoadTypeResourceException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public CannotLoadTypeResourceException(Exception e) {
            super(e.getMessage());
            this.initCause(e);
        }
    }
}

