/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.evaluation.AbstractModelManager;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorManager;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.runtime.evaluation.IterableAsSet;
import org.eclipse.qvtd.runtime.evaluation.ModelsManager;
import org.eclipse.qvtd.runtime.evaluation.TransformationExecutor;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.runtime.evaluation.TypedModelInstance;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractTransformerInternal;
import org.eclipse.qvtd.runtime.qvttrace.TransformationExecution;

public abstract class AbstractTransformationExecutor
extends ExecutorManager
implements TransformationExecutor {
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull Transformer transformer;
    private WrappedModelManager wrappedModelManager = null;
    protected boolean suppressFailureDiagnosis = false;

    private AbstractTransformationExecutor(@NonNull EnvironmentFactory environmentFactory, @NonNull Constructor<? extends Transformer> txConstructor) throws ReflectiveOperationException {
        super(environmentFactory.getCompleteEnvironment());
        this.environmentFactory = environmentFactory;
        this.transformer = (Transformer)ClassUtil.nonNullState((Object)txConstructor.newInstance(this));
    }

    protected AbstractTransformationExecutor(@NonNull EnvironmentFactory environmentFactory, @NonNull java.lang.Class<? extends Transformer> txClass) throws ReflectiveOperationException {
        this(environmentFactory, (Constructor)ClassUtil.nonNullState(txClass.getConstructor(TransformationExecutor.class)));
    }

    @Override
    public @Nullable Resource addInputURI(@NonNull String modelName, @NonNull URI modelURI) {
        ResourceSet resourceSet = this.environmentFactory.getResourceSet();
        PivotUtil.initializeLoadOptionsToSupportSelfReferences((ResourceSet)resourceSet);
        Resource inputResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(modelURI, true));
        TypedModelInstance typedModelInstance = this.getTypedModelInstance(modelName);
        typedModelInstance.addInputResource(inputResource);
        return inputResource;
    }

    @Override
    public @NonNull Resource addOutputURI(@NonNull String modelName, @NonNull URI modelURI) {
        ResourceSet resourceSet = PivotUtilInternal.isASURI((URI)modelURI) ? this.environmentFactory.getMetamodelManager().getASResourceSet() : this.environmentFactory.getResourceSet();
        TypedModelInstance typedModelInstance = this.getTypedModelInstance(modelName);
        Resource outputResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.createResource(modelURI));
        typedModelInstance.addOutputResource(outputResource);
        return outputResource;
    }

    @Override
    public final Boolean execute(@Nullable Integer targetTypedModelIndex) throws Exception {
        this.transformer.analyzeInputResources();
        if (targetTypedModelIndex != null ? this.transformer.run(targetTypedModelIndex) : this.transformer.run()) {
            return Boolean.TRUE;
        }
        if (!this.suppressFailureDiagnosis) {
            StringBuilder s = new StringBuilder();
            this.transformer.getInvocationManager().diagnoseWorkLists(s);
            throw new Exception("Failed to execute" + s.toString());
        }
        return Boolean.FALSE;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public @NonNull IdResolver getIdResolver() {
        return this.environmentFactory.getIdResolver();
    }

    public @NonNull MetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    public @NonNull WrappedModelManager getModelManager() {
        WrappedModelManager wrappedModelManager2 = this.wrappedModelManager;
        if (wrappedModelManager2 == null) {
            wrappedModelManager2 = this.wrappedModelManager = new WrappedModelManager();
        }
        return wrappedModelManager2;
    }

    @Override
    public @NonNull ModelsManager getModelsManager() {
        return this.transformer.getModelsManager();
    }

    @Override
    public @NonNull Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public int getTypedModelIndex(@NonNull String targetModelName) {
        return this.transformer.getTypedModelIndex(targetModelName);
    }

    @Override
    public @NonNull TypedModelInstance getTypedModelInstance(@NonNull String modelName) {
        return this.transformer.getTypedModelInstance(modelName);
    }

    @Override
    public @Nullable TransformationExecution getTransformationExecution() {
        return this.transformer.getTransformationExecution();
    }

    @Override
    public void saveModels(@Nullable Map<?, ?> saveOptions) throws IOException {
        this.getModelsManager().saveModels(saveOptions);
    }

    @Override
    public void setContextualProperty(@NonNull String propertyName, Object value) {
        TransformationExecution txInstance = this.getTransformationExecution();
        if (txInstance == null) {
            throw new IllegalArgumentException("No contextual instance available");
        }
        EClass txEClass = txInstance.eClass();
        EStructuralFeature eStructuralFeature = txEClass.getEStructuralFeature(propertyName);
        if (eStructuralFeature == null) {
            throw new IllegalArgumentException("No '" + propertyName + "' contextual property in '" + txEClass.getName());
        }
        txInstance.eSet(eStructuralFeature, value);
    }

    @Override
    public void setSuppressFailureDiagnosis(boolean suppressFailureDiagnosis) {
        this.suppressFailureDiagnosis = suppressFailureDiagnosis;
    }

    private class WrappedModelManager
    extends AbstractModelManager
    implements ModelManager.ModelManagerExtension2 {
        private WrappedModelManager() {
        }

        public @NonNull Set<@NonNull ? extends Object> get(@NonNull Class type) {
            return new IterableAsSet<Object>(((AbstractTransformerInternal)AbstractTransformationExecutor.this.transformer).get(type));
        }

        public @NonNull Iterable<@NonNull Object> getOpposite(@NonNull Property target2sourceProperty, @NonNull Object sourceObject) {
            throw new UnsupportedOperationException();
        }
    }
}

