/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.bigmde2016.tests;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.qvtd.doc.bigmde2016.tests.FamiliesGenerator;
import org.eclipse.qvtd.doc.bigmde2016.tests.PrintAndLog;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.BigMDE2016CGTests;
import org.eclipse.qvtd.pivot.qvtimperative.EntryPoint;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.BasicQVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.xtext.qvtcore.tests.QVTcCompilerTests;
import org.junit.Test;

public class BigMDE2016InterpreterTests
extends QVTcCompilerTests {
    @Test
    public void testQVTcCompiler_Families2Persons() throws Exception {
        PrintAndLog logger = new PrintAndLog("results/" + this.getName());
        logger.printf("%s\n", this.getName());
        QVTcCompilerTests.MyQVT myQVT = this.createQVT("Families2Persons", this.getModelsURI("families2persons/Families2Persons.qvtc"));
        try {
            int[] tests;
            ImperativeTransformation iTransformation = myQVT.compileTransformation("person");
            EntryPoint iEntryPoint = QVTimperativeUtil.getDefaultEntryPoint((ImperativeTransformation)iTransformation);
            int[] nArray = tests = PrintAndLog.getTestSizes();
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                BasicQVTiExecutor interpretedExecutor = myQVT.createInterpretedExecutor(iEntryPoint);
                myQVT.addInputURI("family", this.getModelsURI("families2persons/samples/Families.xmi"));
                Resource inResource = interpretedExecutor.getModel("family");
                inResource.getContents().clear();
                inResource.getContents().addAll(FamiliesGenerator.createFamiliesModel(testSize, 9));
                BigMDE2016CGTests.garbageCollect();
                logger.printf("%9d, ", 10 * testSize);
                long startTime = System.nanoTime();
                myQVT.executeTransformation();
                long endTime = System.nanoTime();
                logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
                ++n2;
            }
        }
        finally {
            myQVT.dispose();
            logger.dispose();
        }
    }
}

