/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelContentRegistry;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.qvt.declarative.modelregistry.resource.XMLElementNamespaceParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreFamilyResourceFactoryImpl
extends EcoreResourceFactoryImpl {
    private static URIConverter defaultURIConverter;

    protected static URIConverter getDefaultURIConverter() {
        if (defaultURIConverter == null) {
            defaultURIConverter = new URIConverterImpl();
        }
        return defaultURIConverter;
    }

    public Resource createResource(URI uri) {
        try {
            return this.loadResource(uri, EcoreFamilyResourceFactoryImpl.getDefaultURIConverter(), null);
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    public Resource createResource(URI resourceURI, String rootNamespaceURI) {
        Resource.Factory resourceFactory = this.findResourceFactory(rootNamespaceURI);
        return resourceFactory.createResource(resourceURI);
    }

    public Resource.Factory findResourceFactory(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        String rootURI = XMLElementNamespaceParser.parse(inputStream);
        return this.findResourceFactory(rootURI);
    }

    public Resource.Factory findResourceFactory(String rootURI) {
        ModelContentRegistry modelContentRegistry = ModelRegistryEnvironment.getInstance().getModelContentRegistry();
        Resource.Factory resourceFactory = modelContentRegistry.getXMLContent(rootURI);
        if (resourceFactory == null) {
            resourceFactory = new XMIResourceFactoryImpl();
        }
        return resourceFactory;
    }

    public Resource loadResource(URI uri, URIConverter uriConverter, Map<?, ?> loadOptions) throws ParserConfigurationException, SAXException, IOException {
        InputStream inputStream = uriConverter.createInputStream(uri);
        if (!inputStream.markSupported()) {
            int i;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[16384];
            while ((i = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, i);
            }
            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        }
        String rootURI = XMLElementNamespaceParser.parse(inputStream);
        Resource resource = this.createResource(uri, rootURI);
        inputStream.reset();
        resource.load(inputStream, loadOptions);
        return resource;
    }

    public Resource loadResource(URI uri, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        Resource.Factory resourceFactory = this.findResourceFactory(inputStream);
        return resourceFactory.createResource(uri);
    }
}

