/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.qvt.declarative.modelregistry.environment.ClassDelegate;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.qvt.declarative.modelregistry.resource.ModelContentAnalyser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelContentRegistry {
    private final List<ModelContentAnalyserDelegate> textContents = new ArrayList<ModelContentAnalyserDelegate>();
    private final Map<String, ResourceFactoryDelegate> xmlContents = new HashMap<String, ResourceFactoryDelegate>();

    public void addModelContentAnalyser(ModelContentAnalyser instance) {
        this.textContents.add(new ContentAnalyser(instance));
    }

    public void addModelContentAnalyserDelegate(ModelContentAnalyserDelegate textContent) {
        this.textContents.add(textContent);
    }

    public void addResourceFactories(Map<String, Resource.Factory> contentToFactoryMap) {
        for (String uri : contentToFactoryMap.keySet()) {
            Resource.Factory newFactory = contentToFactoryMap.get(uri);
            ResourceFactoryDelegate oldFactoryDelegate = this.xmlContents.get(uri);
            if (oldFactoryDelegate != null) {
                Resource.Factory oldFactory = (Resource.Factory)oldFactoryDelegate.load();
                if (newFactory.getClass().isAssignableFrom(oldFactory.getClass())) continue;
                if (!oldFactory.getClass().isAssignableFrom(newFactory.getClass())) {
                    ModelRegistryEnvironment.getInstance().logTheError("Conflicting factories for " + uri + " " + oldFactory.getClass().getName() + " " + newFactory.getClass().getName(), null);
                }
            }
            this.addResourceFactory(uri, newFactory);
        }
    }

    public void addResourceFactory(String uri, Resource.Factory instance) {
        this.xmlContents.put(uri, new ResourceFactory(instance));
    }

    public void addResourceFactoryDelegate(String uri, ResourceFactoryDelegate xmlContent) {
        this.xmlContents.put(uri, xmlContent);
    }

    public Collection<ModelContentAnalyserDelegate> getTextContentAnalysers() {
        return this.textContents;
    }

    public Resource.Factory getXMLContent(String uri) {
        ClassDelegate delegate = this.xmlContents.get(uri);
        return delegate != null ? (Resource.Factory)delegate.load() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContentAnalyser
    extends ModelContentAnalyserDelegate {
        public ContentAnalyser(ModelContentAnalyser instance) {
            super(instance);
        }

        @Override
        protected Class<?> loadClass(String className) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ModelContentAnalyserDelegate
    extends ClassDelegate<ModelContentAnalyser> {
        public ModelContentAnalyserDelegate(String name) {
            super(name, ModelContentAnalyser.class);
        }

        public ModelContentAnalyserDelegate(ModelContentAnalyser instance) {
            super(instance);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceFactory
    extends ResourceFactoryDelegate {
        public ResourceFactory(Resource.Factory instance) {
            super(instance);
        }

        @Override
        protected Class<?> loadClass(String className) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ResourceFactoryDelegate
    extends ClassDelegate<Resource.Factory> {
        public ResourceFactoryDelegate(String name) {
            super(name, Resource.Factory.class);
        }

        public ResourceFactoryDelegate(Resource.Factory instance) {
            super(instance);
        }
    }
}

