/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.BasicEAnnotationValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcoreAnnotationValidator
extends BasicEAnnotationValidator {
    public static final EcoreAnnotationValidator INSTANCE = new EcoreAnnotationValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecore.annotation";

    public EcoreAnnotationValidator() {
        super("http://www.eclipse.org/emf/2002/Ecore", "Ecore", DIAGNOSTIC_SOURCE);
    }

    @Override
    protected ResourceLocator getResourceLocator() {
        return this.getEcoreResourceLocator();
    }

    @Override
    protected boolean isValidLocation(EAnnotation eAnnotation, EModelElement eModelElement) {
        return !this.getProperties(eModelElement).isEmpty();
    }

    @Override
    protected List<EClass> getPropertyClasses(EModelElement eModelElement) {
        final ArrayList result = new ArrayList(1);
        new PropertySwitch(){

            protected void addFeatures(EClass eClass) {
                result.add(eClass);
            }
        }.doSwitch(eModelElement);
        return result.size() == 0 ? Collections.emptyList() : Collections.singletonList((EClass)result.get(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class PropertySwitch
    extends EcoreSwitch<Void> {
        private static final EClass ANNOTATION_PACKAGE_CLASS;
        private static final EClass ANNOTATION_CLASSIFIER_CLASS;
        private static final EClass ANNOTATION_OPERATION_CLASS;

        static {
            EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
            ePackage.setName("annotation");
            ePackage.setNsPrefix("annotation");
            ePackage.setNsURI("annotation");
            EList<EClassifier> eClassifiers = ePackage.getEClassifiers();
            final EDataType javaIdentifier = EcoreFactory.eINSTANCE.createEDataType();
            javaIdentifier.setName("JavaIdentifier");
            javaIdentifier.setInstanceClass(String.class);
            ePackage.getEClassifiers().add((Object)javaIdentifier);
            final EDataType uriDataType = EcoreFactory.eINSTANCE.createEDataType();
            uriDataType.setName("WellFormedURI");
            uriDataType.setInstanceClass(String.class);
            ePackage.getEClassifiers().add((Object)uriDataType);
            ANNOTATION_PACKAGE_CLASS = EcoreFactory.eINSTANCE.createEClass();
            ANNOTATION_PACKAGE_CLASS.setName("Package");
            eClassifiers.add((Object)ANNOTATION_PACKAGE_CLASS);
            EAttribute schemaLocationAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            schemaLocationAttribute.setName("schemaLocation");
            schemaLocationAttribute.setEType(uriDataType);
            ANNOTATION_PACKAGE_CLASS.getEStructuralFeatures().add((Object)schemaLocationAttribute);
            EAttribute settingDelegatesAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            settingDelegatesAttribute.setName("settingDelegates");
            settingDelegatesAttribute.setUpperBound(-1);
            settingDelegatesAttribute.setEType(uriDataType);
            ANNOTATION_PACKAGE_CLASS.getEStructuralFeatures().add((Object)settingDelegatesAttribute);
            EAttribute validationDelegatesAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            validationDelegatesAttribute.setName("validationDelegates");
            validationDelegatesAttribute.setUpperBound(-1);
            validationDelegatesAttribute.setEType(uriDataType);
            ANNOTATION_PACKAGE_CLASS.getEStructuralFeatures().add((Object)validationDelegatesAttribute);
            EAttribute invocationDelegatesAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            invocationDelegatesAttribute.setName("invocationDelegates");
            invocationDelegatesAttribute.setUpperBound(-1);
            invocationDelegatesAttribute.setEType(uriDataType);
            ANNOTATION_PACKAGE_CLASS.getEStructuralFeatures().add((Object)invocationDelegatesAttribute);
            EAttribute conversionDelegatesAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            conversionDelegatesAttribute.setName("conversionDelegates");
            conversionDelegatesAttribute.setUpperBound(-1);
            conversionDelegatesAttribute.setEType(uriDataType);
            ANNOTATION_PACKAGE_CLASS.getEStructuralFeatures().add((Object)conversionDelegatesAttribute);
            ANNOTATION_CLASSIFIER_CLASS = EcoreFactory.eINSTANCE.createEClass();
            ANNOTATION_CLASSIFIER_CLASS.setName("Classifier");
            eClassifiers.add((Object)ANNOTATION_CLASSIFIER_CLASS);
            EAttribute constraintsAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            constraintsAttribute.setName("constraints");
            constraintsAttribute.setEType(javaIdentifier);
            constraintsAttribute.setUpperBound(-1);
            ANNOTATION_CLASSIFIER_CLASS.getEStructuralFeatures().add((Object)constraintsAttribute);
            ANNOTATION_OPERATION_CLASS = EcoreFactory.eINSTANCE.createEClass();
            ANNOTATION_OPERATION_CLASS.setName("Operation");
            eClassifiers.add((Object)ANNOTATION_OPERATION_CLASS);
            EAttribute invariantAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            invariantAttribute.setName("invariant");
            invariantAttribute.setEType(EcorePackage.Literals.EBOOLEAN);
            ANNOTATION_OPERATION_CLASS.getEStructuralFeatures().add((Object)invariantAttribute);
            EValidator.Registry.INSTANCE.put(ePackage, new EObjectValidator(){

                @Override
                public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
                    boolean result = super.validate(eDataType, value, diagnostics, context);
                    if (result) {
                        if (eDataType == javaIdentifier) {
                            if (javaIdentifier != null && !(result = EcoreValidator.isWellFormedJavaIdentifier((String)value)) && diagnostics != null) {
                                diagnostics.add((Diagnostic)this.createDiagnostic(4, "org.eclipse.emf.ecore", 0, "_UI_NameNotWellFormedJavaIdentifier_diagnostic", new Object[]{value}, new Object[]{value}, context));
                            }
                        } else if (eDataType == uriDataType && value != null && !(result = EcoreValidator.isWellFormedURI((String)value)) && diagnostics != null) {
                            diagnostics.add((Diagnostic)this.createDiagnostic(4, "org.eclipse.emf.ecore", 0, "_UI_EAnnotationSourceURINotWellFormed_diagnostic", new Object[]{value}, new Object[]{value}, context));
                        }
                    }
                    return result;
                }
            });
        }

        private PropertySwitch() {
        }

        protected abstract void addFeatures(EClass var1);

        @Override
        public Void caseEClassifier(EClassifier eClassifier) {
            this.addFeatures(ANNOTATION_CLASSIFIER_CLASS);
            return null;
        }

        @Override
        public Void caseEOperation(EOperation eOperation) {
            this.addFeatures(ANNOTATION_OPERATION_CLASS);
            return null;
        }

        @Override
        public Void caseEPackage(EPackage object) {
            this.addFeatures(ANNOTATION_PACKAGE_CLASS);
            return null;
        }
    }
}

