/*
 * Decompiled with CFR 0.152.
 */
package xpt.navigator;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.DesignLabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ElementType;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import parsers.ParserProvider;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.editor.VisualIDRegistry;
import xpt.navigator.NavigatorGroup;
import xpt.navigator.NavigatorItem;
import xpt.navigator.Utils_qvto;
import xpt.providers.ElementTypes;

@Singleton
public class NavigatorLabelProvider {
    @Inject
    @Extension
    private CodeStyle _codeStyle;
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    private Activator xptActivator;
    @Inject
    private VisualIDRegistry xptVisualIDRegistry;
    @Inject
    private ElementTypes xptElementTypes;
    @Inject
    private ParserProvider xptParserProvider;
    @Inject
    private MetaModel xptMetaModel;
    @Inject
    private NavigatorGroup navigatorGroup;
    @Inject
    private NavigatorItem xptNavigatorItem;

    public CharSequence className(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        String _labelProviderClassName = it.getLabelProviderClassName();
        _builder.append(_labelProviderClassName);
        return _builder;
    }

    public CharSequence packageName(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence extendsList(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("extends org.eclipse.jface.viewers.LabelProvider");
        return _builder;
    }

    public CharSequence implementsList(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("implements org.eclipse.ui.navigator.ICommonLabelProvider, org.eclipse.jface.viewers.ITreePathLabelProvider");
        return _builder;
    }

    public CharSequence NavigatorLabelProvider(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" ");
        CharSequence _extendsList = this.extendsList(it);
        _builder.append((Object)_extendsList);
        _builder.append(" ");
        CharSequence _implementsList = this.implementsList(it);
        _builder.append((Object)_implementsList);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _staticInitializer = this.staticInitializer(it);
        _builder.append((Object)_staticInitializer, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _updateLabel = this.updateLabel(it);
        _builder.append((Object)_updateLabel, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _image = this.getImage(it);
        _builder.append((Object)_image, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _viewImage = this.getViewImage(it);
        _builder.append((Object)_viewImage, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _imageByKey = this.getImageByKey(it);
        _builder.append((Object)_imageByKey, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _text = this.getText((EObject)it);
        _builder.append((Object)_text, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _viewText = this.getViewText(it);
        _builder.append((Object)_viewText, "\t");
        _builder.newLineIfNotEmpty();
        Iterable<GenCommonBase> _navigatorContainedNodes = this._utils_qvto.getNavigatorContainedNodes(it);
        for (GenCommonBase n : _navigatorContainedNodes) {
            _builder.append("\t");
            CharSequence _textMethod = this.getTextMethod(n);
            _builder.append((Object)_textMethod, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _unknownElementText = this.getUnknownElementText(it);
        _builder.append((Object)_unknownElementText, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _unresolvedDomainElementProxyText = this.getUnresolvedDomainElementProxyText(it);
        _builder.append((Object)_unresolvedDomainElementProxyText, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _constructor = this.constructor(it);
        _builder.append((Object)_constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _restoreState = this.restoreState(it);
        _builder.append((Object)_restoreState, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _saveState = this.saveState(it);
        _builder.append((Object)_saveState, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _description = this.getDescription(it);
        _builder.append((Object)_description, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _isOwnView = this.isOwnView(it);
        _builder.append((Object)_isOwnView, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence staticInitializer(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("static {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append(".getInstance().getImageRegistry().put(");
        CharSequence _unknownElementKey = this.unknownElementKey();
        _builder.append((Object)_unknownElementKey, "\t");
        _builder.append(", org.eclipse.jface.resource.ImageDescriptor.getMissingImageDescriptor());  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append(".getInstance().getImageRegistry().put(");
        CharSequence _notFoundElementKey = this.notFoundElementKey();
        _builder.append((Object)_notFoundElementKey, "\t");
        _builder.append(", org.eclipse.jface.resource.ImageDescriptor.getMissingImageDescriptor());  ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence updateLabel(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public void updateLabel(org.eclipse.jface.viewers.ViewerLabel label, org.eclipse.jface.viewers.TreePath elementPath) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Object element = elementPath.getLastSegment();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (element instanceof ");
        CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append(" && !isOwnView(((");
        CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append(") element).getView())) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("label.setText(getText(element));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("label.setImage(getImage(element));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getImage(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public org.eclipse.swt.graphics.Image getImage(Object element) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _navigatorGroupImage = this.getNavigatorGroupImage(it);
        _builder.append((Object)_navigatorGroupImage, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _navigatorItemImage = this.getNavigatorItemImage(it);
        _builder.append((Object)_navigatorItemImage, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _adaptableImage = this.getAdaptableImage(it);
        _builder.append((Object)_adaptableImage, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return super.getImage(element);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getNavigatorGroupImage(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (element instanceof ");
        CharSequence _qualifiedClassName = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _qualifiedClassName_1 = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append(" group = (");
        CharSequence _qualifiedClassName_2 = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t");
        _builder.append(") element;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _qualifiedClassName_3 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName_3, "\t");
        _builder.append(".getInstance().getBundledImage(group.getIcon());");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getNavigatorItemImage(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (element instanceof ");
        CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append(" navigatorItem = (");
        CharSequence _qualifiedClassName_2 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t");
        _builder.append(") element;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (!isOwnView(navigatorItem.getView())) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return super.getImage(element);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return getImage(navigatorItem.getView());");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getAdaptableImage(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _generateShortcutIcon = it.getEditorGen().getDiagram().generateShortcutIcon();
        if (_generateShortcutIcon) {
            _builder.append("// Due to plugin.xml content will be called only for \"own\" views");
            _builder.newLine();
            _builder.append("if (element instanceof org.eclipse.core.runtime.IAdaptable) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) ((org.eclipse.core.runtime.IAdaptable) element).getAdapter(org.eclipse.gmf.runtime.notation.View.class);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (view != null && isOwnView(view)) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return getImage(view);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence getViewImage(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public org.eclipse.swt.graphics.Image getImage(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        boolean _notEmpty = this._common_qvto.notEmpty(this._utils_qvto.getNavigatorContainedNodes(it));
        if (_notEmpty) {
            _builder.append("\t");
            _builder.append("switch (");
            CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
            _builder.append((Object)_visualIDMethodCall, "\t");
            _builder.append("(view)) {");
            _builder.newLineIfNotEmpty();
            Iterable<GenCommonBase> _navigatorContainedNodes = this._utils_qvto.getNavigatorContainedNodes(it);
            for (GenCommonBase n : _navigatorContainedNodes) {
                if (n == null) continue;
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _caseImage = this.caseImage(n);
                _builder.append((Object)_caseImage, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return getImage(");
        CharSequence _unknownElementKey = this.unknownElementKey();
        _builder.append((Object)_unknownElementKey, "\t");
        _builder.append(", null);  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence caseImage(GenCommonBase it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("case ");
        CharSequence _visualID = VisualIDRegistry.visualID(it);
        _builder.append((Object)_visualID);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return getImage(\"");
        CharSequence _key = this.key(it);
        _builder.append((Object)_key, "\t");
        _builder.append("\", ");
        ElementType _elementType = it.getElementType();
        boolean bl = _tripleNotEquals = _elementType != null;
        if (_tripleNotEquals) {
            CharSequence _accessElementType = this.xptElementTypes.accessElementType(it);
            _builder.append((Object)_accessElementType, "\t");
        } else {
            _builder.append("null");
        }
        _builder.append("); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getImageByKey(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private org.eclipse.swt.graphics.Image getImage(String key, org.eclipse.gmf.runtime.emf.type.core.IElementType elementType) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.jface.resource.ImageRegistry imageRegistry = ");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append(".getInstance().getImageRegistry();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("org.eclipse.swt.graphics.Image image = imageRegistry.get(key);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (image == null && elementType != null && ");
        CharSequence _qualifiedClassName_1 = this.xptElementTypes.qualifiedClassName(it.getEditorGen().getDiagram());
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append(".isKnownElementType(elementType)) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("image = ");
        CharSequence _qualifiedClassName_2 = this.xptElementTypes.qualifiedClassName(it.getEditorGen().getDiagram());
        _builder.append((Object)_qualifiedClassName_2, "\t\t");
        _builder.append(".getImage(elementType);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("imageRegistry.put(key, image);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (image == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("image = imageRegistry.get(");
        CharSequence _notFoundElementKey = this.notFoundElementKey();
        _builder.append((Object)_notFoundElementKey, "\t\t");
        _builder.append(");  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("imageRegistry.put(key, image);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return image;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _getText(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public String getText(Object element) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _navigatorGroupText = this.getNavigatorGroupText(it);
        _builder.append((Object)_navigatorGroupText, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _navigatorItemText = this.getNavigatorItemText(it);
        _builder.append((Object)_navigatorItemText, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _adaptableText = this.getAdaptableText(it);
        _builder.append((Object)_adaptableText, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return super.getText(element);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getNavigatorGroupText(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (element instanceof ");
        CharSequence _qualifiedClassName = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _qualifiedClassName_1 = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append(" group = (");
        CharSequence _qualifiedClassName_2 = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t");
        _builder.append(") element;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return group.getGroupName();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getNavigatorItemText(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (element instanceof ");
        CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append(" navigatorItem = (");
        CharSequence _qualifiedClassName_2 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t");
        _builder.append(") element;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (!isOwnView(navigatorItem.getView())) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return getText(navigatorItem.getView());");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getAdaptableText(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _generateShortcutIcon = it.getEditorGen().getDiagram().generateShortcutIcon();
        if (_generateShortcutIcon) {
            _builder.append("// Due to plugin.xml content will be called only for \"own\" views");
            _builder.newLine();
            _builder.append("if (element instanceof org.eclipse.core.runtime.IAdaptable) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) ((org.eclipse.core.runtime.IAdaptable) element).getAdapter(org.eclipse.gmf.runtime.notation.View.class);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (view != null && isOwnView(view)) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return getText(view);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence getViewText(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public String getText(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (view.getElement() != null && view.getElement().eIsProxy()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return getUnresolvedDomainElementProxyText(view);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        boolean _notEmpty = this._common_qvto.notEmpty(this._utils_qvto.getNavigatorContainedNodes(it));
        if (_notEmpty) {
            _builder.append("\t");
            _builder.append("switch (");
            CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
            _builder.append((Object)_visualIDMethodCall, "\t");
            _builder.append("(view)) {");
            _builder.newLineIfNotEmpty();
            Iterable<GenCommonBase> _navigatorContainedNodes = this._utils_qvto.getNavigatorContainedNodes(it);
            for (GenCommonBase n : _navigatorContainedNodes) {
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _caseText = this.caseText(n);
                _builder.append((Object)_caseText, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return getUnknownElementText(view);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence caseText(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("case ");
        CharSequence _visualID = VisualIDRegistry.visualID(it);
        _builder.append((Object)_visualID);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _textMethodName = this.getTextMethodName(it);
        _builder.append((Object)_textMethodName, "\t");
        _builder.append("(view);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @MetaDef
    public CharSequence getTextMethodName(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("get");
        String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
        _builder.append(_stringUniqueIdentifier);
        _builder.append("Text");
        return _builder;
    }

    public CharSequence getTextMethod(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private String ");
        CharSequence _textMethodName = this.getTextMethodName(it);
        _builder.append((Object)_textMethodName);
        _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _text = this.getText((EObject)it);
        _builder.append((Object)_text, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _getText(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("Incorrect GenCommonBase: " + it);
        return _builder;
    }

    protected CharSequence _getText(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _labelFeatureText = this.getLabelFeatureText((GenCommonBase)it, it.getDomainDiagramElement());
        _builder.append((Object)_labelFeatureText);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _getText(GenChildLabelNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _diagramLabelText = this.getDiagramLabelText((GenCommonBase)it, (GenCommonBase)it, it.getLabelModelFacet());
        _builder.append((Object)_diagramLabelText);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _getText(GenLinkLabel it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _diagramLabelText = this.getDiagramLabelText((GenCommonBase)it, (GenCommonBase)it.getLink(), it.getModelFacet());
        _builder.append((Object)_diagramLabelText);
        return _builder;
    }

    protected CharSequence _getText(GenNodeLabel it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _diagramLabelText = this.getDiagramLabelText((GenCommonBase)it, (GenCommonBase)it.getNode(), it.getModelFacet());
        _builder.append((Object)_diagramLabelText);
        return _builder;
    }

    protected CharSequence _getText(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = it.getLabels().isEmpty();
        if (_isEmpty) {
            boolean _tripleNotEquals;
            TypeModelFacet _modelFacet = it.getModelFacet();
            boolean bl = _tripleNotEquals = _modelFacet != null;
            if (_tripleNotEquals) {
                CharSequence _labelFeatureText = this.getLabelFeatureText((GenCommonBase)it, it.getModelFacet().getMetaClass());
                _builder.append((Object)_labelFeatureText);
                _builder.newLineIfNotEmpty();
            } else {
                CharSequence _returnEmptyString = this.returnEmptyString();
                _builder.append((Object)_returnEmptyString);
                _builder.newLineIfNotEmpty();
            }
        } else {
            CharSequence _diagramLabelText = this.getDiagramLabelText((GenCommonBase)it, (Iterable<? extends GenLabel>)it.getLabels());
            _builder.append((Object)_diagramLabelText);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _getText(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = it.getLabels().isEmpty();
        if (_isEmpty) {
            boolean _tripleNotEquals;
            LinkModelFacet _modelFacet = it.getModelFacet();
            boolean bl = _tripleNotEquals = _modelFacet != null;
            if (_tripleNotEquals) {
                CharSequence _text = this.getText(it, it.getModelFacet());
                _builder.append((Object)_text);
                _builder.newLineIfNotEmpty();
            } else {
                CharSequence _returnEmptyString = this.returnEmptyString();
                _builder.append((Object)_returnEmptyString);
                _builder.newLineIfNotEmpty();
            }
        } else {
            CharSequence _diagramLabelText = this.getDiagramLabelText((GenCommonBase)it, (Iterable<? extends GenLabel>)it.getLabels());
            _builder.append((Object)_diagramLabelText);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence getDiagramLabelText(GenCommonBase it, Iterable<? extends GenLabel> labels) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = IterableExtensions.isEmpty(labels);
        if (_isEmpty) {
            this._common_qvto.ERROR("Empty list of labels passed");
            _builder.newLineIfNotEmpty();
        }
        CharSequence _diagramLabelText = this.getDiagramLabelText((GenCommonBase)IterableExtensions.head(labels), it, ((GenLabel)IterableExtensions.head(labels)).getModelFacet());
        _builder.append((Object)_diagramLabelText);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _getText(GenLink it, LinkModelFacet modelFacet) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _returnEmptyString = this.returnEmptyString();
        _builder.append((Object)_returnEmptyString);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _getText(GenLink it, TypeLinkModelFacet modelFacet) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _labelFeatureText = this.getLabelFeatureText((GenCommonBase)it, modelFacet.getMetaClass());
        _builder.append((Object)_labelFeatureText);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _getText(GenCompartment it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return \"");
        String _title = it.getTitle();
        _builder.append(_title);
        _builder.append("\"; ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getDiagramLabelText(GenCommonBase it, GenCommonBase elementTypeHolder, LabelModelFacet labelModelFacet) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gmf.runtime.common.ui.services.parser.IParser parser = ");
        CharSequence _accessorCall = this.xptParserProvider.accessorCall(it, elementTypeHolder, labelModelFacet, "view.getElement() != null ? view.getElement() : view");
        _builder.append((Object)_accessorCall);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("if (parser != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return parser.getPrintString(new org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter(view.getElement() != null ? view.getElement() : view), org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions.NONE.intValue());");
        _builder.newLine();
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getDiagram().getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append(".getInstance().logError(\"Parser was not found for label ");
        String _stringVisualID = this._common.stringVisualID(it);
        _builder.append(_stringVisualID, "\t");
        _builder.append("\"); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _returnEmptyString = this.returnEmptyString();
        _builder.append((Object)_returnEmptyString, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getLabelFeatureText(GenCommonBase it, GenClass genClass) {
        StringConcatenation _builder = new StringConcatenation();
        if (genClass != null && genClass.getLabelFeature() != null) {
            boolean _not_1;
            boolean _not;
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(genClass, "domainModelElement", "view.getElement()");
            _builder.append((Object)_DeclareAndAssign);
            _builder.newLineIfNotEmpty();
            _builder.append("if (domainModelElement != null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return ");
            boolean _isStringFeature = this._utils_qvto.isStringFeature(genClass.getLabelFeature());
            boolean bl = _not = !_isStringFeature;
            if (_not) {
                _builder.append("String.valueOf(");
            }
            _builder.append("UMLLabelInternationalization.getInstance().getLabel(domainModelElement)");
            boolean _isStringFeature_1 = this._utils_qvto.isStringFeature(genClass.getLabelFeature());
            boolean bl2 = _not_1 = !_isStringFeature_1;
            if (_not_1) {
                _builder.append(")");
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getDiagram().getEditorGen().getPlugin());
            _builder.append((Object)_qualifiedClassName, "\t");
            _builder.append(".getInstance().logError(\"No domain element for view with visualID = ");
            String _stringVisualID = this._common.stringVisualID(it);
            _builder.append(_stringVisualID, "\t");
            _builder.append("\");  ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append((Object)_nonNLS, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            CharSequence _returnEmptyString = this.returnEmptyString();
            _builder.append((Object)_returnEmptyString, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        } else {
            CharSequence _returnEmptyString_1 = this.returnEmptyString();
            _builder.append((Object)_returnEmptyString_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence returnEmptyString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return \"\"; ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getUnknownElementText(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private String getUnknownElementText(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return \"<UnknownElement Visual_ID = \" + view.getType() + \">\"; ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t");
        _builder.append(" ");
        CharSequence _nonNLS_1 = this._common.nonNLS(2);
        _builder.append((Object)_nonNLS_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getUnresolvedDomainElementProxyText(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private String getUnresolvedDomainElementProxyText(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return \"<Unresolved domain element Visual_ID = \" + view.getType() + \">\"; ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t");
        _builder.append(" ");
        CharSequence _nonNLS_1 = this._common.nonNLS(2);
        _builder.append((Object)_nonNLS_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence constructor(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public void init(org.eclipse.ui.navigator.ICommonContentExtensionSite aConfig) {");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence restoreState(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public void restoreState(org.eclipse.ui.IMemento aMemento) {");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence saveState(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public void saveState(org.eclipse.ui.IMemento aMemento) {");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getDescription(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public String getDescription(Object anElement) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence isOwnView(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private boolean isOwnView(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _modelID = VisualIDRegistry.modelID(it.getEditorGen().getDiagram());
        _builder.append((Object)_modelID, "\t");
        _builder.append(".equals(");
        CharSequence _modelIDMethodCall = this.xptVisualIDRegistry.getModelIDMethodCall(it.getEditorGen().getDiagram());
        _builder.append((Object)_modelIDMethodCall, "\t");
        _builder.append("(view));");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence unknownElementKey() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        CharSequence _commonKeyPrefix = this.commonKeyPrefix();
        _builder.append((Object)_commonKeyPrefix);
        _builder.append("UnknownElement\"");
        return _builder;
    }

    public CharSequence notFoundElementKey() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        CharSequence _commonKeyPrefix = this.commonKeyPrefix();
        _builder.append((Object)_commonKeyPrefix);
        _builder.append("ImageNotFound\"");
        return _builder;
    }

    protected CharSequence _key(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("Incorrect GenCommonBase: " + it);
        return _builder;
    }

    protected CharSequence _key(GenDiagram it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _commonKeyPrefix = this.commonKeyPrefix();
        _builder.append((Object)_commonKeyPrefix);
        _builder.append("Diagram?");
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        boolean bl = _tripleNotEquals = _domainDiagramElement != null;
        if (_tripleNotEquals) {
            CharSequence _keyFragment = this.keyFragment((EObject)it.getDomainDiagramElement());
            _builder.append((Object)_keyFragment);
        }
        return _builder;
    }

    protected CharSequence _key(GenNode it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _commonKeyPrefix = this.commonKeyPrefix();
        _builder.append((Object)_commonKeyPrefix);
        CharSequence _keyFragment = this.keyFragment((EObject)it);
        _builder.append((Object)_keyFragment);
        TypeModelFacet _modelFacet = it.getModelFacet();
        boolean bl = _tripleNotEquals = _modelFacet != null;
        if (_tripleNotEquals) {
            CharSequence _keyFragment_1 = this.keyFragment((EObject)it.getModelFacet().getMetaClass());
            _builder.append((Object)_keyFragment_1);
        } else {
            CharSequence _keyFragment_2 = this.keyFragment((EObject)it.getViewmap());
            _builder.append((Object)_keyFragment_2);
        }
        return _builder;
    }

    protected CharSequence _keyFragment(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Node?");
        return _builder;
    }

    protected CharSequence _keyFragment(GenTopLevelNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("TopLevelNode?");
        return _builder;
    }

    protected CharSequence _key(GenLink it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _commonKeyPrefix = this.commonKeyPrefix();
        _builder.append((Object)_commonKeyPrefix);
        _builder.append("Link?");
        LinkModelFacet _modelFacet = it.getModelFacet();
        boolean bl = _tripleNotEquals = _modelFacet != null;
        if (_tripleNotEquals) {
            CharSequence _keyFragment = this.keyFragment((EObject)it.getModelFacet());
            _builder.append((Object)_keyFragment);
        } else {
            CharSequence _keyFragment_1 = this.keyFragment((EObject)it.getViewmap());
            _builder.append((Object)_keyFragment_1);
        }
        return _builder;
    }

    protected CharSequence _keyFragment(LinkModelFacet it) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("Incorrect link model facet passed: " + it);
        return _builder;
    }

    protected CharSequence _keyFragment(TypeLinkModelFacet it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _keyFragment = this.keyFragment((EObject)it.getMetaClass());
        _builder.append((Object)_keyFragment);
        return _builder;
    }

    protected CharSequence _keyFragment(FeatureLinkModelFacet it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _keyFragment = this.keyFragment((EObject)it.getMetaFeature());
        _builder.append((Object)_keyFragment);
        return _builder;
    }

    protected CharSequence _key(GenCompartment it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _key = this.key((GenCommonBase)it.getNode());
        _builder.append((Object)_key);
        _builder.append("?Compartment?");
        String _title = it.getTitle();
        _builder.append(_title);
        return _builder;
    }

    protected CharSequence _key(GenLabel it) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("Incorrect GenLabel:" + it);
        return _builder;
    }

    protected CharSequence _key(GenNodeLabel it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _key = this.key((GenCommonBase)it.getNode());
        _builder.append((Object)_key);
        CharSequence _keyFragment = this.keyFragment((EObject)it);
        _builder.append((Object)_keyFragment);
        return _builder;
    }

    protected CharSequence _key(GenLinkLabel it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _key = this.key((GenCommonBase)it.getLink());
        _builder.append((Object)_key);
        CharSequence _keyFragment = this.keyFragment((EObject)it);
        _builder.append((Object)_keyFragment);
        return _builder;
    }

    protected CharSequence _keyFragment(GenLabel it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("?Label?");
        CharSequence _keyFragment = this.keyFragment(it.getModelFacet(), it);
        _builder.append((Object)_keyFragment);
        return _builder;
    }

    protected CharSequence _keyFragment(GenClass it) {
        StringConcatenation _builder = new StringConcatenation();
        String _nsURI = it.getGenPackage().getEcorePackage().getNsURI();
        _builder.append(_nsURI);
        _builder.append("?");
        String _name = it.getEcoreClass().getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _keyFragment(GenFeature it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _keyFragment = this.keyFragment((EObject)it.getGenClass());
        _builder.append((Object)_keyFragment);
        _builder.append("?");
        String _name = it.getEcoreFeature().getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _keyFragment(Viewmap it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _keyFragment(FigureViewmap it) {
        StringConcatenation _builder = new StringConcatenation();
        String _figureQualifiedClassName = it.getFigureQualifiedClassName();
        _builder.append(_figureQualifiedClassName);
        return _builder;
    }

    protected CharSequence _keyFragment(InnerClassViewmap it) {
        StringConcatenation _builder = new StringConcatenation();
        String _className = it.getClassName();
        _builder.append(_className);
        return _builder;
    }

    protected CharSequence _keyFragment(ParentAssignedViewmap it) {
        StringConcatenation _builder = new StringConcatenation();
        String _figureQualifiedClassName = it.getFigureQualifiedClassName();
        _builder.append(_figureQualifiedClassName);
        return _builder;
    }

    protected CharSequence _keyFragment(LabelModelFacet it, GenLabel label) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("Incorrect label model facet: " + it);
        return _builder;
    }

    protected CharSequence _keyFragment(FeatureLabelModelFacet it, GenLabel label) {
        StringConcatenation _builder = new StringConcatenation();
        EList _metaFeatures = it.getMetaFeatures();
        for (GenFeature f : _metaFeatures) {
            CharSequence _keyFragment = this.keyFragment((EObject)f);
            _builder.append((Object)_keyFragment);
        }
        return _builder;
    }

    protected CharSequence _keyFragment(DesignLabelModelFacet it, GenLabel label) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _keyFragment = this.keyFragment((EObject)label.getViewmap());
        _builder.append((Object)_keyFragment);
        return _builder;
    }

    public CharSequence commonKeyPrefix() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Navigator?");
        return _builder;
    }

    public CharSequence getText(EObject it) {
        if (it instanceof GenChildLabelNode) {
            return this._getText((GenChildLabelNode)it);
        }
        if (it instanceof GenCompartment) {
            return this._getText((GenCompartment)it);
        }
        if (it instanceof GenNode) {
            return this._getText((GenNode)it);
        }
        if (it instanceof GenDiagram) {
            return this._getText((GenDiagram)it);
        }
        if (it instanceof GenLink) {
            return this._getText((GenLink)it);
        }
        if (it instanceof GenLinkLabel) {
            return this._getText((GenLinkLabel)it);
        }
        if (it instanceof GenNodeLabel) {
            return this._getText((GenNodeLabel)it);
        }
        if (it instanceof GenNavigator) {
            return this._getText((GenNavigator)it);
        }
        if (it instanceof GenCommonBase) {
            return this._getText((GenCommonBase)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence getText(GenLink it, LinkModelFacet modelFacet) {
        if (modelFacet instanceof TypeLinkModelFacet) {
            return this._getText(it, (TypeLinkModelFacet)modelFacet);
        }
        if (modelFacet != null) {
            return this._getText(it, modelFacet);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, modelFacet).toString());
    }

    public CharSequence key(GenCommonBase it) {
        if (it instanceof GenCompartment) {
            return this._key((GenCompartment)it);
        }
        if (it instanceof GenNode) {
            return this._key((GenNode)it);
        }
        if (it instanceof GenDiagram) {
            return this._key((GenDiagram)it);
        }
        if (it instanceof GenLink) {
            return this._key((GenLink)it);
        }
        if (it instanceof GenLinkLabel) {
            return this._key((GenLinkLabel)it);
        }
        if (it instanceof GenNodeLabel) {
            return this._key((GenNodeLabel)it);
        }
        if (it instanceof GenLabel) {
            return this._key((GenLabel)it);
        }
        if (it != null) {
            return this._key(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence keyFragment(EObject it) {
        if (it instanceof GenTopLevelNode) {
            return this._keyFragment((GenTopLevelNode)it);
        }
        if (it instanceof GenNode) {
            return this._keyFragment((GenNode)it);
        }
        if (it instanceof GenClass) {
            return this._keyFragment((GenClass)it);
        }
        if (it instanceof GenFeature) {
            return this._keyFragment((GenFeature)it);
        }
        if (it instanceof FeatureLinkModelFacet) {
            return this._keyFragment((FeatureLinkModelFacet)it);
        }
        if (it instanceof TypeLinkModelFacet) {
            return this._keyFragment((TypeLinkModelFacet)it);
        }
        if (it instanceof FigureViewmap) {
            return this._keyFragment((FigureViewmap)it);
        }
        if (it instanceof GenLabel) {
            return this._keyFragment((GenLabel)it);
        }
        if (it instanceof InnerClassViewmap) {
            return this._keyFragment((InnerClassViewmap)it);
        }
        if (it instanceof LinkModelFacet) {
            return this._keyFragment((LinkModelFacet)it);
        }
        if (it instanceof ParentAssignedViewmap) {
            return this._keyFragment((ParentAssignedViewmap)it);
        }
        if (it instanceof Viewmap) {
            return this._keyFragment((Viewmap)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence keyFragment(LabelModelFacet it, GenLabel label) {
        if (it instanceof DesignLabelModelFacet) {
            return this._keyFragment((DesignLabelModelFacet)it, label);
        }
        if (it instanceof FeatureLabelModelFacet) {
            return this._keyFragment((FeatureLabelModelFacet)it, label);
        }
        if (it != null) {
            return this._keyFragment(it, label);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, label).toString());
    }
}

