/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.custom.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.EObjectValueStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.dialogs.NewElementRepresentation;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PortEditPart;
import org.eclipse.papyrus.uml.diagram.component.providers.UMLViewProvider;

public class CreateLollipopPortCommand
extends RecordingCommand {
    protected List<Object> providedInterface = new ArrayList<Object>();
    protected List<Object> requiredInterface = new ArrayList<Object>();
    protected PortEditPart porteditPart = null;

    public CreateLollipopPortCommand(TransactionalEditingDomain domain, Collection<Object> provided, Collection<Object> required, PortEditPart portEditpart) {
        super(domain, "Creation of lollipop for ports");
        this.providedInterface.addAll(provided);
        this.requiredInterface.addAll(required);
        this.porteditPart = portEditpart;
    }

    protected void doExecute() {
        Node node;
        UMLViewProvider umlViewProvider = new UMLViewProvider();
        IFigure parentFigure = ((GraphicalEditPart)this.porteditPart.getParent()).getFigure();
        Rectangle bounds = parentFigure.getBounds();
        Rectangle insideRect = bounds.getCopy().shrink(new Insets(30));
        int position = insideRect.getPosition(this.porteditPart.getLocation());
        EditPart componentEditPart = this.porteditPart.getParent();
        EditPart container = componentEditPart.getParent();
        for (Object currentRequired : this.requiredInterface) {
            EObject interfaceRequired = currentRequired instanceof NewElementRepresentation ? ((NewElementRepresentation)currentRequired).getEObject() : (EObject)currentRequired;
            node = this.createInterfacenode(umlViewProvider, container, interfaceRequired);
            this.setPositionNode(node, position);
            this.createEdge(umlViewProvider, node, "REQUIRED");
        }
        for (Object currentprovided : this.providedInterface) {
            EObject interfaceProvided = currentprovided instanceof NewElementRepresentation ? ((NewElementRepresentation)currentprovided).getEObject() : (EObject)currentprovided;
            node = this.createInterfacenode(umlViewProvider, container, interfaceProvided);
            this.setPositionNode(node, position);
            this.createEdge(umlViewProvider, node, "PROVIDED");
        }
    }

    protected void createEdge(UMLViewProvider umlViewProvider, Node node, String kind) {
        Edge edge = umlViewProvider.createLink_InterfacePortEdge((View)((View)this.porteditPart.getModel()).getDiagram(), -1, true, this.porteditPart.getDiagramPreferencesHint());
        IdentityAnchor anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        edge.setSourceAnchor((Anchor)anchor);
        anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        edge.setTargetAnchor((Anchor)anchor);
        edge.setSource((View)this.porteditPart.getModel());
        edge.setTarget((View)node);
        edge.setElement(null);
        EObjectValueStyle eObjectValueStyle = (EObjectValueStyle)edge.createStyle(NotationPackage.eINSTANCE.getEObjectValueStyle());
        eObjectValueStyle.setName(kind);
    }

    protected Node createInterfacenode(UMLViewProvider umlViewProvider, EditPart container, EObject currentInterface) {
        Node node = umlViewProvider.createInterface_Shape(currentInterface, (View)container.getModel(), -1, true, this.porteditPart.getDiagramPreferencesHint());
        ((Bounds)node.getLayoutConstraint()).setWidth(20);
        ((Bounds)node.getLayoutConstraint()).setHeight(20);
        return node;
    }

    protected void setPositionNode(Node node, int position) {
        ((Bounds)node.getLayoutConstraint()).setX(this.porteditPart.getLocation().x);
        ((Bounds)node.getLayoutConstraint()).setY(this.porteditPart.getLocation().y);
        int distance = 60;
        if (position == 4) {
            ((Bounds)node.getLayoutConstraint()).setY(((Bounds)node.getLayoutConstraint()).getY() + distance);
        } else if (position == 1) {
            ((Bounds)node.getLayoutConstraint()).setY(((Bounds)node.getLayoutConstraint()).getY() - distance);
        } else if (position == 16) {
            ((Bounds)node.getLayoutConstraint()).setX(((Bounds)node.getLayoutConstraint()).getX() + distance);
        } else if (position == 8) {
            ((Bounds)node.getLayoutConstraint()).setX(((Bounds)node.getLayoutConstraint()).getX() - distance);
        }
    }
}

