/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.wizard.ImportTableWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ImportTableHandler
extends AbstractTableHandler {
    public static final String OPEN_DIALOG_BOOLEAN_PARAMETER = "openDialog";
    public static final String SELECTED_FILE_PATH_STRING_PARAMETER = "selectedFilePath";
    public static final String USER_ACTION__PREFERRED_USER_ACTION = "preferredUserAction";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object res = event.getParameters().get(OPEN_DIALOG_BOOLEAN_PARAMETER);
        boolean openDialog = res == null || Boolean.TRUE.equals(res);
        ImportTableWizard wizard = null;
        if (openDialog) {
            wizard = new ImportTableWizard();
        } else {
            res = event.getParameters().get(SELECTED_FILE_PATH_STRING_PARAMETER);
            String importedText = res == null ? "" : res.toString();
            Object userAction = event.getParameters().get(USER_ACTION__PREFERRED_USER_ACTION);
            int preferredUserAction = userAction == null ? -1 : Integer.parseInt(userAction.toString());
            wizard = new ImportTableWizard(importedText, false, openDialog, preferredUserAction);
        }
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.getCurrentNattableModelManager()));
        if (openDialog) {
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.open();
        } else {
            wizard.addPages();
            wizard.performFinish();
        }
        return null;
    }
}

