/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.internal.resource.index;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.papyrus.infra.core.utils.JobBasedFuture;
import org.eclipse.papyrus.infra.core.utils.JobExecutorService;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.internal.resource.InternalIndexUtil;
import org.eclipse.papyrus.infra.emf.internal.resource.index.IIndexManagerListener;
import org.eclipse.papyrus.infra.emf.internal.resource.index.InternalModelIndex;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexListener;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexProvider;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndex;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndexEvent;
import org.eclipse.papyrus.infra.tools.util.ReferenceCounted;

public class IndexManager {
    private static final int MAX_INDEX_RETRIES = 3;
    private static final int PARTITION_SIZE = 10;
    private static final IndexManager INSTANCE = new IndexManager();
    private final IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
    private final IResourceChangeListener workspaceListener = new WorkspaceListener();
    private final Map<IProject, AbstractIndexJob> activeJobs = Maps.newHashMap();
    private final ContentTypeService contentTypeService;
    private Map<QualifiedName, InternalModelIndex> indices;
    private JobWrangler jobWrangler;
    private final CopyOnWriteArrayList<IndexListener> listeners = new CopyOnWriteArrayList();
    private final IndexSynchronizer synchronizer = new IndexSynchronizer();
    private final CopyOnWriteArrayList<IIndexManagerListener> managerListeners = new CopyOnWriteArrayList();
    private final Lock lifecycleLock = new ReentrantLock();
    private final Condition pausedCondition = this.lifecycleLock.newCondition();
    private boolean paused = false;

    public IndexManager() {
        this.contentTypeService = ContentTypeService.getInstance();
    }

    public static IndexManager getInstance() {
        return INSTANCE;
    }

    public boolean isStarted() {
        return this.indices != null;
    }

    public void dispose() {
        if (this.indices != null) {
            this.wsRoot.getWorkspace().removeResourceChangeListener(this.workspaceListener);
            Job.getJobManager().cancel((Object)this);
            this.indices.values().forEach(InternalModelIndex::dispose);
            this.listeners.clear();
            this.managerListeners.clear();
            ContentTypeService.dispose(this.contentTypeService);
        }
    }

    public final boolean isPaused() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.paused;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void pause() {
        this.setPaused(true);
    }

    private void setPaused(boolean paused) {
        boolean notify = false;
        this.lifecycleLock.lock();
        try {
            if (this.paused != paused) {
                this.paused = paused;
                this.pausedCondition.signalAll();
                notify = true;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
        if (notify) {
            InternalIndexUtil.tracef("Indexing %s", paused ? "paused" : "resumed");
            if (!this.managerListeners.isEmpty()) {
                BiConsumer<IIndexManagerListener, IndexManager> action = paused ? IIndexManagerListener::indexingPaused : IIndexManagerListener::indexingResumed;
                Consumer<IIndexManagerListener> callback = l -> action.accept((IIndexManagerListener)l, this);
                this.managerListeners.forEach(l -> SafeRunner.run(() -> callback.accept((IIndexManagerListener)l)));
            }
        }
    }

    public final void resume() {
        this.setPaused(false);
    }

    final void checkPaused() throws InterruptedException {
        this.lifecycleLock.lock();
        try {
            while (this.paused) {
                this.pausedCondition.await();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void startManager() {
        if (this.indices != null) {
            throw new IllegalStateException("index manager already started");
        }
        this.indices = this.loadIndices();
        int maxConcurrentJobs = this.indices.values().stream().mapToInt(InternalModelIndex::getMaxIndexJobs).max().orElse(5);
        this.jobWrangler = new JobWrangler(maxConcurrentJobs);
        this.indices.values().forEach(this::startIndex);
        this.index(Arrays.asList(this.wsRoot.getProjects()));
        this.wsRoot.getWorkspace().addResourceChangeListener(this.workspaceListener, 1);
    }

    public void addIndexManagerListener(IIndexManagerListener listener) {
        this.managerListeners.addIfAbsent(listener);
    }

    public void removeIndexManagerListener(IIndexManagerListener listener) {
        this.managerListeners.remove(listener);
    }

    private void startIndex(InternalModelIndex index) {
        index.start(this);
    }

    protected Map<QualifiedName, InternalModelIndex> loadIndices() {
        HashMap result = Maps.newHashMap();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.emf", "index");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if ("indexProvider".equals(config.getName())) {
                try {
                    IWorkspaceModelIndexProvider provider = (IWorkspaceModelIndexProvider)config.createExecutableExtension("class");
                    WorkspaceModelIndex index = (WorkspaceModelIndex)provider.get();
                    if (index == null) {
                        Activator.log.warn("No index provided by " + config.getContributor().getName());
                    } else {
                        QualifiedName key = index.getIndexKey();
                        if (key == null) {
                            Activator.log.warn("Index has no key and will be ignored: " + index);
                        } else {
                            WorkspaceModelIndex internal = index;
                            internal.setOwnerClassLoader(provider.getClass().getClassLoader());
                            result.put(key, internal);
                        }
                    }
                }
                catch (ClassCastException e) {
                    Activator.log.error("Expected IWorkspaceModelIndexProvider in " + config.getContributor().getName(), (Throwable)e);
                }
                catch (CoreException e) {
                    Activator.log.log(e.getStatus());
                }
                catch (Exception e) {
                    Activator.log.error("Failed to obtain index from provider in " + config.getContributor().getName(), (Throwable)e);
                }
            }
            ++n2;
        }
        return result;
    }

    IContentType[] getContentTypes(IFile file) {
        return this.contentTypeService.getContentTypes(file);
    }

    <V> ListenableFuture<V> afterIndex(InternalModelIndex index, Callable<V> callable) {
        ListenableFuture<V> result;
        if (this.isIdle() || this.wsRoot.getWorkspace().isTreeLocked()) {
            try {
                result = Futures.immediateFuture(callable.call());
            }
            catch (Exception e) {
                result = Futures.immediateFailedFuture((Throwable)e);
            }
        } else {
            result = this.synchronizer.post(callable);
        }
        return result;
    }

    private boolean isIdle() {
        return this.jobWrangler == null || this.jobWrangler.isIdle();
    }

    private void waitForIndex() throws InterruptedException {
        if (this.isIdle()) {
            return;
        }
        this.jobWrangler.waitForIdle();
    }

    <V> V ifAvailable(Callable<V> callable) throws CoreException {
        V result = null;
        if (Job.getJobManager().find((Object)this).length == 0) {
            try {
                result = callable.call();
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.emf", e.getMessage(), (Throwable)e));
            }
        }
        return result;
    }

    void index(Collection<? extends IProject> projects) {
        ArrayList jobs = Lists.newArrayListWithCapacity((int)projects.size());
        for (IProject iProject : projects) {
            jobs.add(new DiscoverProjectJob(iProject));
        }
        this.schedule(jobs);
    }

    void index(IProject project) {
        this.schedule(new DiscoverProjectJob(project));
    }

    void process(IFile file) throws CoreException {
        IProject project = file.getProject();
        this.safeIterateIndices(index -> {
            boolean matched = index.match(file);
            if (InternalIndexUtil.isTracing()) {
                InternalIndexUtil.detailf("indexer/files/matching", "Index %s %s file %s", index.getIndexKey().getLocalName(), matched ? "indexing" : "un-indexing", file.getFullPath());
            }
            if (matched) {
                index.process(file);
            } else {
                index.remove(project, file);
            }
        });
    }

    private void safeIterateIndices(IndexAction action) throws CoreException {
        CoreException exception = null;
        for (InternalModelIndex index : this.indices.values()) {
            try {
                action.apply(index);
            }
            catch (CoreException e) {
                if (exception == null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    void remove(IProject project, IFile file) throws CoreException {
        this.safeIterateIndices(index -> index.remove(project, file));
    }

    void remove(IProject project) throws CoreException {
        this.safeIterateIndices(index -> index.remove(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReindexProjectJob reindex(IProject project, Collection<? extends IndexDelta> deltas) {
        ReindexProjectJob result = null;
        Map<IProject, AbstractIndexJob> map = this.activeJobs;
        synchronized (map) {
            AbstractIndexJob active = this.activeJobs.get(project);
            if (active != null) {
                switch (active.kind()) {
                    case REINDEX: {
                        ReindexProjectJob reindex = (ReindexProjectJob)active;
                        reindex.addDeltas(deltas);
                        break;
                    }
                    case INDEX: {
                        IndexProjectJob index = (IndexProjectJob)active;
                        ReindexProjectJob followup = index.getFollowup();
                        if (followup != null) {
                            followup.addDeltas(deltas);
                            break;
                        }
                        followup = new ReindexProjectJob(project, deltas);
                        index.setFollowup(followup);
                        break;
                    }
                    case DISCOVERY: {
                        break;
                    }
                    case MASTER: {
                        throw new IllegalStateException("Master job is in the active table.");
                    }
                }
            } else {
                result = new ReindexProjectJob(project, deltas);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(Collection<? extends AbstractIndexJob> jobs) {
        Map<IProject, AbstractIndexJob> map = this.activeJobs;
        synchronized (map) {
            this.jobWrangler.add(jobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(AbstractIndexJob job) {
        Map<IProject, AbstractIndexJob> map = this.activeJobs;
        synchronized (map) {
            this.jobWrangler.add(job);
        }
    }

    public void addListener(WorkspaceModelIndex<?> index, IWorkspaceModelIndexListener listener) {
        this.listeners.addIfAbsent(new IndexListener(index, listener));
    }

    public void removeListener(WorkspaceModelIndex<?> index, IWorkspaceModelIndexListener listener) {
        this.listeners.removeIf(l -> Objects.equal(l.index, (Object)index) && Objects.equal((Object)l.listener, (Object)listener));
    }

    private void notifyStarting(AbstractIndexJob indexJob) {
        if (!this.listeners.isEmpty()) {
            HashMap events = Maps.newHashMap();
            Function<WorkspaceModelIndex, WorkspaceModelIndexEvent> eventFunction = index -> {
                switch (indexJob.kind()) {
                    case INDEX: {
                        return new WorkspaceModelIndexEvent((WorkspaceModelIndex<?>)index, 2, indexJob.getProject());
                    }
                    case REINDEX: {
                        return new WorkspaceModelIndexEvent((WorkspaceModelIndex<?>)index, 0, indexJob.getProject());
                    }
                }
                throw new IllegalArgumentException(indexJob.kind().name());
            };
            switch (indexJob.kind()) {
                case INDEX: {
                    for (IndexListener next : this.listeners) {
                        try {
                            if (InternalIndexUtil.isTracing()) {
                                InternalIndexUtil.detailf("indexer/events", "Notifying calculating for %s to %s", indexJob.getProject().getName(), next.getClass().getName());
                            }
                            next.listener.indexAboutToCalculate(events.computeIfAbsent(next.index, eventFunction));
                        }
                        catch (Exception e) {
                            Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                        }
                    }
                    break;
                }
                case REINDEX: {
                    for (IndexListener next : this.listeners) {
                        try {
                            if (InternalIndexUtil.isTracing()) {
                                InternalIndexUtil.detailf("indexer/events", "Notifying recalculating for %s to %s", indexJob.getProject().getName(), next.getClass().getName());
                            }
                            next.listener.indexAboutToRecalculate(events.computeIfAbsent(next.index, eventFunction));
                        }
                        catch (Exception e) {
                            Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                        }
                    }
                    break;
                }
            }
        }
    }

    private void notifyFinished(AbstractIndexJob indexJob, IStatus status) {
        if (!this.listeners.isEmpty()) {
            if (status != null && status.getSeverity() >= 4) {
                HashMap events = Maps.newHashMap();
                Function<WorkspaceModelIndex, WorkspaceModelIndexEvent> eventFunction = index -> new WorkspaceModelIndexEvent((WorkspaceModelIndex<?>)index, 4, indexJob.getProject());
                for (IndexListener next : this.listeners) {
                    try {
                        if (InternalIndexUtil.isTracing()) {
                            InternalIndexUtil.detailf("indexer/events", "Notifying failure for %s to %s", indexJob.getProject().getName(), next.getClass().getName());
                        }
                        next.listener.indexFailed(events.computeIfAbsent(next.index, eventFunction));
                    }
                    catch (Exception e) {
                        Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                    }
                }
            } else {
                HashMap events = Maps.newHashMap();
                Function<WorkspaceModelIndex, WorkspaceModelIndexEvent> eventFunction = index -> {
                    switch (indexJob.kind()) {
                        case INDEX: {
                            return new WorkspaceModelIndexEvent((WorkspaceModelIndex<?>)index, 3, indexJob.getProject());
                        }
                        case REINDEX: {
                            return new WorkspaceModelIndexEvent((WorkspaceModelIndex<?>)index, 1, indexJob.getProject());
                        }
                    }
                    throw new IllegalArgumentException(indexJob.kind().name());
                };
                switch (indexJob.kind()) {
                    case INDEX: {
                        for (IndexListener next : this.listeners) {
                            try {
                                if (InternalIndexUtil.isTracing()) {
                                    InternalIndexUtil.detailf("indexer/events", "Notifying calculate done for %s to %s", indexJob.getProject().getName(), next.getClass().getName());
                                }
                                next.listener.indexCalculated(events.computeIfAbsent(next.index, eventFunction));
                            }
                            catch (Exception e) {
                                Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                            }
                        }
                        break;
                    }
                    case REINDEX: {
                        for (IndexListener next : this.listeners) {
                            try {
                                if (InternalIndexUtil.isTracing()) {
                                    InternalIndexUtil.detailf("indexer/events", "Notifying recalculate done for %s to %s", indexJob.getProject().getName(), next.getClass().getName());
                                }
                                next.listener.indexRecalculated(events.computeIfAbsent(next.index, eventFunction));
                            }
                            catch (Exception e) {
                                Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    private void notifyWranglerStarting() {
        if (!this.managerListeners.isEmpty()) {
            this.managerListeners.forEach(l -> SafeRunner.run(() -> l.indexingStarting(this)));
        }
    }

    private void notifyWranglerFinished() {
        if (!this.managerListeners.isEmpty()) {
            this.managerListeners.forEach(l -> SafeRunner.run(() -> l.indexingFinished(this)));
        }
    }

    private abstract class AbstractIndexJob
    extends Job {
        private final IProject project;
        private volatile Semaphore permit;

        AbstractIndexJob(String name, IProject project) {
            this(name, project, (ISchedulingRule)project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractIndexJob(String name, IProject project, ISchedulingRule rule) {
            super(name);
            this.project = project;
            if (rule != null) {
                this.setRule(rule);
                if (project != null) {
                    Map<IProject, AbstractIndexJob> map = IndexManager.this.activeJobs;
                    synchronized (map) {
                        if (!IndexManager.this.activeJobs.containsKey(project)) {
                            IndexManager.this.activeJobs.put(project, this);
                        }
                    }
                }
            }
            this.setSystem(this.kind().isSystem());
            this.setPriority(40);
        }

        public boolean belongsTo(Object family) {
            return family == IndexManager.this || ResourcesPlugin.FAMILY_MANUAL_BUILD.equals(family);
        }

        final IProject getProject() {
            return this.project;
        }

        abstract JobKind kind();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final IStatus run(IProgressMonitor monitor) {
            IStatus result;
            try {
                if (InternalIndexUtil.isTracing()) {
                    switch (this.kind()) {
                        case MASTER: {
                            InternalIndexUtil.tracef("Starting index manager", new Object[0]);
                            break;
                        }
                        default: {
                            InternalIndexUtil.tracef("Starting %s of project %s", new Object[]{this.kind(), this.getProject().getName()});
                        }
                    }
                }
                result = this.doRun(monitor);
                if (InternalIndexUtil.isTracing()) {
                    switch (this.kind()) {
                        case MASTER: {
                            InternalIndexUtil.tracef("Finished index manager", new Object[0]);
                            break;
                        }
                        default: {
                            InternalIndexUtil.tracef("Finished %s of project %s", new Object[]{this.kind(), this.getProject().getName()});
                            break;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Map<IProject, AbstractIndexJob> map = IndexManager.this.activeJobs;
                synchronized (map) {
                    AbstractIndexJob followup = this.getFollowup();
                    if (this.project != null) {
                        if (followup == null) {
                            IndexManager.this.activeJobs.remove(this.project);
                        } else {
                            IndexManager.this.activeJobs.put(this.project, followup);
                        }
                    }
                    if (followup != null) {
                        IndexManager.this.schedule(followup);
                        InternalIndexUtil.tracef("Follow-up %s of project %s with %s", new Object[]{this.kind(), this.getProject().getName(), followup.kind()});
                    }
                }
                throw throwable;
            }
            Map<IProject, AbstractIndexJob> map = IndexManager.this.activeJobs;
            synchronized (map) {
                AbstractIndexJob followup = this.getFollowup();
                if (this.project != null) {
                    if (followup == null) {
                        IndexManager.this.activeJobs.remove(this.project);
                    } else {
                        IndexManager.this.activeJobs.put(this.project, followup);
                    }
                }
                if (followup != null) {
                    IndexManager.this.schedule(followup);
                    InternalIndexUtil.tracef("Follow-up %s of project %s with %s", new Object[]{this.kind(), this.getProject().getName(), followup.kind()});
                }
            }
            return result;
        }

        final Semaphore getPermit() {
            return this.permit;
        }

        final void setPermit(Semaphore permit) {
            this.permit = permit;
        }

        protected abstract IStatus doRun(IProgressMonitor var1);

        protected AbstractIndexJob getFollowup() {
            return null;
        }
    }

    private static final class Computation<V>
    implements Supplier<ListenableFuture<V>> {
        private final Callable<V> computation;
        private final SettableFuture<V> result = SettableFuture.create();

        Computation(Callable<V> computation) {
            this.computation = computation;
        }

        void complete() {
            try {
                this.result.set(this.computation.call());
            }
            catch (ThreadDeath d) {
                throw d;
            }
            catch (Throwable e) {
                this.result.setException(e);
            }
        }

        @Override
        public ListenableFuture<V> get() {
            return this.result;
        }

        static <V> ListenableFuture<V> complete(Callable<V> computation) {
            try {
                return Futures.immediateFuture(computation.call());
            }
            catch (ThreadDeath d) {
                throw d;
            }
            catch (Throwable e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
    }

    private static final class ContentTypeService
    extends ReferenceCounted<ContentTypeService> {
        private static ContentTypeService instance = null;
        private final ExecutorService serialExecution = new JobExecutorService();
        private final IContentTypeManager mgr = Platform.getContentTypeManager();

        private ContentTypeService() {
        }

        static synchronized ContentTypeService getInstance() {
            ContentTypeService result = instance;
            if (result == null) {
                instance = result = new ContentTypeService();
            }
            return (ContentTypeService)((Object)result.retain());
        }

        static synchronized void dispose(ContentTypeService service) {
            service.release();
        }

        protected void dispose() {
            this.serialExecution.shutdownNow();
            if (instance == this) {
                instance = null;
            }
        }

        IContentType[] getContentTypes(final IFile file) {
            Future<IContentType[]> futureResult = this.serialExecution.submit(new Callable<IContentType[]>(){

                @Override
                public IContentType[] call() {
                    IContentType[] result;
                    block13: {
                        result = null;
                        InputStream input = null;
                        if (file.isAccessible()) {
                            try {
                                try {
                                    input = file.getContents(true);
                                    result = mgr.findContentTypesFor(input, file.getName());
                                }
                                catch (Exception e) {
                                    Activator.log.error("Failed to index file " + file.getFullPath(), (Throwable)e);
                                    if (input == null) break block13;
                                    try {
                                        input.close();
                                    }
                                    catch (IOException e2) {
                                        Activator.log.error("Failed to close indexed file " + file.getFullPath(), (Throwable)e2);
                                    }
                                }
                            }
                            finally {
                                if (input != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (IOException e) {
                                        Activator.log.error("Failed to close indexed file " + file.getFullPath(), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    return result;
                }
            });
            return (IContentType[])Futures.getUnchecked(futureResult);
        }
    }

    private class DiscoverProjectJob
    extends AbstractIndexJob {
        private AbstractIndexJob followup;

        DiscoverProjectJob(IProject project) {
            super("Initializing workspace model index", project);
            this.setUser(true);
        }

        @Override
        JobKind kind() {
            return JobKind.DISCOVERY;
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            IStatus result = Status.OK_STATUS;
            IProject project = this.getProject();
            monitor.beginTask("Scanning project " + project.getName(), -1);
            try {
                try {
                    if (project.isAccessible()) {
                        ArrayList needIndex = Lists.newArrayListWithCapacity((int)IndexManager.this.indices.size());
                        for (InternalModelIndex next : IndexManager.this.indices.values()) {
                            if (next.hasIndex(project)) continue;
                            needIndex.add(next);
                        }
                        if (!needIndex.isEmpty()) {
                            ProjectScanner scanner = new ProjectScanner(needIndex, monitor);
                            project.accept((IResourceVisitor)scanner);
                            if (!monitor.isCanceled() && !scanner.isEmpty()) {
                                this.followup = new IndexProjectJob(project, scanner.getResourcesToIndex());
                            }
                        }
                    } else {
                        IndexManager.this.remove(project);
                    }
                    if (monitor.isCanceled()) {
                        IndexManager.this.remove(project);
                        result = Status.CANCEL_STATUS;
                    }
                }
                catch (CoreException e) {
                    result = e.getStatus();
                    try {
                        IndexManager.this.remove(project);
                    }
                    catch (CoreException e2) {
                        Activator.getDefault().getLog().log(e2.getStatus());
                    }
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return result;
        }

        @Override
        protected AbstractIndexJob getFollowup() {
            return this.followup;
        }
    }

    @FunctionalInterface
    private static interface IndexAction {
        public void apply(InternalModelIndex var1) throws CoreException;
    }

    private static final class IndexDelta {
        private final IFile file;
        private final DeltaKind kind;

        IndexDelta(IFile file, DeltaKind kind) {
            this.file = file;
            this.kind = kind;
        }

        DeltaKind kind() {
            return this.kind;
        }

        IFile file() {
            return this.file;
        }

        static enum DeltaKind {
            INDEX,
            REINDEX,
            UNINDEX;

        }
    }

    private static final class IndexListener {
        final WorkspaceModelIndex<?> index;
        final IWorkspaceModelIndexListener listener;

        IndexListener(WorkspaceModelIndex<?> index, IWorkspaceModelIndexListener listener) {
            this.index = index;
            this.listener = listener;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IndexListener)) {
                return false;
            }
            IndexListener other = (IndexListener)obj;
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
        }
    }

    private class IndexProjectJob
    extends AbstractIndexJob {
        private final List<IFile> resourcesToIndex;
        private ReindexProjectJob followup;

        IndexProjectJob(IProject project, Collection<IFile> resourcesToIndex) {
            super("Indexing project " + project.getName(), project, null);
            this.resourcesToIndex = ImmutableList.copyOf(resourcesToIndex);
        }

        @Override
        JobKind kind() {
            return JobKind.INDEX;
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            IStatus result = Status.OK_STATUS;
            IProject project = this.getProject();
            List partitions = Lists.partition(this.resourcesToIndex, (int)10);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Indexing models in project " + project.getName()), (int)(this.resourcesToIndex.size() + partitions.size()));
            try {
                try {
                    for (List filesToIndex : partitions) {
                        MultiRule partitionRule = new MultiRule(filesToIndex.toArray(new ISchedulingRule[filesToIndex.size()]));
                        IndexProjectJob.getJobManager().beginRule((ISchedulingRule)partitionRule, (IProgressMonitor)subMonitor.newChild(1));
                        try {
                            SubMonitor childMonitor = subMonitor.newChild(filesToIndex.size());
                            if (!project.isAccessible()) {
                                InternalIndexUtil.tracef("Removing project %s from index", this.getProject().getName());
                                IndexManager.this.remove(project);
                            } else {
                                for (IFile file : filesToIndex) {
                                    try {
                                        if (InternalIndexUtil.isTracing()) {
                                            InternalIndexUtil.detailf("indexer/files", "Indexing file %s", file.getFullPath());
                                        }
                                        IndexManager.this.process(file);
                                        childMonitor.worked(1);
                                    }
                                    catch (CoreException e) {
                                        if (result.isOK()) {
                                            result = e.getStatus();
                                            continue;
                                        }
                                        if (result.isMultiStatus()) continue;
                                        result = new MultiStatus(result.getPlugin(), result.getCode(), new IStatus[]{result, e.getStatus()}, result.getMessage(), null);
                                    }
                                }
                                if (!monitor.isCanceled()) continue;
                                result = Status.CANCEL_STATUS;
                            }
                            break;
                        }
                        finally {
                            IndexProjectJob.getJobManager().endRule((ISchedulingRule)partitionRule);
                        }
                    }
                }
                catch (CoreException e) {
                    if (result.isOK()) {
                        result = e.getStatus();
                    } else if (!result.isMultiStatus()) {
                        result = new MultiStatus(result.getPlugin(), result.getCode(), new IStatus[]{result, e.getStatus()}, result.getMessage(), null);
                    }
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return result;
        }

        void setFollowup(ReindexProjectJob followup) {
            this.followup = followup;
        }

        @Override
        protected ReindexProjectJob getFollowup() {
            return this.followup;
        }
    }

    private final class IndexSynchronizer
    extends JobBasedFuture<List<Future<?>>> {
        private final Lock lock;
        private final Queue<Computation<?>> waitingComputations;

        IndexSynchronizer() {
            super("Wait for workspace model index");
            this.lock = new ReentrantLock();
            this.waitingComputations = new LinkedList();
            this.setSystem(true);
        }

        protected List<Future<?>> compute(IProgressMonitor monitor) throws Exception {
            ArrayList result = new ArrayList();
            IndexManager.this.waitForIndex();
            this.lock.lock();
            try {
                do {
                    List<Computation<?>> toComplete = List.copyOf(this.waitingComputations);
                    this.waitingComputations.clear();
                    this.lock.unlock();
                    try {
                        for (Computation<?> next : toComplete) {
                            next.complete();
                            result.add((Future<?>)next.get());
                        }
                    }
                    finally {
                        this.lock.lock();
                    }
                } while (!this.waitingComputations.isEmpty());
            }
            finally {
                this.lock.unlock();
            }
            return result;
        }

        <V> ListenableFuture<V> post(Callable<V> computation) {
            ListenableFuture<V> result;
            if (IndexManager.this.isIdle()) {
                result = Computation.complete(computation);
            } else {
                this.lock.lock();
                try {
                    boolean first = this.waitingComputations.isEmpty();
                    Computation<V> wrapper = new Computation<V>(computation);
                    this.waitingComputations.offer(wrapper);
                    result = wrapper.get();
                    if (first) {
                        this.schedule();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            return result;
        }
    }

    private static enum JobKind {
        MASTER,
        DISCOVERY,
        INDEX,
        REINDEX;


        boolean isSystem() {
            return this != DISCOVERY;
        }
    }

    private class JobWrangler
    extends AbstractIndexJob {
        private final Lock lock;
        private final Condition idleCondition;
        private final Deque<AbstractIndexJob> queue;
        final AtomicInteger pending;
        final Condition pendingChanged;
        private final AtomicBoolean active;
        private final Semaphore indexJobSemaphore;
        private volatile boolean cancelled;

        JobWrangler(int maxConcurrentJobs) {
            super("Workspace model indexer", null);
            this.lock = new ReentrantLock();
            this.idleCondition = this.lock.newCondition();
            this.queue = Queues.newArrayDeque();
            this.pending = new AtomicInteger();
            this.pendingChanged = this.lock.newCondition();
            this.active = new AtomicBoolean();
            this.indexJobSemaphore = new Semaphore(maxConcurrentJobs <= 0 ? Integer.MAX_VALUE : maxConcurrentJobs);
        }

        @Override
        JobKind kind() {
            return JobKind.MASTER;
        }

        void add(AbstractIndexJob job) {
            this.lock.lock();
            try {
                this.scheduleIfNeeded();
                this.queue.add(job);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void scheduleIfNeeded() {
            if (this.active.compareAndSet(false, true)) {
                this.schedule();
            }
        }

        void add(Iterable<? extends AbstractIndexJob> jobs) {
            this.lock.lock();
            try {
                for (AbstractIndexJob abstractIndexJob : jobs) {
                    this.add(abstractIndexJob);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void canceling() {
            this.cancelled = true;
            Thread running = this.getThread();
            if (running != null) {
                running.interrupt();
            }
            InternalIndexUtil.tracef("Cancelling job %s", this.getName());
        }

        @Override
        protected IStatus doRun(IProgressMonitor progressMonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)-1);
            IStatus result = Status.OK_STATUS;
            JobChangeAdapter listener = new JobChangeAdapter(){
                private final Map<IProject, Integer> retries = Maps.newHashMap();

                private Semaphore getIndexJobPermit(Job job) {
                    return job instanceof AbstractIndexJob ? ((AbstractIndexJob)job).getPermit() : null;
                }

                public void aboutToRun(IJobChangeEvent event) {
                    Job starting = event.getJob();
                    if (this.getIndexJobPermit(starting) == JobWrangler.this.indexJobSemaphore) {
                        AbstractIndexJob indexJob = (AbstractIndexJob)starting;
                        IndexManager.this.notifyStarting(indexJob);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    block15: {
                        Job finished = event.getJob();
                        if (this.getIndexJobPermit(finished) == JobWrangler.this.indexJobSemaphore) {
                            try {
                                AbstractIndexJob indexJob = (AbstractIndexJob)finished;
                                IProject project = indexJob.getProject();
                                IndexManager.this.notifyFinished(indexJob, event.getResult());
                                if (project == null) break block15;
                                Map<IProject, Integer> map = this.retries;
                                synchronized (map) {
                                    if (event.getResult() != null && event.getResult().getSeverity() >= 4) {
                                        int count;
                                        InternalIndexUtil.tracef("Retrying %s", finished);
                                        int n = count = this.retries.containsKey(project) ? this.retries.get(project) : 0;
                                        if (count++ < 3) {
                                            IndexManager.this.index(project);
                                        }
                                        this.retries.put(project, ++count);
                                    } else {
                                        this.retries.remove(project);
                                    }
                                }
                            }
                            finally {
                                JobWrangler.this.indexJobSemaphore.release();
                                JobWrangler.this.pending.decrementAndGet();
                                JobWrangler.this.lock.lock();
                                try {
                                    JobWrangler.this.pendingChanged.signalAll();
                                }
                                finally {
                                    JobWrangler.this.lock.unlock();
                                }
                            }
                        }
                    }
                }
            };
            JobWrangler.getJobManager().addJobChangeListener((IJobChangeListener)listener);
            IndexManager.this.notifyWranglerStarting();
            this.lock.lock();
            this.pending.set(0);
            try {
                block17: while (true) {
                    monitor.setWorkRemaining(this.queue.size());
                    AbstractIndexJob next = this.queue.poll();
                    while (next != null) {
                        this.lock.unlock();
                        try {
                            try {
                                if (this.cancelled) {
                                    throw new InterruptedException();
                                }
                                IndexManager.this.checkPaused();
                                this.indexJobSemaphore.acquire();
                                next.setPermit(this.indexJobSemaphore);
                                this.pending.incrementAndGet();
                                next.schedule(100L);
                                monitor.worked(1);
                            }
                            catch (InterruptedException e) {
                                this.cancelled = true;
                                this.lock.lock();
                                try {
                                    this.queue.addFirst(next);
                                }
                                finally {
                                    this.lock.unlock();
                                }
                                result = Status.CANCEL_STATUS;
                                InternalIndexUtil.tracef("Job %s interrupted", this.getName());
                                this.lock.lock();
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            this.lock.lock();
                            throw throwable;
                        }
                        this.lock.lock();
                        next = this.queue.poll();
                    }
                    if (this.isIdle()) break;
                    if (this.pending.get() <= 0) continue;
                    try {
                        if (this.cancelled) {
                            throw new InterruptedException();
                        }
                        this.pendingChanged.await();
                    }
                    catch (InterruptedException e) {
                        this.cancelled = true;
                        result = Status.CANCEL_STATUS;
                        break;
                    }
                }
                if (this.isIdle()) {
                    InternalIndexUtil.tracef("Index manager idle", new Object[0]);
                    this.idleCondition.signalAll();
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.cancelled) {
                        this.schedule(1000L);
                        this.cancelled = false;
                        InternalIndexUtil.tracef("Re-scheduled cancelled job %s", this.getName());
                    } else {
                        this.active.compareAndSet(true, false);
                        if (!this.queue.isEmpty()) {
                            this.scheduleIfNeeded();
                            InternalIndexUtil.tracef("Re-scheduled job %s for new indexing jobs", this.getName());
                        }
                    }
                }
                finally {
                    this.lock.unlock();
                    JobWrangler.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
                    IndexManager.this.notifyWranglerFinished();
                }
                throw throwable;
            }
            try {
                if (this.cancelled) {
                    this.schedule(1000L);
                    this.cancelled = false;
                    InternalIndexUtil.tracef("Re-scheduled cancelled job %s", this.getName());
                } else {
                    this.active.compareAndSet(true, false);
                    if (!this.queue.isEmpty()) {
                        this.scheduleIfNeeded();
                        InternalIndexUtil.tracef("Re-scheduled job %s for new indexing jobs", this.getName());
                    }
                }
            }
            finally {
                this.lock.unlock();
                JobWrangler.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
                IndexManager.this.notifyWranglerFinished();
            }
            return result;
        }

        boolean isIdle() {
            this.lock.lock();
            try {
                boolean bl = this.queue.isEmpty() && this.pending.get() <= 0;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        void waitForIdle() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.isIdle()) {
                    this.idleCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private class ProjectScanner
    implements IResourceVisitor {
        private final Predicate<IFile> fileMatcher;
        private final IProgressMonitor monitor;
        private final ImmutableList.Builder<IFile> resourcesToIndex = ImmutableList.builder();
        private boolean empty = true;

        ProjectScanner(List<InternalModelIndex> needIndex, IProgressMonitor monitor) {
            this.monitor = monitor;
            if (needIndex.size() == 1) {
                InternalModelIndex index = needIndex.get(0);
                this.fileMatcher = file -> {
                    boolean result = index.match((IFile)file);
                    if (result && InternalIndexUtil.isTracing()) {
                        InternalIndexUtil.detailf("indexer/files/matching", "Index %s accepting file %s", index.getIndexKey().getLocalName(), file.getFullPath());
                    }
                    return result;
                };
            } else {
                int indexCount = needIndex.size();
                this.fileMatcher = file -> {
                    boolean result = false;
                    int i = 0;
                    while (i < indexCount && !result) {
                        result = ((InternalModelIndex)needIndex.get(i)).match((IFile)file);
                        if (result && InternalIndexUtil.isTracing()) {
                            InternalIndexUtil.detailf("indexer/files/matching", "Index %s accepting file %s", ((InternalModelIndex)needIndex.get(i)).getIndexKey().getLocalName(), file.getFullPath());
                        }
                        ++i;
                    }
                    return result;
                };
            }
        }

        public boolean visit(IResource resource) throws CoreException {
            boolean result;
            boolean bl = result = !this.monitor.isCanceled() && !resource.isDerived();
            if (result && resource.getType() == 1) {
                this.scan((IFile)resource);
            }
            return result;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public Collection<IFile> getResourcesToIndex() {
            return this.resourcesToIndex.build();
        }

        void scan(IFile file) throws CoreException {
            if (this.fileMatcher.test(file)) {
                this.resourcesToIndex.add((Object)file);
                this.empty = false;
            }
        }
    }

    private class ReindexProjectJob
    extends AbstractIndexJob {
        private final IProject project;
        private final ConcurrentLinkedQueue<IndexDelta> moreDeltas;
        private List<IndexDelta> currentDeltas;

        ReindexProjectJob(IProject project, Collection<? extends IndexDelta> deltas) {
            super("Re-indexing project " + project.getName(), project, (ISchedulingRule)new MultiRule((ISchedulingRule[])deltas.stream().map(IndexDelta::file).distinct().toArray(ISchedulingRule[]::new)));
            this.project = project;
            this.currentDeltas = ImmutableList.copyOf(deltas);
            this.moreDeltas = Queues.newConcurrentLinkedQueue();
        }

        @Override
        JobKind kind() {
            return JobKind.REINDEX;
        }

        void addDeltas(Iterable<? extends IndexDelta> deltas) {
            Iterables.addAll(this.moreDeltas, deltas);
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            IStatus result = Status.OK_STATUS;
            monitor.beginTask("Re-indexing models in project " + this.project.getName(), -1);
            try {
                for (IndexDelta next : this.currentDeltas) {
                    if (monitor.isCanceled()) {
                        result = Status.CANCEL_STATUS;
                        break;
                    }
                    try {
                        try {
                            switch (next.kind()) {
                                case INDEX: 
                                case REINDEX: {
                                    if (InternalIndexUtil.isTracing()) {
                                        InternalIndexUtil.detailf("indexer/files", "Re-indexing file %s", next.file().getFullPath());
                                    }
                                    IndexManager.this.process(next.file());
                                    break;
                                }
                                case UNINDEX: {
                                    if (InternalIndexUtil.isTracing()) {
                                        InternalIndexUtil.detailf("indexer/files", "Un-indexing file %s", next.file().getFullPath());
                                    }
                                    IndexManager.this.remove(this.project, next.file());
                                }
                            }
                        }
                        catch (CoreException e) {
                            result = e.getStatus();
                            monitor.worked(1);
                            break;
                        }
                    }
                    finally {
                        monitor.worked(1);
                    }
                }
            }
            finally {
                monitor.done();
            }
            return result;
        }

        @Override
        protected AbstractIndexJob getFollowup() {
            if (this.moreDeltas.isEmpty()) {
                return null;
            }
            ImmutableList.Builder newDeltas = ImmutableList.builder();
            IndexDelta next = this.moreDeltas.poll();
            while (next != null) {
                newDeltas.add((Object)next);
                next = this.moreDeltas.poll();
            }
            this.currentDeltas = newDeltas.build();
            return this;
        }
    }

    private class WorkspaceListener
    implements IResourceChangeListener {
        private WorkspaceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            ArrayListMultimap deltas = ArrayListMultimap.create();
            try {
                event.getDelta().accept(new IResourceDeltaVisitor((Multimap)deltas){
                    private final /* synthetic */ Multimap val$deltas;
                    {
                        this.val$deltas = multimap;
                    }

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getResource().getType() == 1 && !delta.getResource().isDerived(512)) {
                            IFile file = (IFile)delta.getResource();
                            switch (delta.getKind()) {
                                case 4: {
                                    if ((delta.getFlags() & 0x50100) == 0) break;
                                    this.val$deltas.put((Object)file.getProject(), (Object)new IndexDelta(file, IndexDelta.DeltaKind.REINDEX));
                                    break;
                                }
                                case 2: {
                                    this.val$deltas.put((Object)file.getProject(), (Object)new IndexDelta(file, IndexDelta.DeltaKind.UNINDEX));
                                    break;
                                }
                                case 1: {
                                    this.val$deltas.put((Object)file.getProject(), (Object)new IndexDelta(file, IndexDelta.DeltaKind.INDEX));
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                Activator.log.error("Failed to analyze resource changes for re-indexing.", (Throwable)e);
            }
            if (!deltas.isEmpty()) {
                ArrayList jobs = Lists.newArrayListWithCapacity((int)deltas.keySet().size());
                for (IProject next : deltas.keySet()) {
                    ReindexProjectJob reindex = IndexManager.this.reindex(next, deltas.get((Object)next));
                    if (reindex == null) continue;
                    jobs.add(reindex);
                }
                IndexManager.this.schedule(jobs);
            }
        }
    }
}

