/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.decoration.ExternalReferenceMarker;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;

public class ExternalReferenceEditPolicy
extends GraphicalEditPolicyEx {
    public static final Object EDIT_POLICY_ROLE = "org.eclipse.papyrus.infra.gmfdiag.common.externalReferenceDecorator";
    protected boolean isExternalReference = false;
    protected DecorationService decorationService;
    protected IPapyrusMarker marker;
    protected Adapter listener;

    public void activate() {
        super.activate();
        try {
            this.decorationService = (DecorationService)ServiceUtilsForEditPart.getInstance().getService(DecorationService.class, this.getHost());
            this.refresh();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public void refresh() {
        if (this.getView() == null) {
            return;
        }
        if (this.decorationService == null) {
            return;
        }
        if (this.isExternalRef(this.getView()) != this.isExternalReference) {
            boolean bl = this.isExternalReference = !this.isExternalReference;
            if (this.isExternalReference) {
                this.decorationService.addDecoration(this.getMarker(), (EObject)this.getView());
            } else {
                this.decorationService.removeDecoration(this.getMarker().toString());
            }
            this.getHost().refresh();
        }
    }

    protected boolean isExternalRef(View view) {
        return NotationHelper.isExternalRef(view);
    }

    protected IPapyrusMarker getMarker() {
        if (this.marker == null) {
            this.marker = new ExternalReferenceMarker(this.getView());
        }
        return this.marker;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    public void deactivate() {
        super.deactivate();
        if (this.marker != null && this.decorationService != null) {
            this.decorationService.removeDecoration(this.getMarker().toString());
            this.isExternalReference = false;
        }
        this.marker = null;
        this.decorationService = null;
    }
}

