/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIterationManager;
import org.eclipse.ocl.pivot.library.LibraryBinaryOperation;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IterableValue;

public class ExecutorSingleIterationManager
extends AbstractIterationManager {
    protected final @NonNull CollectionValue collectionValue;
    protected final @NonNull TypeId returnTypeId;
    protected final @NonNull LibraryBinaryOperation body;
    private @Nullable Object accumulatorValue;
    protected final @NonNull Iterator<? extends Object> iteratorValue;
    private Object currentValue;

    @Deprecated
    public ExecutorSingleIterationManager(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @NonNull LibraryBinaryOperation body, @Nullable CollectionValue collectionValue, @Nullable Object accumulatorValue) {
        this(ValueUtil.getExecutor(evaluator), returnTypeId, body, collectionValue, accumulatorValue);
    }

    public ExecutorSingleIterationManager(@NonNull Executor executor, @NonNull TypeId returnTypeId, @NonNull LibraryBinaryOperation body, @Nullable CollectionValue collectionValue, @Nullable Object accumulatorValue) {
        super(executor);
        this.collectionValue = ValueUtil.asCollectionValue(collectionValue);
        this.returnTypeId = returnTypeId;
        this.body = body;
        this.updateAccumulator(accumulatorValue);
        this.iteratorValue = this.collectionValue.iterator();
        this.advanceIterators();
    }

    protected ExecutorSingleIterationManager(@NonNull ExecutorSingleIterationManager iterationManager, @NonNull CollectionValue collectionValue) {
        super(iterationManager.getExecutor());
        this.collectionValue = collectionValue;
        this.returnTypeId = iterationManager.returnTypeId;
        this.body = iterationManager.body;
        this.accumulatorValue = iterationManager.accumulatorValue;
        this.iteratorValue = collectionValue.iterator();
        this.advanceIterators();
    }

    @Override
    public boolean advanceIterators() {
        Object object = this.currentValue = this.iteratorValue.hasNext() ? this.iteratorValue.next() : this.iteratorValue;
        return this.currentValue != this.iteratorValue;
    }

    @Override
    public @NonNull IterationManager createNestedIterationManager(@NonNull IterableValue value) {
        return new Nested(this, (CollectionValue)value);
    }

    @Override
    public @Nullable Object evaluateBody() {
        return ((LibraryBinaryOperation.LibraryBinaryOperationExtension)this.body).evaluate(this.executor, this.returnTypeId, this.accumulatorValue, this.get());
    }

    @Override
    public @Nullable Object get() {
        return this.currentValue;
    }

    @Override
    public @Nullable Object getAccumulatorValue() {
        return this.accumulatorValue;
    }

    public int getDepth() {
        return 0;
    }

    public @NonNull ExecutorSingleIterationManager getRootIterationManager() {
        return this;
    }

    @Override
    public @NonNull CollectionValue getSourceCollection() {
        return this.collectionValue;
    }

    @Override
    public @NonNull IterableValue getSourceIterable() {
        return this.collectionValue;
    }

    @Override
    public boolean hasCurrent() {
        return this.currentValue != this.iteratorValue;
    }

    @Override
    public @Nullable Object updateAccumulator(Object newValue) {
        this.accumulatorValue = newValue;
        return null;
    }

    class Nested
    extends ExecutorSingleIterationManager {
        protected final @NonNull ExecutorSingleIterationManager rootIterationManager;
        protected final int depth;

        protected Nested(@NonNull ExecutorSingleIterationManager iterationManager, CollectionValue value) {
            super(iterationManager, value);
            this.rootIterationManager = iterationManager.getRootIterationManager();
            this.depth = iterationManager.getDepth() + 1;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public @NonNull ExecutorSingleIterationManager getRootIterationManager() {
            return this.rootIterationManager;
        }

        @Override
        public @NonNull CollectionValue getSourceCollection() {
            return this.rootIterationManager.getSourceCollection();
        }
    }
}

