/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;

public class LinkRelationServices
extends AbstractDiagramServices {
    public void setLinkTarget(Element source, Element target, DSemanticDecorator sourceView, String mappingName) {
        if (source instanceof Comment) {
            ((Comment)source).getAnnotatedElements().add((Object)target);
        } else if (source instanceof Constraint) {
            ((Constraint)source).getConstrainedElements().add((Object)target);
        }
        Session session = SessionManager.INSTANCE.getSession((EObject)source);
        this.createRelationBasedEdgeViewFromCreationTool((EObject)source, sourceView, session, mappingName);
    }

    public boolean canReconnectLinkSource(Element newSemanticSource, Element oldSemanticSource) {
        return (newSemanticSource instanceof Constraint || newSemanticSource instanceof Comment) && oldSemanticSource.eClass().equals(newSemanticSource.eClass());
    }

    public void reconnectLinkSource(Element oldSource, Element newSource, DEdge edgeView) {
        Optional<Element> optionalTarget = Optional.of(edgeView.getTargetNode()).filter(DSemanticDecorator.class::isInstance).map(DSemanticDecorator.class::cast).map(DSemanticDecorator::getTarget).filter(Element.class::isInstance).map(Element.class::cast);
        if (optionalTarget.isPresent()) {
            Element target = optionalTarget.get();
            if (oldSource instanceof Comment) {
                ((Comment)oldSource).getAnnotatedElements().remove((Object)target);
            } else if (oldSource instanceof Constraint) {
                ((Constraint)oldSource).getConstrainedElements().remove((Object)target);
            }
            if (newSource instanceof Comment) {
                ((Comment)newSource).getAnnotatedElements().add((Object)target);
            } else if (newSource instanceof Constraint) {
                ((Constraint)newSource).getConstrainedElements().add((Object)target);
            }
        }
    }

    public void reconnectLinkTarget(Element source, DSemanticDecorator sourceView, Element oldTarget, Element newTarget, String mappingName) {
        EObjectQuery query;
        Session session;
        boolean isReconnected = false;
        if (source instanceof Comment) {
            ((Comment)source).getAnnotatedElements().remove((Object)oldTarget);
            ((Comment)source).getAnnotatedElements().add((Object)newTarget);
            isReconnected = true;
        } else if (source instanceof Constraint) {
            ((Constraint)source).getConstrainedElements().remove((Object)oldTarget);
            ((Constraint)source).getConstrainedElements().add((Object)newTarget);
            isReconnected = true;
        }
        if (isReconnected && (session = (query = new EObjectQuery((EObject)source)).getSession()) != null) {
            this.createReconnectTargetRelationBasedEdgeView((EObject)source, sourceView, session, mappingName);
        }
    }
}

