/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix;

import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractMissingExtensionMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix.ProfileMarkerResolutionUtils;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.uml2.uml.Profile;

public class NoPapyrusProfileExtensionMarkerResolution
extends AbstractMissingExtensionMarkerResolution {
    public NoPapyrusProfileExtensionMarkerResolution() {
        super(16715846);
    }

    public String getDescription() {
        return Messages.NoPapyrusProfileExtensionMarkerResolution_description;
    }

    public String getLabel() {
        return Messages.NoPapyrusProfileExtensionMarkerResolution_label;
    }

    protected String getExtensionPoint(IMarker marker) {
        return "org.eclipse.papyrus.uml.extensionpoints.UMLProfile";
    }

    protected void configureExtension(IPluginExtension extension, IMarker marker) throws CoreException {
        IPluginElement packageElement = this.createElement((IPluginParent)extension, "profile");
        Optional<Profile> profileOptional = ProfileMarkerResolutionUtils.getProfile(marker);
        if (profileOptional.isEmpty()) {
            return;
        }
        Profile profile = profileOptional.get();
        packageElement.setAttribute("name", profile.getName());
        IFile modelFile = ProfileMarkerResolutionUtils.getUMLModelFile(marker);
        packageElement.setAttribute("path", ResourceUtils.mapAndEncodePath((IFile)modelFile));
    }
}

