/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.validators;

import java.util.Arrays;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.api.IPageAddValidator;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.editor.welcome.Welcome;
import org.eclipse.papyrus.infra.ui.architecture.dialogs.ArchitectureContextDialog;
import org.eclipse.papyrus.infra.ui.architecture.messages.Messages;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ArchitecturePageAddValidator
implements IPageAddValidator {
    public boolean isValid(Object pageIdentifier) {
        Object currentPageIdentifier;
        Object object = currentPageIdentifier = pageIdentifier instanceof PageRef ? ((PageRef)pageIdentifier).getPageIdentifier() : pageIdentifier;
        if (currentPageIdentifier instanceof EObject && !(currentPageIdentifier instanceof Welcome)) {
            EObject eObject = (EObject)currentPageIdentifier;
            ViewPrototype prototype = ViewPrototype.get((EObject)eObject);
            PolicyChecker checker = PolicyChecker.getFor((EObject)eObject);
            if (checker != null && prototype != null) {
                while (!checker.isInViewpoint(prototype.getRepresentationKind())) {
                    if (this.changeArchitectureContextAndViewPoint(eObject) != 0) {
                        return false;
                    }
                    checker = PolicyChecker.getFor((EObject)eObject);
                }
                return true;
            }
        }
        return true;
    }

    private int changeArchitectureContextAndViewPoint(EObject eObject) {
        if (eObject.eResource() == null || !(eObject.eResource().getResourceSet() instanceof ModelSet)) {
            return 1;
        }
        ArchitectureDescriptionUtils helper = new ArchitectureDescriptionUtils((ModelSet)eObject.eResource().getResourceSet());
        Object[] contextIds = new String[]{helper.getArchitectureContextId()};
        Object[] viewpointIds = helper.getArchitectureViewpointIds().toArray(new String[0]);
        Shell shell = Display.getCurrent().getActiveShell();
        ArchitectureContextDialog dialog = new ArchitectureContextDialog(shell, Messages.ArchitecturePageAddValidator_diagleTitle, Messages.ArchitecturePageAddValidator_dialogLabel);
        dialog.setSelectedContexts((String[])contextIds);
        dialog.setSelectedViewpoints((String[])viewpointIds);
        dialog.create();
        int result = dialog.open();
        if (result == 0) {
            TransactionalEditingDomain dom = helper.getModelSet().getTransactionalEditingDomain();
            CompoundCommand cmd = new CompoundCommand("Change Architecture Viewpoint to open diagrams and tables");
            if (!Arrays.equals(dialog.getSelectedContextIds(), contextIds)) {
                cmd.append(helper.switchArchitectureContextId(dialog.getSelectedContextIds()[0]));
            }
            if (!Arrays.equals(dialog.getSelectedViewpointIds(), viewpointIds)) {
                cmd.append(helper.switchArchitectureViewpointIds(dialog.getSelectedViewpointIds()));
            }
            if (!cmd.isEmpty()) {
                dom.getCommandStack().execute((Command)cmd);
            }
        }
        return result;
    }
}

