/**
 * Copyright (c) 2023 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate;

import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.EAttributeTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.ILeafBodyPartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.ITemplatePartView;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>EAttribute In Markup To File</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This element allows to convert an EAttribute field written with a markup language into a file.
 *
 * Common interface for all elements used to convert a text in a markup language into a file.
 *
 * <!-- end-model-doc -->
 *
 *
 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.MarkupEMFDocumentStructureTemplatePackage#getEAttributeInMarkupToFile()
 * @model
 * @generated
 */
public interface EAttributeInMarkupToFile extends EAttributeTemplate, ILeafBodyPartTemplate, ITemplatePartView, IMarkupToFileBodyPartTemplate {
} // EAttributeInMarkupToFile
