/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModifierKind implements Enumerator
{
    EXCEPTION(0, "EXCEPTION", "exception"),
    STREAM(1, "STREAM", "stream"),
    ORDERED(2, "ORDERED", "ordered"),
    UNIQUE(3, "UNIQUE", "unique");

    public static final int EXCEPTION_VALUE = 0;
    public static final int STREAM_VALUE = 1;
    public static final int ORDERED_VALUE = 2;
    public static final int UNIQUE_VALUE = 3;
    private static final ModifierKind[] VALUES_ARRAY;
    public static final List<ModifierKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModifierKind[]{EXCEPTION, STREAM, ORDERED, UNIQUE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModifierKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModifierKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModifierKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModifierKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModifierKind get(int value) {
        switch (value) {
            case 0: {
                return EXCEPTION;
            }
            case 1: {
                return STREAM;
            }
            case 2: {
                return ORDERED;
            }
            case 3: {
                return UNIQUE;
            }
        }
        return null;
    }

    private ModifierKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

