/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.guava.internal.CheckedFuture;
import org.eclipse.papyrus.infra.sync.ISyncObject;
import org.eclipse.papyrus.infra.sync.SyncRegistry;
import org.eclipse.papyrus.infra.sync.internal.SyncService;
import org.eclipse.papyrus.infra.sync.service.ISyncService;
import org.eclipse.papyrus.infra.sync.service.SyncServiceRunnable;

public abstract class SyncObject
implements ISyncObject {
    private final ISyncService syncService;

    SyncObject() {
        this(SyncService.getCurrent());
    }

    SyncObject(ISyncService syncService) {
        if (syncService == null) {
            throw new IllegalStateException("Must be created within a SyncServiceRunnable");
        }
        this.syncService = syncService;
    }

    final ISyncService getSyncService() {
        return this.syncService;
    }

    @Override
    public TransactionalEditingDomain getEditingDomain() {
        return this.getSyncService().getEditingDomain();
    }

    @Override
    public <V, X extends Exception> V run(SyncServiceRunnable<V, X> operation) throws X {
        return this.getSyncService().run(operation);
    }

    @Override
    public <M, T, X, R extends SyncRegistry<M, T, X>> R getSyncRegistry(Class<R> registryType) {
        return this.getSyncService().getSyncRegistry(registryType);
    }

    @Override
    public void execute(Command command) {
        this.getSyncService().execute(command);
    }

    @Override
    public <V, X extends Exception> CheckedFuture<V, X> runAsync(SyncServiceRunnable<V, X> operation) {
        CheckedFuture<V, X> result = operation.asFuture(this);
        this.getSyncService().getAsyncExecutor().execute((Runnable)result);
        return result;
    }
}

