/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IAbstractPanelModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ITabFolderModel;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.DiContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.TransactionHelper;

public class TransactionalDiContentProvider
implements ISashWindowsContentProvider {
    private DiContentProvider diContentProvider;
    private TransactionalEditingDomain editingDomain;

    public TransactionalDiContentProvider(DiContentProvider diContentProvider, TransactionalEditingDomain editingDomain) {
        this.diContentProvider = diContentProvider;
        this.editingDomain = editingDomain;
    }

    private TransactionalEditingDomain getTransactionalEditingDomain() {
        return this.editingDomain;
    }

    public void addPage(final Object page) {
        try {
            TransactionHelper.run(this.getTransactionalEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalDiContentProvider.this.diContentProvider.addPage(page);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void addPage(final Object page, final int index) {
        try {
            TransactionHelper.run(this.getTransactionalEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalDiContentProvider.this.diContentProvider.addPage(page, index);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public IAbstractPanelModel createChildSashModel(Object root) {
        return this.diContentProvider.createChildSashModel(root);
    }

    public void createFolder(final ITabFolderModel tabFolder, final int tabIndex, final ITabFolderModel targetFolder, final int side) {
        try {
            TransactionHelper.run(this.getTransactionalEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalDiContentProvider.this.diContentProvider.createFolder(tabFolder, tabIndex, targetFolder, side);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void setCurrentFolder(Object rawModel) {
        this.diContentProvider.setCurrentFolder(rawModel);
    }

    public Object getRootModel() {
        return this.diContentProvider.getRootModel();
    }

    public void movePage(final ITabFolderModel folderModel, final int oldIndex, final int newIndex) {
        try {
            TransactionHelper.run(this.getTransactionalEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalDiContentProvider.this.diContentProvider.movePage(folderModel, oldIndex, newIndex);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void movePage(final ITabFolderModel srcFolderModel, final int sourceIndex, final ITabFolderModel targetFolderModel, final int targetIndex) {
        try {
            TransactionHelper.run(this.getTransactionalEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalDiContentProvider.this.diContentProvider.movePage(srcFolderModel, sourceIndex, targetFolderModel, targetIndex);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void removePage(final int index) {
        try {
            TransactionHelper.run(this.getTransactionalEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalDiContentProvider.this.diContentProvider.removePage(index);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void removePage(final Object page) {
        try {
            TransactionHelper.run(this.getTransactionalEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalDiContentProvider.this.diContentProvider.removePage(page);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void removePage(final ITabFolderModel parentFolder, final int tabIndex) {
        try {
            TransactionHelper.run(this.getTransactionalEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalDiContentProvider.this.diContentProvider.removePage(parentFolder, tabIndex);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }
}

