/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.dialog;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class LoadCurrentAxisProvidersDialog
extends Dialog {
    private TableViewer viewer;
    private EList<AbstractAxisProvider> iAxisProvidersHistory;
    private final AbstractAxisProvider currentColumnAxisProvider;
    private AbstractAxisProvider selectedAxisProvider;
    private ILabelProvider labelProvider;
    private IConfigRegistry registry;

    public LoadCurrentAxisProvidersDialog(Shell parentShell, EList<AbstractAxisProvider> iAxisProvidersHistory, AbstractAxisProvider currentColumnAxisProvider, IConfigRegistry registry) {
        super(parentShell);
        this.iAxisProvidersHistory = iAxisProvidersHistory;
        this.currentColumnAxisProvider = currentColumnAxisProvider;
        this.registry = registry;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.viewer = new TableViewer(composite, 68356);
        int[] bounds = new int[]{300, 400, 400};
        String[] titles = new String[]{Messages.LoadCurrentAxisProvidersDialog_0, Messages.LoadCurrentAxisProvidersDialog_1, Messages.LoadCurrentAxisProvidersDialog_2};
        TableViewerColumn colName = this.createTableViewerColumn(titles[0], bounds[0], 0, this.viewer);
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                AbstractAxisProvider provider = (AbstractAxisProvider)element;
                Object text = provider.getName();
                if (LoadCurrentAxisProvidersDialog.this.currentColumnAxisProvider.equals(element)) {
                    text = (String)text + Messages.LoadCurrentAxisProvidersDialog_3;
                }
                return text;
            }

            public Font getFont(Object element) {
                Font font = super.getFont(element);
                return font;
            }
        });
        TableViewerColumn colDescription = this.createTableViewerColumn(titles[1], bounds[1], 1, this.viewer);
        colDescription.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                AbstractAxisProvider provider = (AbstractAxisProvider)element;
                return provider.getDescription();
            }
        });
        TableViewerColumn colColumns = this.createTableViewerColumn(titles[2], bounds[2], 2, this.viewer);
        colColumns.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                AbstractAxisProvider provider = (AbstractAxisProvider)element;
                Object text = "";
                for (IAxis axis : provider.getAxis()) {
                    Object representedElement = axis.getElement();
                    if (LoadCurrentAxisProvidersDialog.this.labelProvider != null) continue;
                    if (representedElement instanceof ENamedElement) {
                        text = (String)text + ((ENamedElement)representedElement).getName() + ", ";
                        continue;
                    }
                    String string = representedElement.toString();
                    text = (String)text + string.substring(string.lastIndexOf("::") + 2) + ", ";
                }
                if (!((String)text).isEmpty()) {
                    text = ((String)text).substring(0, ((String)text).length() - 2);
                }
                return text;
            }
        });
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(this.iAxisProvidersHistory);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                LoadCurrentAxisProvidersDialog.this.setSelectedAxisProvider(selection.getFirstElement());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                LoadCurrentAxisProvidersDialog.this.setSelectedAxisProvider(selection.getFirstElement());
                LoadCurrentAxisProvidersDialog.this.close();
            }
        });
        this.viewer.refresh();
        return composite;
    }

    private void setSelectedAxisProvider(Object firstElement) {
        this.selectedAxisProvider = (AbstractAxisProvider)firstElement;
    }

    public AbstractAxisProvider getSelectedAxisProvider() {
        return this.selectedAxisProvider;
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber, TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }
}

