/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.providers;

import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.ui.providers.DelegatingPapyrusContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;

public class CompositePapyrusContentProvider
implements IAdaptableContentProvider,
IHierarchicContentProvider,
IStaticContentProvider {
    private final ITreeContentProvider[] delegates;

    public CompositePapyrusContentProvider(ITreeContentProvider ... delegates) {
        this.delegates = new ITreeContentProvider[delegates.length];
        int i = 0;
        while (i < delegates.length) {
            this.delegates[i] = DelegatingPapyrusContentProvider.wrap(delegates[i]);
            ++i;
        }
    }

    public CompositePapyrusContentProvider(Iterable<? extends ITreeContentProvider> delegates) {
        this((ITreeContentProvider[])Iterables.toArray(delegates, ITreeContentProvider.class));
    }

    public Object[] getElements(Object inputElement) {
        return Stream.of(this.delegates).flatMap(d -> Stream.of(d.getElements(inputElement))).toArray();
    }

    public void dispose() {
        Stream.of(this.delegates).forEach(IContentProvider::dispose);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Stream.of(this.delegates).forEach(d -> d.inputChanged(viewer, oldInput, newInput));
    }

    public Object[] getChildren(Object parentElement) {
        return Stream.of(this.delegates).flatMap(d -> Stream.of(d.getChildren(parentElement))).toArray();
    }

    public Object getParent(Object element) {
        return Stream.of(this.delegates).map(d -> d.getParent(element)).filter(Objects::nonNull).findAny().orElse(null);
    }

    public boolean hasChildren(Object element) {
        return Stream.of(this.delegates).anyMatch(d -> d.hasChildren(element));
    }

    public Object getAdaptedValue(Object containerElement) {
        return Stream.of(this.delegates).map(IAdaptableContentProvider.class::cast).map(d -> d.getAdaptedValue(containerElement)).filter(Objects::nonNull).findAny().orElse(containerElement);
    }

    public boolean isValidValue(Object element) {
        return Stream.of(this.delegates).map(IHierarchicContentProvider.class::cast).anyMatch(d -> d.isValidValue(element));
    }

    public Object[] getElements() {
        return Stream.of(this.delegates).map(IStaticContentProvider.class::cast).flatMap(d -> Stream.of(d.getElements())).toArray();
    }
}

