/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import gmfgraph.attr.CustomAttributeOwner;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.gmfgraph.Alignment;
import org.eclipse.papyrus.gmf.gmfgraph.BorderLayout;
import org.eclipse.papyrus.gmf.gmfgraph.CustomLayout;
import org.eclipse.papyrus.gmf.gmfgraph.Dimension;
import org.eclipse.papyrus.gmf.gmfgraph.FlowLayout;
import org.eclipse.papyrus.gmf.gmfgraph.GridLayout;
import org.eclipse.papyrus.gmf.gmfgraph.LayoutRef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class Layout {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private gmfgraph.Runtime xptRuntime;
  
  @Inject
  private CustomAttributeOwner xptCustomAttributeOwner;
  
  public CharSequence Init(final org.eclipse.papyrus.gmf.gmfgraph.Layout layout, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(layout, null));
      if (_notEquals) {
        CharSequence _dispatch_Init = this.dispatch_Init(layout, owningFigureVariable);
        _builder.append(_dispatch_Init);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _dispatch_Init(final org.eclipse.papyrus.gmf.gmfgraph.Layout it, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(owningFigureVariable);
    _builder.append(".setLayoutManager(");
    CharSequence _newInstance = this.xptRuntime.newInstance(it);
    _builder.append(_newInstance);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _dispatch_Init(final LayoutRef it, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    {
      org.eclipse.papyrus.gmf.gmfgraph.Layout _actual = it.getActual();
      boolean _notEquals = (!Objects.equal(_actual, null));
      if (_notEquals) {
        CharSequence _dispatch_Init = this.dispatch_Init(it.getActual(), owningFigureVariable);
        _builder.append(_dispatch_Init);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _dispatch_Init(final BorderLayout it, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    String layoutVarName = this.layoutVarName(owningFigureVariable);
    _builder.newLineIfNotEmpty();
    CharSequence _newInstance = this.xptRuntime.newInstance(it, layoutVarName);
    _builder.append(_newInstance);
    _builder.newLineIfNotEmpty();
    {
      Dimension _spacing = it.getSpacing();
      boolean _notEquals = (!Objects.equal(null, _spacing));
      if (_notEquals) {
        _builder.append(layoutVarName);
        _builder.append(".setHorizontalSpacing(");
        int _dx = it.getSpacing().getDx();
        _builder.append(_dx);
        _builder.append(");// TODO mapMode?");
        _builder.newLineIfNotEmpty();
        _builder.append(layoutVarName);
        _builder.append(".setVerticalSpacing(");
        int _dy = it.getSpacing().getDy();
        _builder.append(_dy);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(owningFigureVariable);
    _builder.append(".setLayoutManager(");
    _builder.append(layoutVarName);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
    _builder.append(_extraLineBreak_1);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _dispatch_Init(final GridLayout it, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    String layoutVarName = this.layoutVarName(owningFigureVariable);
    _builder.newLineIfNotEmpty();
    CharSequence _newInstance = this.xptRuntime.newInstance(it, layoutVarName);
    _builder.append(_newInstance);
    _builder.newLineIfNotEmpty();
    _builder.append(layoutVarName);
    _builder.append(".numColumns = ");
    int _numColumns = it.getNumColumns();
    _builder.append(_numColumns);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append(layoutVarName);
    _builder.append(".makeColumnsEqualWidth = ");
    boolean _isEqualWidth = it.isEqualWidth();
    _builder.append(_isEqualWidth);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    {
      Dimension _spacing = it.getSpacing();
      boolean _notEquals = (!Objects.equal(null, _spacing));
      if (_notEquals) {
        _builder.append(layoutVarName);
        _builder.append(".horizontalSpacing = ");
        int _dx = it.getSpacing().getDx();
        _builder.append(_dx);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append(layoutVarName);
        _builder.append(".verticalSpacing = ");
        int _dy = it.getSpacing().getDy();
        _builder.append(_dy);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Dimension _margins = it.getMargins();
      boolean _notEquals_1 = (!Objects.equal(null, _margins));
      if (_notEquals_1) {
        _builder.append(layoutVarName);
        _builder.append(".marginWidth = ");
        int _dx_1 = it.getMargins().getDx();
        _builder.append(_dx_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append(layoutVarName);
        _builder.append(".marginHeight = ");
        int _dy_1 = it.getMargins().getDy();
        _builder.append(_dy_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(owningFigureVariable);
    _builder.append(".setLayoutManager(");
    _builder.append(layoutVarName);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
    _builder.append(_extraLineBreak_1);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _dispatch_Init(final FlowLayout it, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    String layoutVarName = this.layoutVarName(owningFigureVariable);
    _builder.newLineIfNotEmpty();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    CharSequence _newInstance = this.xptRuntime.newInstance(it, layoutVarName);
    _builder.append(_newInstance);
    _builder.newLineIfNotEmpty();
    _builder.append(layoutVarName);
    _builder.append(".setStretchMinorAxis(");
    boolean _isMatchMinorSize = it.isMatchMinorSize();
    _builder.append(_isMatchMinorSize);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(layoutVarName);
    _builder.append(".setMinorAlignment(");
    CharSequence _fqn = this.xptRuntime.fqn(it);
    _builder.append(_fqn);
    _builder.append(".");
    String _alignment = this.alignment(it.getMinorAlignment(), it.isForceSingleLine());
    _builder.append(_alignment);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    {
      boolean _isForceSingleLine = it.isForceSingleLine();
      if (_isForceSingleLine) {
        CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
        _builder.append(_extraLineBreak_1);
        _builder.newLineIfNotEmpty();
        _builder.append(layoutVarName);
        _builder.append(".setSpacing(");
        int _majorSpacing = it.getMajorSpacing();
        _builder.append(_majorSpacing);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append(layoutVarName);
        _builder.append(".setVertical(");
        boolean _isVertical = it.isVertical();
        _builder.append(_isVertical);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _extraLineBreak_2 = this._common.extraLineBreak();
        _builder.append(_extraLineBreak_2);
        _builder.newLineIfNotEmpty();
        _builder.append(layoutVarName);
        _builder.append(".setMajorAlignment(");
        CharSequence _fqn_1 = this.xptRuntime.fqn(it);
        _builder.append(_fqn_1);
        _builder.append(".");
        String _alignment_1 = this.alignment(it.getMajorAlignment(), it.isForceSingleLine());
        _builder.append(_alignment_1);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append(layoutVarName);
        _builder.append(".setMajorSpacing(");
        int _majorSpacing_1 = it.getMajorSpacing();
        _builder.append(_majorSpacing_1);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append(layoutVarName);
        _builder.append(".setMinorSpacing(");
        int _minorSpacing = it.getMinorSpacing();
        _builder.append(_minorSpacing);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append(layoutVarName);
        _builder.append(".setHorizontal(");
        boolean _isVertical_1 = it.isVertical();
        boolean _not = (!_isVertical_1);
        _builder.append(_not);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _extraLineBreak_3 = this._common.extraLineBreak();
    _builder.append(_extraLineBreak_3);
    _builder.newLineIfNotEmpty();
    _builder.append(owningFigureVariable);
    _builder.append(".setLayoutManager(");
    _builder.append(layoutVarName);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _extraLineBreak_4 = this._common.extraLineBreak();
    _builder.append(_extraLineBreak_4);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _dispatch_Init(final CustomLayout it, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    String layoutVarName = this.layoutVarName(owningFigureVariable);
    _builder.newLineIfNotEmpty();
    CharSequence _newInstance = this.xptRuntime.newInstance(it, layoutVarName);
    _builder.append(_newInstance);
    _builder.newLineIfNotEmpty();
    CharSequence _Init = this.xptCustomAttributeOwner.Init(it, layoutVarName);
    _builder.append(_Init);
    _builder.newLineIfNotEmpty();
    _builder.append(owningFigureVariable);
    _builder.append(".setLayoutManager(");
    _builder.append(layoutVarName);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
    _builder.append(_extraLineBreak_1);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public String layoutVarName(final String owningFigureVariable) {
    String _firstUpper = StringExtensions.toFirstUpper(owningFigureVariable);
    return ("layout" + _firstUpper);
  }
  
  public String alignment(final Alignment alignment, final boolean forceSingleLine) {
    String _switchResult = null;
    if (alignment != null) {
      switch (alignment) {
        case BEGINNING_LITERAL:
          String _xifexpression = null;
          if (forceSingleLine) {
            _xifexpression = "ALIGN_TOPLEFT";
          } else {
            _xifexpression = "ALIGN_LEFTTOP";
          }
          return _xifexpression;
        case END_LITERAL:
          String _xifexpression_1 = null;
          if (forceSingleLine) {
            _xifexpression_1 = "ALIGN_BOTTOMRIGHT";
          } else {
            _xifexpression_1 = "ALIGN_RIGHTBOTTOM";
          }
          return _xifexpression_1;
        default:
          _switchResult = "ALIGN_CENTER";
          break;
      }
    } else {
      _switchResult = "ALIGN_CENTER";
    }
    return _switchResult;
  }
  
  public CharSequence dispatch_Init(final org.eclipse.papyrus.gmf.gmfgraph.Layout it, final String owningFigureVariable) {
    if (it instanceof CustomLayout) {
      return _dispatch_Init((CustomLayout)it, owningFigureVariable);
    } else if (it instanceof BorderLayout) {
      return _dispatch_Init((BorderLayout)it, owningFigureVariable);
    } else if (it instanceof FlowLayout) {
      return _dispatch_Init((FlowLayout)it, owningFigureVariable);
    } else if (it instanceof GridLayout) {
      return _dispatch_Init((GridLayout)it, owningFigureVariable);
    } else if (it instanceof LayoutRef) {
      return _dispatch_Init((LayoutRef)it, owningFigureVariable);
    } else if (it != null) {
      return _dispatch_Init(it, owningFigureVariable);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, owningFigureVariable).toString());
    }
  }
}
