/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.gmfgraph.Figure;
import org.eclipse.papyrus.gmf.gmfgraph.FigureRef;
import org.eclipse.papyrus.gmf.gmfgraph.RealFigure;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class Children {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private Attrs xptAttrs;
  
  @Inject
  private LayoutData xptLayoutData;
  
  @Inject
  private Layout xptLayout;
  
  @Inject
  private gmfgraph.Runtime xptRuntime;
  
  public CharSequence CreateChildren(final RealFigure it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private void createContents(){");
    _builder.newLine();
    {
      EList<Figure> _children = it.getChildren();
      for(final Figure child : _children) {
        _builder.append("\t");
        CharSequence _instantiate = this.instantiate(child, 0, it, "this");
        _builder.append(_instantiate, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _instantiate(final Figure it, final int count, final RealFigure parentFigure, final String parentFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR("Abstract instantiate(int, RealFigure, String)");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _instantiate(final FigureRef it, final int count, final RealFigure parentFigure, final String parentFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    CharSequence _instantiate = this.instantiate(it.getFigure(), count, parentFigure, parentFigureVariable);
    _builder.append(_instantiate);
    _builder.newLineIfNotEmpty();
    _builder.append("// Process FigureRef details");
    _builder.newLine();
    CharSequence _populate = this.populate(it, count, parentFigure, parentFigureVariable, this._utils_qvto.figureVariableName(it.getFigure(), count));
    _builder.append(_populate);
    _builder.newLineIfNotEmpty();
    CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
    _builder.append(_extraLineBreak_1);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _instantiate(final RealFigure it, final int count, final RealFigure parentFigure, final String parentFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    CharSequence _newFigureInstance = this.newFigureInstance(it, this._utils_qvto.figureVariableName(it, count));
    _builder.append(_newFigureInstance);
    _builder.newLineIfNotEmpty();
    CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
    _builder.append(_extraLineBreak_1);
    _builder.newLineIfNotEmpty();
    CharSequence _populate = this.populate(it, count, parentFigure, parentFigureVariable, this._utils_qvto.figureVariableName(it, count));
    _builder.append(_populate);
    _builder.newLineIfNotEmpty();
    {
      EList<Figure> _children = it.getChildren();
      for(final Figure c : _children) {
        CharSequence _instantiate = this.instantiate(c, (count + 1), it, this._utils_qvto.figureVariableName(it, count));
        _builder.append(_instantiate);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _extraLineBreak_2 = this._common.extraLineBreak();
    _builder.append(_extraLineBreak_2);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence populate(final Figure it, final int count, final RealFigure parentFigure, final String parentFigureVariable, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    CharSequence _Init = this.xptAttrs.Init(it, figureVarName);
    _builder.append(_Init);
    _builder.newLineIfNotEmpty();
    {
      if ((Objects.equal(null, it.getLayoutData()) || Objects.equal(null, parentFigure.getLayout()))) {
        CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
        _builder.append(_extraLineBreak_1);
        _builder.newLineIfNotEmpty();
        _builder.append(parentFigureVariable);
        _builder.append(".add(");
        _builder.append(figureVarName);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _Init_1 = this.xptLayoutData.Init(it.getLayoutData(), parentFigureVariable, figureVarName);
        _builder.append(_Init_1);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _Init_2 = this.xptLayout.Init(it.getLayout(), figureVarName);
    _builder.append(_Init_2);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence newFigureInstance(final RealFigure it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _needsField = this._utils_qvto.needsField(it);
      if (_needsField) {
        _builder.append(figureVarName);
        _builder.append(" = ");
        CharSequence _newInstance = this.xptRuntime.newInstance(it);
        _builder.append(_newInstance);
        _builder.append(";");
      } else {
        CharSequence _newInstance_1 = this.xptRuntime.newInstance(it, figureVarName);
        _builder.append(_newInstance_1);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence instantiate(final Figure it, final int count, final RealFigure parentFigure, final String parentFigureVariable) {
    if (it instanceof FigureRef) {
      return _instantiate((FigureRef)it, count, parentFigure, parentFigureVariable);
    } else if (it instanceof RealFigure) {
      return _instantiate((RealFigure)it, count, parentFigure, parentFigureVariable);
    } else if (it != null) {
      return _instantiate(it, count, parentFigure, parentFigureVariable);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, count, parentFigure, parentFigureVariable).toString());
    }
  }
}
