/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.edit.ui.provider.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.IFireDoubleClick;
import org.eclipse.papyrus.infra.widgets.SelectorDialogTabReader;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.ITreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IDependableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IDependableLabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalLabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TreeSelectorDialog
extends SelectionDialog
implements ITreeSelectorDialog {
    protected static final String ICONS_TREE_VIEW = "/icons/treeView.gif";
    private static final String ICON_PAPYRUS = "/icons/papyrus.png";
    private Map<String, ILabelProvider> labelProviders = new HashMap<String, ILabelProvider>();
    private Map<String, ITreeContentProvider> contentProviders = new HashMap<String, ITreeContentProvider>();
    private Map<String, TreeViewer> treeViewers = new HashMap<String, TreeViewer>();
    private Map<String, Composite> tabComposites = new HashMap<String, Composite>();
    private static String defaultTabId = "default";
    private Map<String, String> descriptions = new HashMap<String, String>();
    private Object input = null;
    private final Set<ICommitListener> commitListeners = new HashSet<ICommitListener>();
    private Map<String, String> tabNames = new HashMap<String, String>();
    private Map<String, Image> tabIcons = new HashMap<String, Image>();
    private List<String> tabIds = new ArrayList<String>();
    private String currentTabId = defaultTabId;
    private TabFolder tabFolder;
    private boolean initialized = false;
    private boolean okPressed = false;
    protected static final String DIALOG_SETTINGS_KEY = TreeSelectorDialog.class.getName();
    protected static final String LAST_TAB_KEY = "lastTab";

    public TreeSelectorDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void initializeTabulationInfo() {
        SelectorDialogTabReader instance = SelectorDialogTabReader.getInstance();
        this.tabIds.add(defaultTabId);
        this.tabNames.put(defaultTabId, Messages.TreeSelectorDialog_defaultTabLabel);
        Image treeIcon = Activator.getDefault().getImage("org.eclipse.papyrus.infra.widgets", ICONS_TREE_VIEW);
        this.tabIcons.put(defaultTabId, treeIcon);
        List<String> ids = instance.getIds();
        for (String string : ids) {
            ILabelProvider tabLabelProvider = instance.getLabelProviders().get(string);
            this.labelProviders.put(string, tabLabelProvider);
            if (tabLabelProvider instanceof IDependableLabelProvider) {
                ((IDependableLabelProvider)tabLabelProvider).setLabelProvider(this.labelProviders.get(defaultTabId));
            }
            ITreeContentProvider tabContentProvider = instance.getContentProviders().get(string);
            this.contentProviders.put(string, tabContentProvider);
            if (tabContentProvider instanceof IDependableContentProvider) {
                ((IDependableContentProvider)tabContentProvider).setContentProvider(this.contentProviders.get(defaultTabId));
            }
            Constraint constraint = instance.getConstraints().get(string);
            if (this.tabIds.contains(string) || constraint != null && !constraint.match(Collections.singleton(string))) continue;
            this.tabIds.addAll(ids);
            this.tabNames.put(string, instance.getTabNames().get(string));
            this.tabIcons.put(string, instance.getTabIcons().get(string));
            this.descriptions.put(string, instance.getDescriptions().get(string));
        }
        for (Map.Entry entry : this.labelProviders.entrySet()) {
            ((ILabelProvider)entry.getValue()).addListener(event -> {
                Object key = entry.getKey();
                TreeViewer treeViewer = this.treeViewers.get(key);
                if (treeViewer != null && !treeViewer.getTree().isDisposed()) {
                    treeViewer.refresh();
                }
            });
        }
        this.initialized = true;
    }

    public void setLabelProvider(String tabId, ILabelProvider provider) {
        TreeViewer viewer = this.treeViewers.get(tabId);
        if (viewer != null) {
            if (provider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
                viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)provider));
            } else {
                viewer.setLabelProvider((IBaseLabelProvider)provider);
            }
        }
        provider.addListener(event -> {
            TreeViewer currentTreeViewer = this.treeViewers.get(this.currentTabId);
            if (currentTreeViewer != null && !currentTreeViewer.getTree().isDisposed()) {
                currentTreeViewer.refresh();
            }
        });
    }

    @Override
    public void setLabelProvider(ILabelProvider provider) {
        this.labelProviders.put(defaultTabId, provider);
        this.setLabelProvider(defaultTabId, provider);
    }

    @Override
    public void setContentProvider(ITreeContentProvider provider) {
        this.contentProviders.put(defaultTabId, provider);
        this.setContentProvider(defaultTabId, provider);
    }

    public void setContentProvider(String tabId, ITreeContentProvider provider) {
        if (this.treeViewers.get(tabId) != null) {
            this.initViewerAndProvider(tabId);
        }
        if (provider instanceof ICommitListener) {
            this.commitListeners.add((ICommitListener)provider);
        }
    }

    private void initViewerAndProvider(String tabId) {
        this.treeViewers.get(tabId).setContentProvider((IContentProvider)this.contentProviders.get(tabId));
        if (this.treeViewers.get(tabId).getInput() == null && tabId.equals(this.currentTabId)) {
            this.doSetInput(tabId);
        }
    }

    protected void initViewerAndProvider() {
        this.initViewerAndProvider(defaultTabId);
    }

    protected Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public void create() {
        super.create();
        this.okPressed = false;
        this.createTabs();
        if (1 < this.tabIds.size()) {
            String lastSelectedTabId = this.getDialogSettings().get(LAST_TAB_KEY);
            if (lastSelectedTabId != null) {
                int indexOfLast = this.tabIds.indexOf(lastSelectedTabId);
                if (indexOfLast >= 0) {
                    this.currentTabId = lastSelectedTabId;
                    this.tabFolder.setSelection(indexOfLast);
                }
            } else {
                this.currentTabId = defaultTabId;
            }
        } else {
            this.currentTabId = defaultTabId;
        }
        this.doSetInput(this.currentTabId);
        this.revealInitialElement(this.contentProviders.get(this.currentTabId), this.treeViewers.get(this.currentTabId));
        this.getShell().setDefaultButton(null);
        this.getButton(0).setFocus();
        this.getShell().setImage(Activator.getDefault().getImage(ICON_PAPYRUS));
        this.getShell().pack();
    }

    protected void createTabs() {
        if (!this.initialized) {
            this.initializeTabulationInfo();
        }
        if (this.tabIds.size() > 1) {
            this.tabFolder = new TabFolder(this.getDialogArea(), 64);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tabFolder);
        }
        for (String tabId : this.tabIds) {
            String tabName = this.tabNames.get(tabId);
            Image tabIcon = this.tabIcons.get(tabId);
            String tabDescription = this.descriptions.get(tabId);
            ILabelProvider tabLabelProvider = this.labelProviders.get(tabId);
            ITreeContentProvider tabContentProvider = this.contentProviders.get(tabId);
            Composite tabComposite = null;
            if (this.tabIds.size() > 1) {
                TabItem item = new TabItem(this.tabFolder, 0);
                item.setText(tabName);
                item.setImage(tabIcon);
                tabComposite = new Composite((Composite)this.tabFolder, 0);
                GridLayoutFactory.swtDefaults().applyTo(tabComposite);
                item.setControl((Control)tabComposite);
            } else {
                tabComposite = new Composite(this.getDialogArea(), 0);
                GridLayoutFactory.swtDefaults().applyTo(tabComposite);
            }
            if (this.getMessage() != null && !this.getMessage().isEmpty()) {
                Label messageLabel = new Label(tabComposite, 64);
                messageLabel.setLayoutData((Object)new GridData(4, 4, true, false));
                messageLabel.setText(this.getMessage());
            }
            if (this.descriptions.get(tabId) != null && !this.descriptions.get(tabId).isEmpty()) {
                Label descriptionLabel = new Label(tabComposite, 64);
                descriptionLabel.setLayoutData((Object)new GridData(4, 4, true, false));
                descriptionLabel.setText(tabDescription);
            }
            ExtendedTreeViewer tabTreeViewer = new ExtendedTreeViewer(tabComposite, 2048);
            GridDataFactory.fillDefaults().grab(true, true).hint(300, 300).applyTo((Control)tabTreeViewer.getTree());
            this.treeViewers.put(tabId, tabTreeViewer);
            if (tabLabelProvider != null) {
                if (tabLabelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
                    tabTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)tabLabelProvider));
                } else {
                    tabTreeViewer.setLabelProvider((IBaseLabelProvider)tabLabelProvider);
                }
            }
            if (tabContentProvider != null) {
                this.initViewerAndProvider(tabId);
            }
            tabTreeViewer.addSelectionChangedListener(new SelectionChangedListenerImplementation());
            tabTreeViewer.addDoubleClickListener(new DoubleClickListenerImplementation());
            if (tabId.equals(this.currentTabId)) {
                this.createContent(tabContentProvider, tabLabelProvider, tabComposite, tabTreeViewer);
            } else {
                this.tabComposites.put(tabId, tabComposite);
            }
            if (this.tabIds.size() <= 1) continue;
            this.tabFolder.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TreeSelectorDialog.this.currentTabId = TreeSelectorDialog.this.tabIds.get(TreeSelectorDialog.this.tabFolder.getSelectionIndex());
                    TreeSelectorDialog.this.getDialogSettings().put(TreeSelectorDialog.LAST_TAB_KEY, TreeSelectorDialog.this.currentTabId);
                    if (TreeSelectorDialog.this.tabComposites.containsKey(TreeSelectorDialog.this.currentTabId)) {
                        TreeSelectorDialog.this.doSetInput(TreeSelectorDialog.this.currentTabId);
                        TreeSelectorDialog.this.createContent(TreeSelectorDialog.this.contentProviders.get(TreeSelectorDialog.this.currentTabId), TreeSelectorDialog.this.labelProviders.get(TreeSelectorDialog.this.currentTabId), TreeSelectorDialog.this.tabComposites.get(TreeSelectorDialog.this.currentTabId), TreeSelectorDialog.this.treeViewers.get(TreeSelectorDialog.this.currentTabId));
                        TreeSelectorDialog.this.revealInitialElement(TreeSelectorDialog.this.contentProviders.get(TreeSelectorDialog.this.currentTabId), TreeSelectorDialog.this.treeViewers.get(TreeSelectorDialog.this.currentTabId));
                        TreeSelectorDialog.this.tabComposites.remove(TreeSelectorDialog.this.currentTabId);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        return settings;
    }

    protected void revealInitialElement(ITreeContentProvider contentProvider, TreeViewer treeViewer) {
        List initialSelection = this.getInitialElementSelections();
        if (contentProvider instanceof IRevealSemanticElement) {
            ((IRevealSemanticElement)contentProvider).revealSemanticElement(initialSelection);
        } else if (!initialSelection.isEmpty() && initialSelection.get(0) != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection(initialSelection.get(0)), true);
        }
    }

    protected void createContent(ITreeContentProvider contentProvider, ILabelProvider labelProvider, Composite parent, TreeViewer treeViewer) {
        if (contentProvider instanceof IGraphicalContentProvider || labelProvider instanceof IGraphicalLabelProvider) {
            Composite toolbar = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).spacing(2, 0).applyTo(toolbar);
            toolbar.setLayoutData((Object)new GridData(4, 0, true, false));
            Composite beforeTreeComposite = new Composite(toolbar, 0);
            beforeTreeComposite.setLayout((Layout)new FillLayout(512));
            beforeTreeComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            if (contentProvider instanceof IGraphicalContentProvider) {
                ((IGraphicalContentProvider)contentProvider).createBefore(beforeTreeComposite);
            }
            if (labelProvider instanceof IGraphicalLabelProvider) {
                ((IGraphicalLabelProvider)labelProvider).createBefore(beforeTreeComposite);
            }
            beforeTreeComposite.moveAbove(treeViewer.getControl());
            Label separator = new Label(toolbar, 514);
            GridDataFactory.fillDefaults().hint(-1, 10).grab(false, false).applyTo((Control)separator);
            Composite iconsComposite = new Composite(toolbar, 0);
            FillLayout iconsLayout = new FillLayout(256);
            iconsLayout.spacing = 2;
            iconsComposite.setLayout((Layout)iconsLayout);
            if (contentProvider instanceof IGraphicalContentProvider) {
                ((IGraphicalContentProvider)contentProvider).createViewerToolbar(iconsComposite);
            }
            if (labelProvider instanceof IGraphicalLabelProvider) {
                ((IGraphicalLabelProvider)labelProvider).createViewerToolbar(iconsComposite);
            }
            if (iconsComposite.getChildren().length == 0) {
                separator.setVisible(false);
                ((GridData)separator.getLayoutData()).exclude = true;
            }
            toolbar.moveAbove(treeViewer.getControl());
            Composite afterTreeComposite = new Composite(parent, 0);
            afterTreeComposite.setLayout((Layout)new FillLayout(512));
            afterTreeComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            if (labelProvider instanceof IGraphicalLabelProvider) {
                ((IGraphicalLabelProvider)labelProvider).createAfter(afterTreeComposite);
            }
            if (contentProvider instanceof IGraphicalContentProvider) {
                ((IGraphicalContentProvider)contentProvider).createAfter(afterTreeComposite);
            }
        }
    }

    public void setDescription(String tabId, String description) {
        this.descriptions.put(tabId, description);
    }

    @Override
    public void setDescription(String description) {
        this.setDescription(defaultTabId, description);
    }

    protected TreeViewer getViewer() {
        return this.getViewer(defaultTabId);
    }

    protected TreeViewer getViewer(String tabId) {
        return this.treeViewers.get(tabId);
    }

    @Override
    public void setInput(Object input) {
        this.input = input;
    }

    private void doSetInput(String TabId) {
        if (this.treeViewers.get(TabId) != null) {
            if (this.input == null) {
                this.treeViewers.get(TabId).setInput((Object)"");
            } else {
                this.treeViewers.get(TabId).setInput(this.input);
            }
        }
    }

    public void okPressed() {
        this.okPressed = true;
        for (ICommitListener listener : this.commitListeners) {
            listener.commit(null);
        }
        super.okPressed();
    }

    private final class DoubleClickListenerImplementation
    implements IDoubleClickListener {
        private DoubleClickListenerImplementation() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (TreeSelectorDialog.this.getOkButton().isEnabled()) {
                TreeSelectorDialog.this.okPressed();
            }
        }
    }

    private class ExtendedTreeViewer
    extends TreeViewer
    implements IFireDoubleClick {
        public ExtendedTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        @Override
        public void fireDoubleClick(DoubleClickEvent event) {
            super.fireDoubleClick(event);
        }
    }

    private final class SelectionChangedListenerImplementation
    implements ISelectionChangedListener {
        private SelectionChangedListenerImplementation() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!TreeSelectorDialog.this.okPressed) {
                ISelection selection = event.getSelection();
                Object selectedElement = null;
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    IStructuredSelection sSelection = (IStructuredSelection)selection;
                    selectedElement = sSelection.getFirstElement();
                }
                ITreeContentProvider currentContentProvider = null;
                for (Map.Entry<String, TreeViewer> entry : TreeSelectorDialog.this.treeViewers.entrySet()) {
                    if (!entry.getValue().equals(event.getSource())) continue;
                    currentContentProvider = TreeSelectorDialog.this.contentProviders.get(entry.getKey());
                }
                if (currentContentProvider instanceof IHierarchicContentProvider) {
                    boolean isValidValue = ((IHierarchicContentProvider)currentContentProvider).isValidValue(selectedElement);
                    if (currentContentProvider instanceof IAdaptableContentProvider) {
                        selectedElement = ((IAdaptableContentProvider)currentContentProvider).getAdaptedValue(selectedElement);
                    }
                    if (isValidValue) {
                        TreeSelectorDialog.this.setResult(Collections.singletonList(selectedElement));
                    } else {
                        TreeSelectorDialog.this.setResult(Collections.EMPTY_LIST);
                    }
                    TreeSelectorDialog.this.getOkButton().setEnabled(isValidValue);
                }
            }
        }
    }
}

