/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.OneLineBorder;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SlidableRoundedRectangleAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.swt.graphics.Color;

public class OneTopLineResizableBorder
extends OneLineBorder {
    private int forcedLength = -1;
    private float lengthRatio = 1.0f;
    private int linePosition = 2;

    public void setLinePosition(int linePosition) {
        this.linePosition = linePosition;
    }

    public void setLengthRatio(float lengthRatio) {
        this.lengthRatio = lengthRatio;
    }

    public OneTopLineResizableBorder() {
    }

    public OneTopLineResizableBorder(Color color) {
        super(color);
    }

    public OneTopLineResizableBorder(int width) {
        super(width, 8);
    }

    public OneTopLineResizableBorder(int length, int width) {
        super(width, 8);
        this.forcedLength = length;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        int length;
        tempRect.setBounds(OneTopLineResizableBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        OneTopLineResizableBorder.tempRect.width = length = this.getLineLength(figure);
        if (this.forcedLength != -1) {
            OneTopLineResizableBorder.tempRect.width = this.forcedLength;
        }
        OneTopLineResizableBorder.tempRect.width = (int)((float)OneTopLineResizableBorder.tempRect.width * this.lengthRatio);
        switch (this.linePosition) {
            case 2: {
                OneTopLineResizableBorder.tempRect.x += (length - OneTopLineResizableBorder.tempRect.width) / 2;
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                OneTopLineResizableBorder.tempRect.x += length - OneTopLineResizableBorder.tempRect.width;
                break;
            }
            default: {
                OneTopLineResizableBorder.tempRect.x += (length - OneTopLineResizableBorder.tempRect.width) / 2;
            }
        }
        int one = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(1);
        int widthInDP = this.getWidth() / one;
        int halfWidthInLP = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(widthInDP / 2);
        graphics.setLineWidth(this.getWidth());
        graphics.setLineStyle(this.getStyle());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        OneTopLineResizableBorder.tempRect.y += halfWidthInLP;
        OneTopLineResizableBorder.tempRect.height -= this.getWidth();
        IRoundedRectangleFigure parentFigureRoundedRectangle = FigureUtils.findParentFigureInstance(figure, IRoundedRectangleFigure.class);
        if (parentFigureRoundedRectangle != null) {
            graphics.setAlpha(255 - ((NodeFigure)parentFigureRoundedRectangle).getTransparency() * 255 / 100);
        }
        graphics.drawLine(tempRect.getTopLeft(), tempRect.getTopRight());
    }

    private int getLineLength(IFigure figure) {
        ConnectionAnchor connectionAnchor;
        int length = OneTopLineResizableBorder.tempRect.width;
        SVGNodePlateFigure mainFigure = FigureUtils.findParentFigureInstance(figure, SVGNodePlateFigure.class);
        if (mainFigure != null && (connectionAnchor = mainFigure.getConnectionAnchor("")) instanceof SlidableRoundedRectangleAnchor && !mainFigure.getBounds().equals((Object)new Rectangle())) {
            Rectangle rect = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)rect);
            Point locationLeft = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(rect.getTopLeft().translate(rect.width / 2, 0), rect.getTopLeft());
            Point locationRight = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(rect.getTopLeft().translate(rect.width / 2, 0), rect.getTopRight());
            if (locationLeft != null && locationRight != null) {
                rect.width = locationRight.x - locationLeft.x;
                figure.translateToRelative((Translatable)rect);
                length = rect.width;
                figure.translateToRelative((Translatable)locationLeft);
                OneTopLineResizableBorder.tempRect.x = locationLeft.x;
            }
        }
        return length;
    }

    public void setLength(int length) {
        this.forcedLength = length;
    }
}

