/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractMissingExtensionMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix.ProfileMarkerResolutionUtils;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.uml2.uml.util.UMLUtil;

public class NoEcoreGenPackageMarkerResolution
extends AbstractMissingExtensionMarkerResolution {
    public NoEcoreGenPackageMarkerResolution() {
        super(16715844);
    }

    public String getDescription() {
        return Messages.NoEcoreGenPackageMarkerResolution_description;
    }

    public String getLabel() {
        return Messages.NoEcoreGenPackageMarkerResolution_label;
    }

    protected String getExtensionPoint(IMarker marker) {
        return "org.eclipse.emf.ecore.generated_package";
    }

    protected void configureExtension(IPluginExtension extension, IMarker marker) throws CoreException {
        String packageClassName;
        String uri;
        IPluginElement packageElement = this.createElement((IPluginParent)extension, "package");
        IFile genModel = ProfileMarkerResolutionUtils.getGenModelFile(marker);
        if (genModel != null) {
            IPath relativePath = genModel.getProjectRelativePath();
            packageElement.setAttribute("genModel", ResourceUtils.getStringURI((IPath)relativePath));
        }
        if ((uri = ProfileMarkerResolutionUtils.getStereotypeUri(marker)) != null) {
            packageElement.setAttribute("uri", uri);
        }
        String string = packageClassName = genModel == null ? null : this.getPackageInterfaceName(genModel);
        if (packageClassName != null) {
            packageElement.setAttribute("class", packageClassName);
        }
    }

    private String getPackageInterfaceName(IFile genModelFile) {
        String result = null;
        ResourceSetImpl rset = new ResourceSetImpl();
        GenModel model = (GenModel)UMLUtil.load((ResourceSet)rset, (URI)URI.createPlatformResourceURI((String)genModelFile.getFullPath().toPortableString(), (boolean)true), (EClass)GenModelPackage.Literals.GEN_MODEL);
        if (model != null && !model.getGenPackages().isEmpty()) {
            result = ((GenPackage)model.getGenPackages().get(0)).getQualifiedPackageInterfaceName();
        }
        return result;
    }
}

