/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.emf.helpers.BundleResourceURIHelper;
import org.eclipse.papyrus.toolsmiths.plugin.builder.GenericEMFModelBuilder;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.checkers.ElementTypesPluginCheckerService;

public class ElementTypesConfigurationBuilder
extends GenericEMFModelBuilder {
    static final String ELEMENT_TYPES_CONFIGURATION_EXTENSION = "elementtypesconfigurations";

    @Override
    protected Collection<Diagnostic> validateResource(Resource resource) {
        if (resource.getURI().fileExtension().equals(ELEMENT_TYPES_CONFIGURATION_EXTENSION)) {
            String bundleName = BundleResourceURIHelper.INSTANCE.getBundleNameFromResource(resource);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(bundleName);
            if (project != null && project.exists() && project.isOpen()) {
                ElementTypesPluginCheckerService.checkElementTypesPlugin((IProject)project, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        return super.validateResource(resource);
    }

    @Override
    protected boolean managedFileExtension(String fileExtension) {
        return ELEMENT_TYPES_CONFIGURATION_EXTENSION.equals(fileExtension);
    }
}

