/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.quickfix;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public final class CommonMarkerResolutionUtils {
    public static Optional<String> getModelName(IMarker marker) {
        return Optional.ofNullable(marker.getAttribute("modelName", null));
    }

    public static Optional<IPath> getModelPath(IMarker marker) {
        return Optional.ofNullable(marker.getAttribute("modelPath", null)).map(Path::new);
    }

    public static <T extends EObject> Optional<T> getModelObject(IMarker marker, Class<T> type, EditingDomain domain) {
        String targetURI = marker.getAttribute("uri", null);
        return Optional.ofNullable(targetURI).map(uri -> URI.createURI((String)uri, (boolean)true)).map(uri -> domain.getResourceSet().getEObject(uri, true)).filter(type::isInstance).map(type::cast);
    }

    public static Optional<EditingDomain> getOpenEditingDomain(IMarker marker) {
        IResource resource = marker.getResource();
        if (!(resource instanceof IFile) || !PlatformUI.isWorkbenchRunning()) {
            return Optional.empty();
        }
        FileEditorInput editorInput = new FileEditorInput((IFile)resource);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        return Stream.of(windows).map(IWorkbenchWindow::getActivePage).flatMap(arg_0 -> CommonMarkerResolutionUtils.lambda$6((IEditorInput)editorInput, arg_0)).map(CommonMarkerResolutionUtils::getEditingDomain).findAny();
    }

    private static EditingDomain getEditingDomain(IEditorReference editorRef) {
        EditingDomain result = null;
        IEditorPart editor = editorRef.getEditor(true);
        if (editor instanceof IEditingDomainProvider) {
            result = ((IEditingDomainProvider)editor).getEditingDomain();
        }
        if (result == null && editor != null) {
            result = (EditingDomain)editor.getAdapter(EditingDomain.class);
        }
        return result;
    }

    private static /* synthetic */ Stream lambda$6(IEditorInput iEditorInput, IWorkbenchPage page) {
        return Stream.of(page.findEditors(iEditorInput, null, 1));
    }
}

