/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.quickfix;

import org.eclipse.core.resources.IMarker;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.MissingDependenciesMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.ResourceMissingFromBinaryBuildMarkerResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class CommonMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    protected final IMarkerResolution[] noResolutions() {
        return NO_RESOLUTIONS;
    }

    protected final IMarkerResolution[] only(IMarkerResolution resolution) {
        return new IMarkerResolution[]{resolution};
    }

    protected final IMarkerResolution[] allOf(IMarkerResolution ... resolutions) {
        return resolutions;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        int problemID = marker.getAttribute("problemId", -1);
        switch (problemID) {
            case 0xFF1000: {
                return ResourceMissingFromBinaryBuildMarkerResolution.forMarker(marker);
            }
            case 0xFF1001: {
                return new IMarkerResolution[]{new MissingDependenciesMarkerResolution()};
            }
        }
        return this.noResolutions();
    }

    public static int getProblemID(IMarker marker) {
        return marker.getAttribute("problemId", -1);
    }

    protected final boolean matchProblemID(IMarker marker, int minInclusive, int maxInclusive) {
        int problemID = CommonMarkerResolutionGenerator.getProblemID(marker);
        return problemID >= minInclusive && problemID <= maxInclusive;
    }

    protected final boolean hasCommonResolutions(IMarker marker) {
        return this.matchProblemID(marker, 0xFF1000, 16715839);
    }

    public boolean hasResolutions(IMarker marker) {
        return this.hasCommonResolutions(marker);
    }
}

