/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.internal.StringMatcher;
import org.eclipse.papyrus.infra.widgets.providers.AbstractTreeFilter;

public class PatternViewerFilter
extends AbstractTreeFilter {
    private static final String END_STRICT_WILDCARE = "$";
    private static final String START_STRICT_WILDCARE = "^";
    private static final String SEMI_COLON = ";";
    private static final String ASTERISK = "*";
    private StringMatcher[] validPatterns = new StringMatcher[]{new StringMatcher("*", true, false)};
    private String currentPattern;
    private boolean strict = false;
    private boolean ignoreCase = true;

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setIgnoreCase(boolean value) {
        if (value != this.ignoreCase) {
            this.ignoreCase = value;
            this.setPatterns();
        }
    }

    public void setPattern(String value) {
        if (!value.equals(this.currentPattern)) {
            this.currentPattern = value;
            this.setPatterns();
        }
    }

    protected void setPatterns() {
        String[] patterns = this.currentPattern.split(SEMI_COLON);
        this.validPatterns = new StringMatcher[patterns.length];
        int i = 0;
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            StringBuilder patternBuilder = new StringBuilder();
            if (!this.strict) {
                if (pattern.startsWith(START_STRICT_WILDCARE)) {
                    patternBuilder.append(pattern.subSequence(1, pattern.length()));
                } else {
                    patternBuilder.append(ASTERISK);
                    patternBuilder.append(pattern.trim());
                }
                if (pattern.endsWith(END_STRICT_WILDCARE)) {
                    patternBuilder.setLength(patternBuilder.length() - 1);
                } else {
                    patternBuilder.append(ASTERISK);
                }
            } else {
                patternBuilder.append(pattern);
            }
            this.validPatterns[i++] = new StringMatcher(patternBuilder.toString(), this.ignoreCase, false);
            ++n2;
        }
        this.clearCache();
    }

    @Override
    public boolean isVisible(Viewer viewer, Object parentElement, Object element) {
        IBaseLabelProvider labelProvider = ((StructuredViewer)viewer).getLabelProvider();
        if (labelProvider instanceof ILabelProvider) {
            StringMatcher[] stringMatcherArray = this.validPatterns;
            int n = this.validPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                StringMatcher pattern = stringMatcherArray[n2];
                if (pattern.match(((ILabelProvider)labelProvider).getText(element))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

