/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.query.ocl.core.internal.evaluator;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.efacet.core.query.IQueryImplementation;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.ParameterValue;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.papyrus.emf.facet.query.ocl.core.util.OclQueryUtil;
import org.eclipse.papyrus.emf.facet.query.ocl.metamodel.oclquery.OclQuery;

public class OclQueryImplementation
implements IQueryImplementation {
    protected OCLExpression<EClassifier> oclExpression;

    public void setValue(Query query, DerivedTypedElement feature, EObject source, List<ParameterValue> parameterValues, Object newValue) throws DerivedTypedElementException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean isCheckResultType() {
        return true;
    }

    public Object getValue(Query query, DerivedTypedElement feature, EObject source, List<ParameterValue> parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        if (!(query instanceof OclQuery)) {
            throw new IllegalArgumentException("The given DerivedTypedElement does not have a OclQuery");
        }
        try {
            return this.executeOclQuery(source, parameterValues, (OclQuery)query);
        }
        catch (Exception e) {
            throw new DerivedTypedElementException((Throwable)e);
        }
    }

    protected Object executeOclQuery(EObject source, List<ParameterValue> parameterValues, OclQuery oclQuery) throws ParserException {
        Object evaluateQuery = null;
        EClassifier context = oclQuery.getContext();
        if (this.oclExpression == null) {
            String stringExpression = oclQuery.getOclExpression();
            this.oclExpression = OclQueryUtil.createOCLExpression(context, stringExpression);
        }
        if (this.oclExpression != null) {
            evaluateQuery = OclQueryUtil.evaluateQuery(context, this.oclExpression, source);
        }
        return evaluateQuery;
    }
}

