/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.palette.dialog;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceSetItemProvider;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PaletteUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPalettePreferences;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.provider.CustomPaletteconfigurationItemProviderAdapterFactory;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.utils.CreatePaletteItemUtil;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.toolsmiths.palette.Messages;
import org.eclipse.papyrus.toolsmiths.palette.PaletteConstants;
import org.eclipse.papyrus.toolsmiths.palette.utils.PaletteUtils;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractPaletteConfigurationWizard
extends Wizard {
    protected static final String STR_DOT = ".";
    protected Resource paletteResource;
    protected Resource elementTypeUIResource;
    protected Resource elementTypeSemResource;
    protected StringBuilder stringBuilder = new StringBuilder();
    protected PapyrusPaletteService.ProviderDescriptor descriptor;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected PaletteConstants.PaletteModelContextEnum paletteContext;
    protected IEditorPart editorPart;
    protected ProviderPriority priority;

    static {
        $SWITCH_TABLE$org$eclipse$papyrus$toolsmiths$palette$PaletteConstants$PaletteModelContextEnum = AbstractPaletteConfigurationWizard.$SWITCH_TABLE$org$eclipse$papyrus$toolsmiths$palette$PaletteConstants$PaletteModelContextEnum();
    }

    public AbstractPaletteConfigurationWizard(IEditorPart part, PapyrusPaletteService.ProviderDescriptor descriptor) {
        this.editorPart = part;
        this.descriptor = descriptor;
        this.paletteContext = PaletteUtils.getPaletteModelContext(descriptor);
        ProviderPriority localPalettePriority = null;
        if (PaletteConstants.PaletteModelContextEnum.New.equals((Object)this.paletteContext)) {
            this.setWindowTitle(Messages.PaletteConfigurationWizard_NewPaletteWizardLabel);
        } else {
            localPalettePriority = PapyrusPalettePreferences.getLocalExtendedPalettePriority((String)descriptor.getContributionID());
            this.setWindowTitle(Messages.PaletteConfigurationWizard_EditPaletteWizardLabel);
        }
        this.initPriority(localPalettePriority);
        this.initializeEditingDomain();
        this.createResources();
    }

    protected void initPriority(ProviderPriority value) {
        this.priority = value != null ? value : ProviderPriority.MEDIUM;
    }

    protected void unloadRessources() {
        if (this.paletteResource != null && this.paletteResource.isLoaded()) {
            this.paletteResource.unload();
        }
        if (this.elementTypeSemResource != null && this.elementTypeSemResource.isLoaded()) {
            this.elementTypeSemResource.unload();
        }
        if (this.elementTypeUIResource != null && this.elementTypeUIResource.isLoaded()) {
            this.elementTypeUIResource.unload();
        }
    }

    public void deleteResource() {
        this.unloadRessources();
        try {
            if (this.paletteResource != null) {
                this.paletteResource.delete(Collections.EMPTY_MAP);
            }
            if (this.elementTypeSemResource != null) {
                this.elementTypeSemResource.delete(Collections.EMPTY_MAP);
            }
            if (this.elementTypeUIResource != null) {
                this.elementTypeUIResource.delete(Collections.EMPTY_MAP);
            }
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void clearStringBuilder() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.trimToSize();
    }

    public boolean performFinish() {
        this.saveResources();
        this.deployModels();
        this.unloadRessources();
        return true;
    }

    protected abstract void deployModels();

    protected abstract void saveResources();

    public boolean performCancel() {
        this.unloadRessources();
        return super.performCancel();
    }

    protected void createResources() {
        this.createPaletteResource();
        this.createElementTypesResources();
    }

    protected void createElementTypesResources() {
        URI elementTypeUIURI = null;
        URI elementTypeSemURI = null;
        File elementTypeUIFile = null;
        File elementTypeSemFile = null;
        switch (this.paletteContext) {
            case New: {
                PaletteConfiguration paletteModel = (PaletteConfiguration)this.paletteResource.getContents().get(0);
                this.clearStringBuilder();
                this.stringBuilder.append(paletteModel.getId());
                this.stringBuilder.append("_UI");
                this.stringBuilder.append(STR_DOT);
                this.stringBuilder.append(PaletteConstants.ELEMENTTYPE_EXTENSION);
                String pathUI = Activator.getInstance().getStateLocation().append(this.stringBuilder.toString()).toString();
                this.clearStringBuilder();
                this.stringBuilder.append(paletteModel.getId());
                this.stringBuilder.append("_Semantic");
                this.stringBuilder.append(STR_DOT);
                this.stringBuilder.append(PaletteConstants.ELEMENTTYPE_EXTENSION);
                String pathSem = Activator.getInstance().getStateLocation().append(this.stringBuilder.toString()).toString();
                elementTypeUIFile = new File(pathUI);
                elementTypeSemFile = new File(pathSem);
                break;
            }
            case Local: {
                this.clearStringBuilder();
                this.stringBuilder.append(((PapyrusPaletteService.LocalExtendedProviderDescriptor)this.descriptor).getContributionID());
                this.stringBuilder.append("_UI");
                this.stringBuilder.append(STR_DOT);
                this.stringBuilder.append(PaletteConstants.ELEMENTTYPE_EXTENSION);
                elementTypeUIFile = Activator.getInstance().getStateLocation().append(this.stringBuilder.toString()).toFile();
                this.clearStringBuilder();
                this.stringBuilder.append(((PapyrusPaletteService.LocalExtendedProviderDescriptor)this.descriptor).getContributionID());
                this.stringBuilder.append("_Semantic");
                this.stringBuilder.append(STR_DOT);
                this.stringBuilder.append(PaletteConstants.ELEMENTTYPE_EXTENSION);
                elementTypeSemFile = Activator.getInstance().getStateLocation().append(this.stringBuilder.toString()).toFile();
                break;
            }
            case Plugin: {
                String path = PapyrusPalettePreferences.getPaletteRedefinition((String)this.descriptor.getContributionID());
                path = path.substring(0, path.length() - PaletteConstants.PALETTECONFIGURATION_EXTENSION.length() - 1);
                this.clearStringBuilder();
                this.stringBuilder.append(path);
                this.stringBuilder.append("_UI");
                this.stringBuilder.append(STR_DOT);
                this.stringBuilder.append(PaletteConstants.ELEMENTTYPE_EXTENSION);
                elementTypeUIFile = Activator.getInstance().getStateLocation().append(this.stringBuilder.toString()).toFile();
                this.clearStringBuilder();
                this.stringBuilder.append(path);
                this.stringBuilder.append("_Semantic");
                this.stringBuilder.append(STR_DOT);
                this.stringBuilder.append(PaletteConstants.ELEMENTTYPE_EXTENSION);
                elementTypeSemFile = Activator.getInstance().getStateLocation().append(this.stringBuilder.toString()).toFile();
                break;
            }
            case Workspace: {
                Object contributions = ((PapyrusPaletteService.LocalProviderDescriptor)this.descriptor).getDescription().getContributions();
                if (!(contributions instanceof String)) break;
                elementTypeUIFile = new File(((String)contributions).replace(STR_DOT + PaletteConstants.PALETTECONFIGURATION_EXTENSION, "_UI." + PaletteConstants.ELEMENTTYPE_EXTENSION));
                elementTypeSemFile = new File(((String)contributions).replace(STR_DOT + PaletteConstants.PALETTECONFIGURATION_EXTENSION, "_Semantic." + PaletteConstants.ELEMENTTYPE_EXTENSION));
                elementTypeUIURI = URI.createPlatformResourceURI((String)elementTypeUIFile.getPath(), (boolean)false);
                elementTypeSemURI = URI.createPlatformResourceURI((String)elementTypeSemFile.getPath(), (boolean)false);
                break;
            }
        }
        if (elementTypeUIFile == null || elementTypeSemURI == null) {
            elementTypeUIURI = URI.createFileURI((String)elementTypeUIFile.getAbsolutePath());
            elementTypeSemURI = URI.createFileURI((String)elementTypeSemFile.getAbsolutePath());
        }
        this.elementTypeSemResource = this.editingDomain.getResourceSet().createResource(elementTypeSemURI);
        this.elementTypeUIResource = this.editingDomain.getResourceSet().createResource(elementTypeUIURI);
        if (!PaletteUtils.notErrorOnFile(elementTypeUIFile) && !PaletteUtils.notErrorOnFile(elementTypeSemFile)) {
            ElementTypeSetConfiguration emptyElementTypeModelSem = this.getEmptyElementTypeModel(this.elementTypeSemResource.getURI().lastSegment().replace(STR_DOT + PaletteConstants.ELEMENTTYPE_EXTENSION, ""));
            ElementTypeSetConfiguration emptyElementTypeModelUI = this.getEmptyElementTypeModel(this.elementTypeUIResource.getURI().lastSegment().replace(STR_DOT + PaletteConstants.ELEMENTTYPE_EXTENSION, ""));
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.append((Command)new AddCommand((EditingDomain)this.editingDomain, this.elementTypeSemResource.getContents(), (Object)emptyElementTypeModelSem));
            compoundCommand.append((Command)new AddCommand((EditingDomain)this.editingDomain, this.elementTypeUIResource.getContents(), (Object)emptyElementTypeModelUI));
            this.editingDomain.getCommandStack().execute((Command)compoundCommand);
        }
        if (this.elementTypeUIResource != null || this.elementTypeSemResource != null) {
            try {
                this.elementTypeSemResource.load(Collections.emptyMap());
                EcoreUtil.resolveAll((Resource)this.elementTypeSemResource);
                this.elementTypeUIResource.load(Collections.emptyMap());
                EcoreUtil.resolveAll((Resource)this.elementTypeUIResource);
                this.elementTypeSemResource.getResourceSet().getLoadOptions().put("resourceElementTypeSemantic", this.elementTypeSemResource);
                this.elementTypeUIResource.getResourceSet().getLoadOptions().put("resourceElementTypeUI", this.elementTypeUIResource);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected ElementTypeSetConfiguration getEmptyElementTypeModel(String initialIdentifer) {
        ElementTypeSetConfiguration elementTypeUI = ElementTypesConfigurationsFactory.eINSTANCE.createElementTypeSetConfiguration();
        elementTypeUI.setIdentifier(initialIdentifer);
        elementTypeUI.setName(initialIdentifer);
        elementTypeUI.setMetamodelNsURI(initialIdentifer);
        return elementTypeUI;
    }

    protected void createPaletteResource() {
        URI fileURI = null;
        switch (this.paletteContext) {
            case New: {
                PaletteConfiguration paletteModel = CreatePaletteItemUtil.createInitialModel();
                this.clearStringBuilder();
                this.stringBuilder.append("NewPalette");
                this.stringBuilder.append(STR_DOT);
                this.stringBuilder.append(PaletteConstants.PALETTECONFIGURATION_EXTENSION);
                String path = Activator.getInstance().getStateLocation().append(this.stringBuilder.toString()).toString();
                fileURI = URI.createFileURI((String)path);
                this.paletteResource = this.editingDomain.getResourceSet().createResource(fileURI);
                AddCommand addCommand = new AddCommand((EditingDomain)this.editingDomain, this.paletteResource.getContents(), (Object)paletteModel);
                this.editingDomain.getCommandStack().execute((Command)addCommand);
                break;
            }
            case Local: {
                this.clearStringBuilder();
                this.stringBuilder.append(((PapyrusPaletteService.LocalExtendedProviderDescriptor)this.descriptor).getContributionID());
                this.stringBuilder.append(STR_DOT);
                this.stringBuilder.append(PaletteConstants.PALETTECONFIGURATION_EXTENSION);
                File file = Activator.getInstance().getStateLocation().append(this.stringBuilder.toString()).toFile();
                if (!PaletteUtils.notErrorOnFile(file)) break;
                fileURI = URI.createFileURI((String)file.getAbsolutePath());
                this.paletteResource = this.editingDomain.getResourceSet().createResource(fileURI);
                break;
            }
            case Plugin: {
                fileURI = PaletteUtil.getRedefinitionFileURI((String)this.descriptor.getContributionID());
                if (fileURI == null) break;
                this.paletteResource = this.editingDomain.getResourceSet().createResource(fileURI);
                break;
            }
            case Workspace: {
                Object contributions = ((PapyrusPaletteService.LocalProviderDescriptor)this.descriptor).getDescription().getContributions();
                if (!(contributions instanceof String)) break;
                fileURI = URI.createPlatformResourceURI((String)((String)contributions), (boolean)false);
                this.paletteResource = this.editingDomain.getResourceSet().createResource(fileURI);
                break;
            }
        }
        if (this.paletteResource != null) {
            try {
                this.paletteResource.load(Collections.emptyMap());
                this.paletteResource.getResourceSet().getLoadOptions().put("resourcePalette", this.paletteResource);
                EcoreUtil.resolveAll((Resource)this.paletteResource);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory(){

            public Adapter createResourceSetAdapter() {
                return new ResourceSetItemProvider((AdapterFactory)this){

                    public Collection<?> getChildren(Object object) {
                        ResourceSet resourceSet = (ResourceSet)object;
                        if (!resourceSet.getResources().isEmpty() && ((Resource)resourceSet.getResources().get(0)).getContents().get(0) instanceof PaletteConfiguration) {
                            return ((PaletteConfiguration)((Resource)resourceSet.getResources().get(0)).getContents().get(0)).getDrawerConfigurations();
                        }
                        return Collections.emptyList();
                    }
                };
            }
        });
        this.adapterFactory.addAdapterFactory((AdapterFactory)new CustomPaletteconfigurationItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.editingDomain = new TransactionalEditingDomainImpl((AdapterFactory)this.adapterFactory);
    }
}

