/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.AutomaticNotationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CCombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CInteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.BoundForEditPart;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;

public class ResizeOperandEditPolicy
extends GraphicalEditPolicy
implements AutomaticNotationEditPolicy,
NotificationListener {
    public void activate() {
        super.activate();
        this.getDiagramEventBroker().addNotificationListener((EObject)this.getHost().getModel(), (NotificationListener)this);
    }

    public void deactivate() {
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.getHost().getModel(), (NotificationListener)this);
        super.activate();
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public Command getCommand(Request request) {
        CreateViewAndElementRequest req;
        CreateViewAndElementRequest.ViewAndElementDescriptor descriptor;
        IElementType elementType;
        if (request instanceof CreateViewAndElementRequest && ElementUtil.isTypeOf((IElementType)(elementType = (IElementType)(descriptor = (req = (CreateViewAndElementRequest)request).getViewAndElementDescriptor()).getElementAdapter().getAdapter(IElementType.class)), (IElementType)UMLDIElementTypes.INTERACTION_OPERAND_SHAPE)) {
            Node combinedFragmentNode = (Node)((GraphicalEditPart)this.getHost().getParent()).getNotationView();
            int height = ((Bounds)combinedFragmentNode.getLayoutConstraint()).getHeight();
            if (this.getHost().getChildren().size() > 0) {
                int newHeight = height + CInteractionOperandEditPart.DEFAULT_HEIGHT;
                return new ICommandProxy((ICommand)new SetBoundsCommand(this.getEditingDomain(), "set dimension", (IAdaptable)new EObjectAdapter((EObject)combinedFragmentNode), new Dimension(BoundForEditPart.getWidthFromView(combinedFragmentNode), newHeight)));
            }
        }
        if ("resize children".equals(request.getType())) {
            CompositeCommand compositeCommand = new CompositeCommand("Resize Operands");
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            List editParts = changeBoundsRequest.getEditParts();
            if (editParts.size() > 1) {
                return null;
            }
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            Object currentEditPart = editParts.get(0);
            if (changeBoundsRequest.getMoveDelta().y == 0) {
                if (currentEditPart instanceof GraphicalEditPart) {
                    if (this.istheFirstDisplayedOperand((GraphicalEditPart)currentEditPart)) {
                        compositeCommand.add((IUndoableOperation)new SetBoundsCommand(editingDomain, "Set Position of the first operand", (IAdaptable)new EObjectAdapter((EObject)((GraphicalEditPart)currentEditPart).getNotationView()), new Point(0, 0)));
                    }
                    this.updateCurrentChildSize(compositeCommand, changeBoundsRequest, editingDomain, currentEditPart);
                    if (this.istheLastDisplayedOperand((GraphicalEditPart)currentEditPart)) {
                        compositeCommand.add((IUndoableOperation)this.getResizeCompartmentCommand(changeBoundsRequest));
                    } else {
                        View nextView = this.getNextView((GraphicalEditPart)currentEditPart);
                        Dimension size = new Dimension(BoundForEditPart.getWidthFromView((Node)nextView), BoundForEditPart.getHeightFromView((Node)nextView));
                        size.expand(changeBoundsRequest.getSizeDelta().width * -1, changeBoundsRequest.getSizeDelta().height * -1);
                        Point locationNext = new Point(((Bounds)((Node)nextView).getLayoutConstraint()).getX(), ((Bounds)((Node)nextView).getLayoutConstraint()).getY());
                        locationNext.y += changeBoundsRequest.getSizeDelta().height;
                        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(editingDomain, "Resize Operands", (IAdaptable)new EObjectAdapter((EObject)nextView), new Rectangle(locationNext, size));
                        compositeCommand.add((IUndoableOperation)setBoundsCommand);
                    }
                }
            } else if (changeBoundsRequest.getMoveDelta().y != 0) {
                if (currentEditPart instanceof GraphicalEditPart) {
                    this.updateCurrentChildSize(compositeCommand, changeBoundsRequest, editingDomain, currentEditPart);
                }
                if (this.istheFirstDisplayedOperand((GraphicalEditPart)currentEditPart)) {
                    compositeCommand.add((IUndoableOperation)this.getMoveCompartmentCommand(changeBoundsRequest));
                    compositeCommand.add((IUndoableOperation)new SetBoundsCommand(editingDomain, "Resize Operands", (IAdaptable)new EObjectAdapter((EObject)((GraphicalEditPart)currentEditPart).getNotationView()), new Point(0, 0)));
                    int i = 1;
                    while (i < this.getHost().getChildren().size()) {
                        GraphicalEditPart graphicalEditPart = (GraphicalEditPart)this.getHost().getChildren().get(i);
                        int y = ((Bounds)((Node)graphicalEditPart.getNotationView()).getLayoutConstraint()).getY() - changeBoundsRequest.getMoveDelta().y;
                        compositeCommand.add((IUndoableOperation)new SetBoundsCommand(editingDomain, "Resize Operands", (IAdaptable)new EObjectAdapter((EObject)((Node)graphicalEditPart.getNotationView())), new Point(0, y)));
                        ++i;
                    }
                } else {
                    View previousView = this.getPreviousView((GraphicalEditPart)currentEditPart);
                    Dimension size = new Dimension(BoundForEditPart.getWidthFromView((Node)previousView), BoundForEditPart.getHeightFromView((Node)previousView));
                    size.expand(changeBoundsRequest.getSizeDelta().width * -1, changeBoundsRequest.getSizeDelta().height * -1);
                    SetBoundsCommand setBoundsCommand = new SetBoundsCommand(editingDomain, "Resize Operands", (IAdaptable)new EObjectAdapter((EObject)previousView), size);
                    compositeCommand.add((IUndoableOperation)setBoundsCommand);
                }
            }
            return new ICommandProxy((ICommand)compositeCommand);
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return editingDomain;
    }

    private void updateCurrentChildSize(CompositeCommand compositeCommand, ChangeBoundsRequest changeBoundsRequest, TransactionalEditingDomain editingDomain, Object currentEditPart) {
        Node shapeView = (Node)((GraphicalEditPart)currentEditPart).getNotationView();
        Dimension size = new Dimension(BoundForEditPart.getWidthFromView(shapeView), BoundForEditPart.getHeightFromView(shapeView));
        size.expand(changeBoundsRequest.getSizeDelta().width, changeBoundsRequest.getSizeDelta().height);
        Point location = new Point(0, ((Bounds)shapeView.getLayoutConstraint()).getY() + changeBoundsRequest.getMoveDelta().y);
        Rectangle rect = new Rectangle(location, size);
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(editingDomain, "Resize Operands", (IAdaptable)new EObjectAdapter((EObject)shapeView), rect);
        compositeCommand.add((IUndoableOperation)setBoundsCommand);
    }

    protected boolean istheLastDisplayedOperand(GraphicalEditPart operandEditPart) {
        int listSize;
        View operandView = operandEditPart.getNotationView();
        int index = ((View)operandView.eContainer()).getChildren().indexOf((Object)operandView);
        return index == (listSize = ((View)operandView.eContainer()).getChildren().size()) - 1;
    }

    protected boolean istheFirstDisplayedOperand(GraphicalEditPart operandEditPart) {
        View operandView = operandEditPart.getNotationView();
        int index = ((View)operandView.eContainer()).getChildren().indexOf((Object)operandView);
        return index == 0;
    }

    protected View getNextView(GraphicalEditPart operandEditPart) {
        int listSize;
        View operandView = operandEditPart.getNotationView();
        int index = ((View)operandView.eContainer()).getChildren().indexOf((Object)operandView);
        if (index + 1 < (listSize = ((View)operandView.eContainer()).getChildren().size())) {
            return (View)((View)operandView.eContainer()).getChildren().get(index + 1);
        }
        return null;
    }

    protected View getPreviousView(GraphicalEditPart operandEditPart) {
        View operandView = operandEditPart.getNotationView();
        int index = ((View)operandView.eContainer()).getChildren().indexOf((Object)operandView);
        if (index - 1 >= 0) {
            return (View)((View)operandView.eContainer()).getChildren().get(index - 1);
        }
        return null;
    }

    protected ICommand getResizeCompartmentCommand(ChangeBoundsRequest changeBoundsRequest) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        Node combinedFragmentNode = (Node)((GraphicalEditPart)this.getHost().getParent()).getNotationView();
        int combinedFragmentHeight = BoundForEditPart.getHeightFromView(combinedFragmentNode);
        int newHeight = this.getComputedCombinedFragmentHeight() + changeBoundsRequest.getSizeDelta().height;
        if (newHeight != combinedFragmentHeight) {
            return new SetBoundsCommand(editingDomain, "Resize Operands", (IAdaptable)new EObjectAdapter((EObject)combinedFragmentNode), new Dimension(BoundForEditPart.getWidthFromView(combinedFragmentNode), newHeight));
        }
        return IdentityCommand.INSTANCE;
    }

    protected ICommand getMoveCompartmentCommand(ChangeBoundsRequest changeBoundsRequest) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        Node combinedFragmentNode = (Node)((GraphicalEditPart)this.getHost().getParent()).getNotationView();
        int newHeight = this.getComputedCombinedFragmentHeight() + changeBoundsRequest.getSizeDelta().height;
        int combinedFragmentHeight = BoundForEditPart.getHeightFromView(combinedFragmentNode);
        Bounds combinedFragmentBound = BoundForEditPart.getBounds(combinedFragmentNode);
        int newY = combinedFragmentBound.getY() + changeBoundsRequest.getMoveDelta().y;
        if (newHeight != combinedFragmentHeight) {
            return new SetBoundsCommand(editingDomain, "Resize Operands", (IAdaptable)new EObjectAdapter((EObject)combinedFragmentNode), new Rectangle(combinedFragmentBound.getX(), newY, BoundForEditPart.getWidthFromView(combinedFragmentNode), newHeight));
        }
        return IdentityCommand.INSTANCE;
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 4 && notification.getNotifier().equals(this.getHost().getModel())) {
            int combinedFragmentHeight;
            Node combinedFragmentNode = (Node)((GraphicalEditPart)this.getHost().getParent()).getNotationView();
            int newHeight = this.getComputedCombinedFragmentHeight();
            if (newHeight != (combinedFragmentHeight = BoundForEditPart.getHeightFromView(combinedFragmentNode))) {
                this.execute((ICommand)new SetBoundsCommand(this.getEditingDomain(), "Resize Operands", (IAdaptable)new EObjectAdapter((EObject)combinedFragmentNode), new Dimension(BoundForEditPart.getWidthFromView(combinedFragmentNode), newHeight)));
            }
        }
    }

    protected int getComputedCombinedFragmentHeight() {
        double childrenCumulativeHeight = this.getOperandCumulativeHeight();
        int newHeight = (int)childrenCumulativeHeight + CCombinedFragmentEditPart.DEFAULT_HEIGHT - CInteractionOperandEditPart.DEFAULT_HEIGHT;
        if (newHeight < CCombinedFragmentEditPart.DEFAULT_HEIGHT) {
            newHeight = CCombinedFragmentEditPart.DEFAULT_HEIGHT;
        }
        return newHeight;
    }

    protected double getOperandCumulativeHeight() {
        Node compartmentNode = (Node)((GraphicalEditPart)this.getHost()).getNotationView();
        double childrenCumulativeHeight = 0.0;
        for (Node childView : compartmentNode.getChildren()) {
            childrenCumulativeHeight += (double)BoundForEditPart.getHeightFromView(childView);
        }
        return childrenCumulativeHeight;
    }
}

