/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.DestructionEventFigure;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;

public class OLDLifeLineLayoutEditPolicy
extends DefaultCreationEditPolicy {
    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        CreateViewAndElementRequest.ViewAndElementDescriptor descriptor = request.getViewAndElementDescriptor();
        if (UMLDIElementTypes.ACTION_EXECUTION_SPECIFICATION_SHAPE.getSemanticHint().equals(descriptor.getSemanticHint())) {
            CreateElementRequestAdapter requestAdapter = request.getViewAndElementDescriptor().getCreateElementRequestAdapter();
            CreateElementRequest createElementRequest = (CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class);
            View view = (View)this.getHost().getModel();
            EObject hostElement = ViewUtil.resolveSemanticElement((View)view);
            createElementRequest.setContainer(hostElement.eContainer());
            createElementRequest.setParameter("Element Covers this one", (Object)hostElement);
        }
        return super.getCreateElementAndViewCommand(request);
    }

    protected ICommand getSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor) {
        SetBoundsCommand setBoundsCommand = null;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (descriptor.getSemanticHint().equals(UMLDIElementTypes.DESTRUCTION_OCCURRENCE_SPECIFICATION_SHAPE.getSemanticHint())) {
            Point parentLoc = this.getHostFigure().getBounds().getLocation().getCopy();
            Map params = request.getExtendedData();
            Point realLocation = (Point)params.get("initialMouseLocationForCreation");
            Point realWantedLocation = realLocation != null ? realLocation.getCopy() : request.getLocation().getCopy();
            Point requestedLocation = realWantedLocation.getCopy();
            requestedLocation.translate(parentLoc.negate());
            DestructionEventFigure destructionEventFigure = new DestructionEventFigure();
            requestedLocation.y -= destructionEventFigure.getDefaultSize().height / 2;
            setBoundsCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)descriptor, requestedLocation);
        } else {
            super.getSetBoundsCommand(request, descriptor);
        }
        return setBoundsCommand;
    }

    protected IFigure getHostFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }
}

