/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.menu;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.uml.nattable.manager.axis.UMLStereotypePropertyAxisManager;
import org.eclipse.papyrus.uml.nattable.menu.AbstractCreateStereotypePropertyMenuFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.uml2.uml.Property;

public class CreateColumnStereotypePropertyMenuFactory
extends AbstractCreateStereotypePropertyMenuFactory {
    public static final String MENU_LABEL = "Select Stereotype Properties Columns";
    private static final String ICON_PATH = "/icons/stereotypePropertyColumn.gif";

    public CreateColumnStereotypePropertyMenuFactory() {
        super(MENU_LABEL, ICON_PATH);
    }

    @Override
    protected void fillMenu(Menu menu, INattableModelManager tableManager, Collection<String> initialSelection, Map<String, Property> nameToPropertyMap) {
    }

    @Override
    protected void fillMenu(Menu menu, Collection<String> initialSelection, final Map<String, Property> nameToPropertyMap) {
        for (final String current : nameToPropertyMap.keySet()) {
            final MenuItem menuItem = new MenuItem(menu, 32);
            menuItem.setText(current);
            if (initialSelection.contains(current)) {
                menuItem.setSelection(true);
            }
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean toAdd = menuItem.getSelection();
                    if (toAdd) {
                        Set toAdds = Collections.singleton(nameToPropertyMap.get(current));
                        CreateColumnStereotypePropertyMenuFactory.this.getTableManager().addColumns(toAdds);
                    } else {
                        Set toRemove = Collections.singleton(nameToPropertyMap.get(current));
                        CreateColumnStereotypePropertyMenuFactory.this.getTableManager().removeColumns(toRemove);
                    }
                }
            });
        }
        boolean enabled = menu.getItemCount() != 0;
        menu.setEnabled(enabled);
    }

    @Override
    protected UMLStereotypePropertyAxisManager getStereotypeAxisManager(INattableModelManager tableManager) {
        return (UMLStereotypePropertyAxisManager)((Object)tableManager.getColumnAxisManager().getAdapter(UMLStereotypePropertyAxisManager.class));
    }

    @Override
    protected Collection<?> getAxisElementList(INattableModelManager tableManager) {
        return tableManager.getColumnElementsList();
    }
}

