/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.edit.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class PropertyPartFromTypeCreateCommand
extends EditElementCommand {
    protected Type type = null;
    protected StructuredClassifier owner = null;
    protected Property newElement = null;
    protected SemanticAdapter semanticAdapter;

    public PropertyPartFromTypeCreateCommand(CreateElementRequest req, StructuredClassifier owner, Type type, SemanticAdapter semanticAdapter) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
        this.owner = owner;
        this.type = type;
        this.semanticAdapter = semanticAdapter;
        this.setResult(CommandResult.newOKCommandResult((Object)semanticAdapter));
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        if (container != null) {
            return container;
        }
        return this.owner;
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.newElement = UMLFactory.eINSTANCE.createProperty();
        StructuredClassifier owner = (StructuredClassifier)this.getElementToEdit();
        owner.getOwnedAttributes().add((Object)this.newElement);
        this.newElement.setType(this.type);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)this.newElement);
        this.semanticAdapter.setElement((Object)this.newElement);
        String typeName = this.type.getName();
        String elementName = typeName.length() == 0 ? "none" : String.valueOf(typeName.substring(0, 1).toLowerCase()) + typeName.substring(1);
        String typeLabel = "";
        String elementLabel = "";
        if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)this.type) && UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)this.type) != null) {
            typeLabel = UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)this.type);
            elementLabel = typeLabel.length() == 0 ? "none" : String.valueOf(typeLabel.substring(0, 1).toLowerCase()) + typeLabel.substring(1);
        }
        int i = 0;
        String initialElementName = elementName;
        String initialElementLabel = elementLabel;
        while (owner.getAttribute(elementName, null) != null) {
            elementName = String.valueOf(initialElementName) + String.valueOf(i);
            if (!elementLabel.isEmpty()) {
                elementLabel = String.valueOf(initialElementLabel) + String.valueOf(i);
            }
            ++i;
        }
        this.newElement.setName(elementName);
        if (!elementName.isEmpty()) {
            UMLLabelInternationalization.getInstance().setLabel((NamedElement)this.newElement, elementName, null);
        }
        return CommandResult.newOKCommandResult((Object)this.semanticAdapter);
    }
}

