/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.registry.TeamDecoratorDescription;
import org.eclipse.team.internal.ui.registry.TeamDecoratorManager;
import org.eclipse.team.ui.mapping.ITeamStateChangeEvent;
import org.eclipse.team.ui.mapping.ITeamStateChangeListener;
import org.eclipse.team.ui.mapping.ITeamStateProvider;
import org.eclipse.ui.PlatformUI;

public abstract class TeamStateProvider
implements ITeamStateProvider {
    private ListenerList<ITeamStateChangeListener> listeners = new ListenerList(1);

    @Override
    public boolean isDecorationEnabled(Object element) {
        ResourceMapping mapping = Utils.getResourceMapping(element);
        if (mapping != null) {
            IProject[] projects = mapping.getProjects();
            return this.internalIsDecorationEnabled(projects);
        }
        return false;
    }

    @Override
    public int getDecoratedStateMask(Object element) {
        ResourceMapping mapping = Utils.getResourceMapping(element);
        if (mapping != null) {
            IProject[] projects = mapping.getProjects();
            return this.internalGetDecoratedStateMask(projects);
        }
        return 0;
    }

    @Override
    public void addDecoratedStateChangeListener(ITeamStateChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeDecoratedStateChangeListener(ITeamStateChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected final void fireStateChangeEvent(final ITeamStateChangeEvent event) {
        Object[] allListeners = this.listeners.getListeners();
        int i = 0;
        while (i < allListeners.length) {
            final ITeamStateChangeListener listener = (ITeamStateChangeListener)allListeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.teamStateChanged(event);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++i;
        }
    }

    private int internalGetDecoratedStateMask(IProject[] projects) {
        int stateMask = 0;
        String[] providerIds = this.getProviderIds(projects);
        int i = 0;
        while (i < providerIds.length) {
            String providerId = providerIds[i];
            stateMask |= this.internalGetDecoratedStateMask(providerId);
            ++i;
        }
        return stateMask;
    }

    private int internalGetDecoratedStateMask(String providerId) {
        TeamDecoratorDescription decoratorDescription = TeamDecoratorManager.getInstance().getDecoratorDescription(providerId);
        if (decoratorDescription != null) {
            return decoratorDescription.getDecoratedDirectionFlags();
        }
        return 0;
    }

    private String[] getProviderIds(IProject[] projects) {
        HashSet<String> providerIds = new HashSet<String>();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            String id = this.getProviderId(project);
            if (id != null) {
                providerIds.add(id);
            }
            ++i;
        }
        return providerIds.toArray(new String[providerIds.size()]);
    }

    private String getProviderId(IProject project) {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        if (provider != null) {
            return provider.getID();
        }
        return null;
    }

    private boolean internalIsDecorationEnabled(IProject[] projects) {
        String[] providerIds = this.getProviderIds(projects);
        int i = 0;
        while (i < providerIds.length) {
            String providerId = providerIds[i];
            if (this.internalIsDecorationEnabled(providerId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean internalIsDecorationEnabled(String providerId) {
        String decoratorId = this.getDecoratorId(providerId);
        if (decoratorId != null) {
            return PlatformUI.getWorkbench().getDecoratorManager().getEnabled(decoratorId);
        }
        return false;
    }

    private String getDecoratorId(String providerId) {
        TeamDecoratorDescription decoratorDescription = TeamDecoratorManager.getInstance().getDecoratorDescription(providerId);
        if (decoratorDescription != null) {
            return decoratorDescription.getDecoratorId();
        }
        return null;
    }
}

