/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.advice;

import java.util.Collection;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.sequence.util.DurationLinkUtil;

public abstract class AbstractDurationLinkAdvice
extends AbstractEditHelperAdvice {
    private EClass durationElementType;
    private EReference eventsReference;
    private String durationLinkType;

    protected AbstractDurationLinkAdvice(EClass durationElementType, EReference eventsReference, String durationLinkType) {
        this.durationElementType = durationElementType;
        this.eventsReference = eventsReference;
        this.durationLinkType = durationLinkType;
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        if (request.getFeature() == this.eventsReference && this.durationElementType.isInstance((Object)request.getElementToEdit())) {
            Collection usages = EMFHelper.getUsages((EObject)request.getElementToEdit());
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)request.getElementToEdit());
            if (provider == null) {
                return null;
            }
            CompositeCommand deletions = new CompositeCommand("Delete inconsistent DurationLink views");
            for (EStructuralFeature.Setting usage : usages) {
                Connector connector;
                if (!(usage.getEObject() instanceof Connector) || usage.getEStructuralFeature() != NotationPackage.Literals.VIEW__ELEMENT || !this.durationLinkType.equals((connector = (Connector)usage.getEObject()).getType()) || connector.getDiagram() == null || !"PapyrusUMLSequenceDiagram".equals(connector.getDiagram().getType()) || DurationLinkUtil.isConsistent(connector, request)) continue;
                DestroyElementRequest destroyRequest = new DestroyElementRequest(request.getEditingDomain(), (EObject)connector, false);
                ICommand deleteCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
                deletions.add((IUndoableOperation)deleteCommand);
            }
            return deletions.isEmpty() ? null : deletions.reduce();
        }
        return super.getAfterSetCommand(request);
    }
}

