/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.symbol;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolMapper;
import org.eclipse.xtext.ide.server.symbol.IDocumentSymbolService;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
@Beta
public class HierarchicalDocumentSymbolService
implements IDocumentSymbolService {
    @Inject
    private DocumentSymbolMapper symbolMapper;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public static boolean isValid(DocumentSymbol symbol) {
        return symbol != null && !IterableExtensions.exists((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)DocumentSymbol.class.getDeclaredFields())), it -> {
            Functions.Function1 _function = it_1 -> {
                Class<? extends Annotation> _annotationType = it_1.annotationType();
                return _annotationType == NonNull.class;
            };
            return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)it.getAnnotations())), (Functions.Function1)_function);
        }), it -> {
            Field _xblockexpression = null;
            it.setAccessible(true);
            _xblockexpression = it;
            return _xblockexpression;
        }), it -> {
            try {
                return it.get(symbol);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }), it -> it == null);
    }

    @Override
    public List<Either<SymbolInformation, DocumentSymbol>> getSymbols(Document document, XtextResource resource, DocumentSymbolParams params, CancelIndicator cancelIndicator) {
        return this.getSymbols(resource, cancelIndicator);
    }

    public List<Either<SymbolInformation, DocumentSymbol>> getSymbols(XtextResource resource, CancelIndicator cancelIndicator) {
        HashMap allSymbols = CollectionLiterals.newHashMap();
        ArrayList rootSymbols = CollectionLiterals.newArrayList();
        Iterator<Object> itr = this.getAllContents((Resource)resource);
        while (itr.hasNext()) {
            EObject parent;
            EObject object;
            DocumentSymbol symbol;
            boolean _isValid;
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            Optional<EObject> next = this.toEObject(itr.next());
            boolean _isPresent = next.isPresent();
            if (!_isPresent || !(_isValid = HierarchicalDocumentSymbolService.isValid(symbol = this.symbolMapper.toDocumentSymbol(object = (EObject)next.get())))) continue;
            allSymbols.put(object, symbol);
            if (parent == null) {
                rootSymbols.add(symbol);
                continue;
            }
            DocumentSymbol parentSymbol = (DocumentSymbol)allSymbols.get(parent);
            for (parent = object.eContainer(); parentSymbol == null && parent != null; parent = parent.eContainer()) {
                parentSymbol = (DocumentSymbol)allSymbols.get(parent);
            }
            if (parentSymbol == null) {
                rootSymbols.add(symbol);
                continue;
            }
            parentSymbol.getChildren().add(symbol);
        }
        Functions.Function1 _function = it -> Either.forRight((Object)it);
        return ListExtensions.map((List)rootSymbols, (Functions.Function1)_function);
    }

    protected Iterator<Object> getAllContents(Resource resource) {
        return EcoreUtil.getAllProperContents((Resource)resource, (boolean)true);
    }

    protected Optional<EObject> toEObject(Object object) {
        if (object instanceof EObject) {
            return Optional.of((Object)((EObject)object));
        }
        return Optional.absent();
    }
}

