/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.scheduling.control;

import org.eclipse.papyrus.moka.kernel.scheduling.control.IExecutionLoop;
import org.eclipse.papyrus.moka.kernel.scheduling.control.IScheduler;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.ITaskExecution;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.ITaskExecutionCondition;

public class ExecutionLoop
implements IExecutionLoop {
    protected IScheduler scheduler;

    @Override
    public void init(ITaskExecution origin, IScheduler sched) {
        this.scheduler = sched;
        this.include(origin);
    }

    @Override
    public boolean include(ITaskExecution task) {
        boolean included = false;
        if (task != null) {
            this.scheduler.schedule(task);
            included = true;
        }
        return included;
    }

    @Override
    public void run() {
        while (this.scheduler.hasNext()) {
            this.runNext();
        }
    }

    @Override
    public boolean step() {
        return this.runNext();
    }

    protected boolean runNext() {
        ITaskExecution task = this.scheduler.next();
        if (task != null && task.canExecute()) {
            task.execute();
            return true;
        }
        return false;
    }

    @Override
    public void terminate() {
        this.scheduler.terminate();
    }

    @Override
    public void terminate(ITaskExecutionCondition condition) {
        this.scheduler.terminate(condition);
    }

    @Override
    public void suspend() {
        this.scheduler.suspend();
    }

    @Override
    public void suspend(ITaskExecutionCondition condition) {
        this.scheduler.suspend(condition);
    }

    @Override
    public void resume() {
        this.scheduler.resume();
    }

    @Override
    public void resume(ITaskExecutionCondition condition) {
        this.scheduler.resume(condition);
    }
}

