/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.generatorconfiguration.properties.internal.factories;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.EMFEditUIPropertyEditorFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.DefaultDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.DefaultDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Document;
import org.eclipse.papyrus.model2doc.emf.structure2document.generator.IStructure2DocumentGenerator;
import org.eclipse.papyrus.model2doc.emf.structure2document.generator.Structure2DocumentRegistry;
import org.eclipse.swt.widgets.Composite;

public class DocumentGeneratorIdPropertyEditor
extends EMFEditUIPropertyEditorFactory {
    private static final URI SELF_URI = URI.createURI((String)"editor://generatorconfiguration/AbstractDocumentGeneratorConfiguration/documentGeneratorId/");

    public DocumentGeneratorIdPropertyEditor() {
        super(SELF_URI);
    }

    public CellEditor createEditor(Object object, IItemPropertyDescriptor propertyDescriptor, Composite composite) {
        List generators = Collections.emptyList();
        if (object instanceof DefaultDocumentGeneratorConfiguration) {
            Document document = null;
            EObject parent = ((DefaultDocumentGeneratorConfiguration)object).eContainer();
            if (parent instanceof Document) {
                document = (Document)parent;
            }
            generators = Structure2DocumentRegistry.INSTANCE.getAvailableGenerators(document);
        } else if (object instanceof DefaultDocumentStructureGeneratorConfiguration) {
            generators = Structure2DocumentRegistry.INSTANCE.getAllRegistredGenerators();
        }
        return new DocumentGeneratorExtendedComboBoxCellEditor(composite, generators, (ILabelProvider)new DocumentGeneratorIdLabelProvider());
    }

    public IItemLabelProvider createLabelProvider(Object object, IItemPropertyDescriptor propertyDescriptor) {
        return new DocumentGeneratorLabelProvider();
    }

    private class DocumentGeneratorExtendedComboBoxCellEditor
    extends ExtendedComboBoxCellEditor {
        public DocumentGeneratorExtendedComboBoxCellEditor(Composite composite, List<?> list, ILabelProvider labelProvider) {
            super(composite, list, labelProvider);
        }

        public void doSetValue(Object value) {
            IStructure2DocumentGenerator generator;
            if (value instanceof String && (generator = Structure2DocumentRegistry.INSTANCE.getGenerator((String)value)) != null) {
                super.doSetValue((Object)generator.getEditorLabel());
            }
            if (value == null) {
                super.doSetValue((Object)"");
                return;
            }
            super.doSetValue(value);
        }

        public Object doGetValue() {
            Object getValue = super.doGetValue();
            if (getValue instanceof IStructure2DocumentGenerator) {
                getValue = ((IStructure2DocumentGenerator)getValue).getGeneratorId();
            }
            return getValue;
        }
    }

    private class DocumentGeneratorIdLabelProvider
    extends LabelProvider {
        private DocumentGeneratorIdLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null) {
                return "";
            }
            if (element instanceof IStructure2DocumentGenerator) {
                return ((IStructure2DocumentGenerator)element).getEditorLabel();
            }
            return super.getText(element);
        }
    }

    private static class DocumentGeneratorLabelProvider
    implements IItemLabelProvider {
        private DocumentGeneratorLabelProvider() {
        }

        public String getText(Object object) {
            if (object instanceof String) {
                IStructure2DocumentGenerator generator = Structure2DocumentRegistry.INSTANCE.getGenerator((String)object);
                if (generator != null) {
                    return generator.getEditorLabel();
                }
                return (String)object;
            }
            return "";
        }

        public Object getImage(Object object) {
            return null;
        }
    }
}

