/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rsa.wizard.pages;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.papyrus.interoperability.rsa.Activator;
import org.eclipse.papyrus.interoperability.rsa.constants.TransformationWizardConstants;
import org.eclipse.papyrus.interoperability.rsa.messages.Messages;
import org.eclipse.papyrus.interoperability.rsa.utils.CreateProject;
import org.eclipse.papyrus.interoperability.rsa.wizard.pages.DialogData;
import org.eclipse.papyrus.interoperability.rsa.wizard.pages.ImportTreeComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;

public class DialogDataTreeComposite
extends ImportTreeComposite {
    protected DialogData dialogData;
    protected String systemDialogFiles;
    protected SelectionListener selectionButtonListener;
    protected SelectionListener systemSelectionListener;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    protected Button systemSelectionButton;

    public DialogDataTreeComposite(Composite parent, int style, DialogData dialogData) {
        super(parent, style, dialogData.getExtensions(), dialogData.getExtensionsNames());
        this.dialogData = dialogData;
        ISelection treeSelection = this.treeViewer.getSelection();
        if (treeSelection instanceof StructuredSelection) {
            this.setSelectedFiles(((StructuredSelection)treeSelection).toArray());
            this.dialogData.setSelectedFiles(this.getSelectedFiles());
        }
    }

    @Override
    protected void fireTreeSelectionEvent(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.selectedFiles.clear();
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            this.setSelectedFiles(sSelection.toArray());
            if (this.dialogData != null) {
                this.dialogData.setSelectedFiles(this.selectedFiles);
            }
        }
    }

    @Override
    protected void createSelectionButtons(Composite parent) {
        this.selectionButtonsComposite = new Composite(parent, 0);
        this.selectionButtonsComposite.setLayout((Layout)new GridLayout());
        this.systemSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogDataTreeComposite.this.fireSystemBrowseEvent(event);
            }
        };
        this.systemSelectionButton = new Button(this.selectionButtonsComposite, 8);
        this.systemSelectionButton.setText(Messages.Button_FileSystemSelection);
        this.systemSelectionButton.addSelectionListener(this.systemSelectionListener);
        this.systemSelectionButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.selectionButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogDataTreeComposite.this.fireButtonSelectionEvent(event);
            }
        };
        this.selectAllButton = new Button(this.selectionButtonsComposite, 8);
        this.selectAllButton.setText(Messages.Button_SelectAll);
        this.selectAllButton.setData((Object)true);
        this.selectAllButton.addSelectionListener(this.selectionButtonListener);
        this.selectAllButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.deselectAllButton = new Button(this.selectionButtonsComposite, 8);
        this.deselectAllButton.setText(Messages.Button_DeselectAll);
        this.deselectAllButton.setData((Object)false);
        this.deselectAllButton.addSelectionListener(this.selectionButtonListener);
        this.deselectAllButton.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected void fireButtonSelectionEvent(SelectionEvent event) {
        if (((Boolean)((Button)event.widget).getData()).booleanValue()) {
            this.treeViewer.getTree().selectAll();
            this.getNestedFiles(((IStructuredSelection)this.treeViewer.getSelection()).toArray());
            if (this.dialogData != null) {
                this.dialogData.setSelectedFiles(this.selectedFiles);
            }
        } else {
            this.treeViewer.getTree().deselectAll();
            this.selectedFiles.clear();
            if (this.dialogData != null) {
                this.dialogData.setSelectedFiles(this.selectedFiles);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void fireSystemBrowseEvent(SelectionEvent event) {
        this.dialogData.getSystemSelectedFiles().clear();
        FileDialog dialog = new FileDialog(this.treeViewerComposite.getShell(), 2);
        dialog.setText(Messages.FileDialogTitle);
        dialog.setFilterExtensions(TransformationWizardConstants.EXTENSIONS);
        dialog.setFilterNames(TransformationWizardConstants.EXTENSIONS_NAMES);
        if (this.dialogData != null) {
            if (this.dialogData.dialogSection.get("previousDialogSelection") != null) {
                dialog.setFilterPath(this.dialogData.dialogSection.get("previousDialogSelection"));
            } else {
                String homeFolder = System.getProperty("user.home");
                dialog.setFilterPath(homeFolder);
            }
            this.systemDialogFiles = dialog.open();
            if (this.systemDialogFiles != null) {
                this.dialogData.dialogSection.put("previousDialogSelection", this.systemDialogFiles);
                String[] names = dialog.getFileNames();
                this.systemPaths.clear();
                int i = 0;
                int n = names.length;
                while (i < n) {
                    StringBuffer buf = new StringBuffer(dialog.getFilterPath());
                    if (buf.charAt(buf.length() - 1) != File.separatorChar) {
                        buf.append(File.separatorChar);
                    }
                    buf.append(names[i]);
                    this.systemPaths.add(buf.toString());
                    ++i;
                }
                this.dialogData.getSystemSelectedFiles().clear();
                this.dialogData.setSystemSelectedFiles(this.systemPaths);
            }
        }
        Collection<Object> systemSelection = this.dialogData.getSystemSelectedFiles();
        this.getProjects(systemSelection);
        if (systemSelection.isEmpty()) return;
        if (!this.foundProjects.isEmpty()) {
            for (Object object : this.foundProjects) {
                if (this.isWorkspaceObject(object)) {
                    this.revealSelectedFiles(systemSelection);
                    continue;
                }
                if (!this.importProjects(this.foundProjects)) continue;
                this.revealSelectedFiles(systemSelection);
            }
            return;
        } else {
            if (this.systemDialogFiles == null) return;
            try {
                ArrayList<String> srcFolders = new ArrayList<String>();
                srcFolders.add("src");
                CreateProject placeHolder = new CreateProject(this.dialogData.getSystemSelectedFiles());
                IProject newProject = placeHolder.getCreatedProject();
                ArrayList<Object> revealList = new ArrayList<Object>();
                if (newProject == null) return;
                for (IResource resource : Arrays.asList(newProject.getFolder("resources").members())) {
                    if (!(resource instanceof IFile)) continue;
                    revealList.add((IFile)resource);
                }
                this.revealSelectedFiles(revealList);
                return;
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected boolean isWorkspaceObject(Object object) {
        File file;
        IFile ifile;
        return object instanceof File && (ifile = FileUtil.getIFile((String)(file = (File)object).getAbsolutePath())) != null;
    }

    protected boolean importProjects(Collection<Object> foundProjects) {
        LinkedList<Object> importedProjects = new LinkedList<Object>();
        boolean importStatus = false;
        for (Object object : foundProjects) {
            if (!(object instanceof File)) continue;
            File file = (File)object;
            Path filePath = new Path(file.getAbsolutePath());
            try {
                IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)filePath);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
                importedProjects.add(project);
                project.create(description, null);
                project.open(null);
                importStatus = true;
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        this.dialogData.setImportedProjects(importedProjects);
        return importStatus;
    }

    @Override
    public void dispose() {
        if (this.selectionButtonListener != null) {
            this.selectAllButton.removeSelectionListener(this.selectionButtonListener);
            this.deselectAllButton.removeSelectionListener(this.selectionButtonListener);
        }
        if (this.systemSelectionListener != null) {
            this.systemSelectionButton.removeSelectionListener(this.systemSelectionListener);
        }
        super.dispose();
    }
}

