/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.base;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.base.ILocationStrategy;
import org.eclipse.papyrus.designer.languages.common.base.file.ICleanUntouched;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.GeneratorHint;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class ModelElementsCreator {
    protected IProject project;
    protected ILocationStrategy locStrategy;
    protected IPFileSystemAccess fileSystemAccess;
    protected String generatorLanguage;

    public ModelElementsCreator(IPFileSystemAccess fileSystemAccess, ILocationStrategy locStrategy, String generatorLanguage) {
        this.fileSystemAccess = fileSystemAccess;
        this.locStrategy = locStrategy;
        this.generatorLanguage = generatorLanguage;
    }

    public String getFileName(NamedElement element) {
        return this.locStrategy.getFileName(element);
    }

    protected abstract void createPackageableElementFile(PackageableElement var1, IProgressMonitor var2);

    protected boolean noCodeGen(Element element) {
        return GenUtils.hasStereotype(element, NoCodeGen.class);
    }

    public void createPackageableElement(PackageableElement element, IProgressMonitor monitor) {
        this.createPackageableElement(element, monitor, true);
    }

    public void createPackageableElement(PackageableElement element, IProgressMonitor monitor, boolean recursive) {
        String language;
        if (this.noCodeGen((Element)element)) {
            return;
        }
        GeneratorHint hint = (GeneratorHint)UMLUtil.getStereotypeApplication((Element)element, GeneratorHint.class);
        if (hint != null && hint.getLanguage() != null && (language = hint.getLanguage().getBase_Class().getName()) != null && !language.equals(this.generatorLanguage)) {
            ILangCodegen newGenerator = LanguageCodegen.getGenerator((String)language);
            newGenerator.generateCode(this.project, element, monitor);
            return;
        }
        if (element instanceof Package) {
            Package pkg = (Package)element;
            if (monitor != null) {
                monitor.subTask("generate package " + element.getQualifiedName());
            }
            this.createPackageableElementFile(element, monitor);
            if (recursive) {
                for (PackageableElement subElement : pkg.getPackagedElements()) {
                    this.createPackageableElement(subElement, monitor, recursive);
                }
            }
        } else {
            this.createPackageableElementFile(element, monitor);
        }
    }

    public void removePackageableElement(PackageableElement element, IProgressMonitor monitor) {
        String fileName = this.getFileName((NamedElement)element);
        this.fileSystemAccess.deleteFile(fileName);
    }

    public void cleanUntouched(IFolder folder, IProgressMonitor monitor) {
        this.cleanUntouched(folder, Collections.emptyList(), monitor);
    }

    public void cleanUntouched(IFolder folder, List<String> keepFiles, IProgressMonitor monitor) {
        if (this.fileSystemAccess instanceof ICleanUntouched) {
            try {
                ((ICleanUntouched)((Object)this.fileSystemAccess)).cleanUntouched(folder, keepFiles, monitor);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

